/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.containers.Interner;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptorImpl;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRootProxyDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRuleProxyDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxScopeProxyDescriptor;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class TextMateSyntaxTable {
    private static final LoggerRt LOG = LoggerRt.getInstance(TextMateSyntaxTable.class);
    private final Map<CharSequence, SyntaxNodeDescriptor> rulesMap = new ConcurrentHashMap<CharSequence, SyntaxNodeDescriptor>();
    private Object2IntMap<String> ruleIds;

    public synchronized void compact() {
        this.ruleIds = null;
    }

    @Nullable
    public CharSequence loadSyntax(Plist plist2, @NotNull Interner<CharSequence> interner) {
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(0);
        }
        return this.loadRealNode(plist2, null, interner).getScopeName();
    }

    @NotNull
    public SyntaxNodeDescriptor getSyntax(CharSequence scopeName) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.rulesMap.get(scopeName);
        if (syntaxNodeDescriptor == null) {
            LOG.info("Can't find syntax node for scope: '" + scopeName + "'");
            SyntaxNodeDescriptor syntaxNodeDescriptor2 = SyntaxNodeDescriptor.EMPTY_NODE;
            if (syntaxNodeDescriptor2 == null) {
                TextMateSyntaxTable.$$$reportNull$$$0(1);
            }
            return syntaxNodeDescriptor2;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor3 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor3 == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(2);
        }
        return syntaxNodeDescriptor3;
    }

    public void clear() {
        this.rulesMap.clear();
    }

    private SyntaxNodeDescriptor loadNestedSyntax(@NotNull Plist plist2, @NotNull SyntaxNodeDescriptor parentNode, @NotNull Interner<CharSequence> interner) {
        if (plist2 == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(3);
        }
        if (parentNode == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(4);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(5);
        }
        return plist2.contains("include") ? this.loadProxyNode(plist2, parentNode, interner) : this.loadRealNode(plist2, parentNode, interner);
    }

    @NotNull
    private SyntaxNodeDescriptor loadRealNode(@NotNull Plist plist2, @Nullable SyntaxNodeDescriptor parentNode, @NotNull Interner<CharSequence> interner) {
        PListValue scopeNameValue;
        if (plist2 == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(6);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(7);
        }
        CharSequence scopeName = (scopeNameValue = plist2.getPlistValue(Constants.StringKey.SCOPE_NAME.value)) != null ? (CharSequence)interner.intern((Object)scopeNameValue.getString()) : null;
        SyntaxNodeDescriptorImpl result = new SyntaxNodeDescriptorImpl(scopeName, parentNode);
        if (scopeName != null) {
            this.rulesMap.put(scopeName, result);
        }
        for (Map.Entry<String, PListValue> entry : plist2.entries()) {
            PListValue pListValue = entry.getValue();
            if (pListValue == null) continue;
            String key = entry.getKey();
            Constants.StringKey stringKey = Constants.StringKey.fromName(key);
            if (stringKey != null) {
                String stringValue = pListValue.getString();
                if (stringValue == null) continue;
                result.setStringAttribute(stringKey, (CharSequence)interner.intern((Object)stringValue));
                continue;
            }
            Constants.CaptureKey captureKey = Constants.CaptureKey.fromName(key);
            if (captureKey != null) {
                result.setCaptures(captureKey, TextMateSyntaxTable.loadCaptures(pListValue.getPlist(), interner));
                continue;
            }
            if ("repository".equalsIgnoreCase(key)) {
                this.loadRepository(result, pListValue, interner);
                continue;
            }
            if ("patterns".equalsIgnoreCase(key)) {
                this.loadPatterns(result, pListValue, interner);
                continue;
            }
            if (!"injections".equalsIgnoreCase(key)) continue;
            this.loadInjections(result, pListValue, interner);
        }
        result.compact();
        SyntaxNodeDescriptorImpl syntaxNodeDescriptorImpl = result;
        if (syntaxNodeDescriptorImpl == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(8);
        }
        return syntaxNodeDescriptorImpl;
    }

    @Nullable
    private static Int2ObjectMap<CharSequence> loadCaptures(@NotNull Plist captures, @NotNull Interner<CharSequence> interner) {
        if (captures == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(9);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(10);
        }
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        for (Map.Entry<String, PListValue> capture : captures.entries()) {
            try {
                int index = Integer.parseInt(capture.getKey());
                Plist captureDict = capture.getValue().getPlist();
                String captureName = captureDict.getPlistValue("name", "").getString();
                result.put(index, (Object)((CharSequence)interner.intern((Object)captureName)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (result.isEmpty()) {
            return null;
        }
        result.trim();
        return result;
    }

    private SyntaxNodeDescriptor loadProxyNode(@NotNull Plist plist2, @NotNull SyntaxNodeDescriptor result, @NotNull Interner<CharSequence> interner) {
        String include;
        if (plist2 == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(11);
        }
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(12);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(13);
        }
        if (!(include = plist2.getPlistValue("include", "").getString()).isEmpty() && include.charAt(0) == '#') {
            return new SyntaxRuleProxyDescriptor(this.getRuleId(include.substring(1)), result);
        }
        if ("$self".equalsIgnoreCase(include) || "$base".equalsIgnoreCase(include)) {
            return new SyntaxRootProxyDescriptor(result);
        }
        int i = include.indexOf(35);
        String scope = i >= 0 ? include.subSequence(0, i) : include;
        String ruleId = i >= 0 ? include.substring(i + 1) : "";
        return new SyntaxScopeProxyDescriptor((CharSequence)interner.intern((Object)scope), ruleId.isEmpty() ? -1 : this.getRuleId(ruleId), this, result);
    }

    private void loadPatterns(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(14);
        }
        if (pListValue == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(15);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(16);
        }
        for (PListValue value : pListValue.getArray()) {
            result.addChild(this.loadNestedSyntax(value.getPlist(), result, interner));
        }
    }

    private void loadRepository(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(17);
        }
        if (pListValue == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(18);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(19);
        }
        for (Map.Entry<String, PListValue> repoEntry : pListValue.getPlist().entries()) {
            PListValue repoEntryValue = repoEntry.getValue();
            if (repoEntryValue == null) continue;
            result.appendRepository(this.getRuleId(repoEntry.getKey()), this.loadNestedSyntax(repoEntryValue.getPlist(), result, interner));
        }
    }

    private synchronized int getRuleId(@NotNull String ruleName) {
        int id;
        if (ruleName == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(20);
        }
        if (this.ruleIds == null) {
            this.ruleIds = new Object2IntOpenHashMap();
        }
        if ((id = this.ruleIds.getInt((Object)ruleName)) > 0) {
            return id;
        }
        int newId = this.ruleIds.size() + 1;
        this.ruleIds.put((Object)ruleName, newId);
        return newId;
    }

    private void loadInjections(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(21);
        }
        if (pListValue == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(22);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(23);
        }
        for (Map.Entry<String, PListValue> injectionEntry : pListValue.getPlist().entries()) {
            Plist injectionEntryValue = injectionEntry.getValue().getPlist();
            result.addInjection(new InjectionNodeDescriptor(injectionEntry.getKey(), this.loadRealNode(injectionEntryValue, result, interner)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captures";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pListValue";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntax";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRealNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadSyntax";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadNestedSyntax";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadRealNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadCaptures";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadProxyNode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPatterns";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadRepository";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRuleId";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadInjections";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8 -> new IllegalStateException(string);
        };
    }
}

