/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateBlockCommentPair;
import org.jetbrains.plugins.textmate.language.TextMateCommentPrefixes;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class PreferencesReadUtil {
    @Nullable
    public static Map.Entry<String, Plist> retrieveSettingsPlist(Plist rootPlist) {
        String scopeName = null;
        Plist settingsValuePlist = null;
        PListValue value = rootPlist.getPlistValue("scope");
        if (value != null) {
            scopeName = value.getString();
            PListValue settingsValue = rootPlist.getPlistValue("settings");
            if (scopeName != null && !scopeName.isEmpty() && settingsValue != null) {
                settingsValuePlist = settingsValue.getPlist();
            }
        }
        return settingsValuePlist != null ? Map.entry(scopeName, settingsValuePlist) : null;
    }

    @Nullable
    public static Set<TextMateBracePair> readPairs(@Nullable PListValue pairsValue) {
        if (pairsValue == null) {
            return null;
        }
        HashSet result = new HashSet();
        List<PListValue> pairs = pairsValue.getArray();
        for (PListValue pair : pairs) {
            List<PListValue> chars = pair.getArray();
            if (chars.size() != 2) continue;
            String left = chars.get(0).getString();
            String right = chars.get(1).getString();
            if (left.length() != 1 || right.length() != 1) continue;
            result.add(new TextMateBracePair(left.charAt(0), right.charAt(0)));
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    @Nullable
    private static TextMateSnippet loadTextMateSnippet(@NotNull Plist plist2, @NotNull String explicitUuid, @NotNull Interner<CharSequence> interner) {
        if (plist2 == null) {
            PreferencesReadUtil.$$$reportNull$$$0(0);
        }
        if (explicitUuid == null) {
            PreferencesReadUtil.$$$reportNull$$$0(1);
        }
        if (interner == null) {
            PreferencesReadUtil.$$$reportNull$$$0(2);
        }
        String name = plist2.getPlistValue("name", "").getString();
        String key = plist2.getPlistValue("tabTrigger", "").getString();
        String content = plist2.getPlistValue(Constants.StringKey.CONTENT.value, "").getString();
        String scope = plist2.getPlistValue("scope", "").getString();
        String description = plist2.getPlistValue("description", "").getString();
        String uuid = plist2.getPlistValue("uuid", explicitUuid).getString();
        if (!key.isEmpty() && !content.isEmpty()) {
            if (name.isEmpty()) {
                name = key;
            }
            return new TextMateSnippet(key, content, (CharSequence)interner.intern((Object)scope), name, description, uuid);
        }
        return null;
    }

    @NotNull
    public static <K, V> Map<K, V> compactMap(@NotNull Map<K, V> map) {
        if (map == null) {
            PreferencesReadUtil.$$$reportNull$$$0(3);
        }
        if (map.isEmpty()) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                PreferencesReadUtil.$$$reportNull$$$0(4);
            }
            return map2;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> singleEntry = map.entrySet().iterator().next();
            Map<K, V> map3 = Collections.singletonMap(singleEntry.getKey(), singleEntry.getValue());
            if (map3 == null) {
                PreferencesReadUtil.$$$reportNull$$$0(5);
            }
            return map3;
        }
        if (!(map instanceof HashMap)) {
            Map<K, V> map4 = map;
            if (map4 == null) {
                PreferencesReadUtil.$$$reportNull$$$0(6);
            }
            return map4;
        }
        HashMap<K, V> result = new HashMap<K, V>(map.size(), 1.0f);
        result.putAll(map);
        HashMap<K, V> hashMap = result;
        if (hashMap == null) {
            PreferencesReadUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    private PreferencesReadUtil() {
    }

    @Deprecated
    @Nullable
    public static TextMateSnippet loadSnippet(@NotNull File snippetFile, @NotNull Plist plist2, @NotNull Interner<CharSequence> interner) {
        if (snippetFile == null) {
            PreferencesReadUtil.$$$reportNull$$$0(8);
        }
        if (plist2 == null) {
            PreferencesReadUtil.$$$reportNull$$$0(9);
        }
        if (interner == null) {
            PreferencesReadUtil.$$$reportNull$$$0(10);
        }
        return snippetFile.getName().endsWith(".sublime-snippet") ? null : PreferencesReadUtil.loadTextMateSnippet(plist2, snippetFile.getAbsolutePath(), interner);
    }

    @Nullable
    private static String getPattern(@NotNull String name, @NotNull Plist from) {
        PListValue value;
        if (name == null) {
            PreferencesReadUtil.$$$reportNull$$$0(11);
        }
        if (from == null) {
            PreferencesReadUtil.$$$reportNull$$$0(12);
        }
        if ((value = from.getPlistValue(name)) == null) {
            return null;
        }
        return value.getString();
    }

    @NotNull
    public static IndentationRules loadIndentationRules(@NotNull Plist plist2) {
        PListValue rulesValue;
        if (plist2 == null) {
            PreferencesReadUtil.$$$reportNull$$$0(13);
        }
        if ((rulesValue = plist2.getPlistValue("indentationRules")) == null) {
            IndentationRules indentationRules = IndentationRules.empty();
            if (indentationRules == null) {
                PreferencesReadUtil.$$$reportNull$$$0(14);
            }
            return indentationRules;
        }
        Plist rules = rulesValue.getPlist();
        return new IndentationRules(PreferencesReadUtil.getPattern("increaseIndentPattern", rules), PreferencesReadUtil.getPattern("decreaseIndentPattern", rules), PreferencesReadUtil.getPattern("indentNextLinePattern", rules), PreferencesReadUtil.getPattern("unIndentedLinePattern", rules));
    }

    @NotNull
    public static TextMateCommentPrefixes readCommentPrefixes(@NotNull ShellVariablesRegistry registry, @NotNull TextMateScope scope) {
        if (registry == null) {
            PreferencesReadUtil.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            PreferencesReadUtil.$$$reportNull$$$0(16);
        }
        String lineCommentPrefix = null;
        TextMateBlockCommentPair blockCommentPair = null;
        int index = 1;
        while (lineCommentPrefix == null || blockCommentPair == null) {
            Object variableSuffix = index > 1 ? "_" + index : "";
            TextMateShellVariable start = registry.getVariableValue("TM_COMMENT_START" + (String)variableSuffix, scope);
            TextMateShellVariable end = registry.getVariableValue("TM_COMMENT_END" + (String)variableSuffix, scope);
            ++index;
            if (start == null) break;
            if (!(end != null && end.scopeName.equals(start.scopeName) || lineCommentPrefix != null)) {
                lineCommentPrefix = start.value;
            }
            if (end == null || !end.scopeName.equals(start.scopeName) || blockCommentPair != null) continue;
            blockCommentPair = new TextMateBlockCommentPair(start.value, end.value);
        }
        return new TextMateCommentPrefixes(lineCommentPrefix, blockCommentPair);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitUuid";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/PreferencesReadUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippetFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/PreferencesReadUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "compactMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadIndentationRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadTextMateSnippet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compactMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadSnippet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadIndentationRules";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readCommentPrefixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 14 -> new IllegalStateException(string);
        };
    }
}

