/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Perl5Matcher;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.config.DefaultProxyGroup;
import org.jetbrains.idea.svn.config.MyIni;
import org.jetbrains.idea.svn.config.ProxyGroup;
import org.jetbrains.idea.svn.config.SvnIniFileKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bJ&\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\t2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tJ\u001a\u0010\"\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010 \u001a\u00020\t2\u0006\u0010#\u001a\u00020\tJ\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\b\b\u0001\u0010 \u001a\u00020\tJD\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'2\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001bJ\"\u0010,\u001a\u00020\u001b2\b\b\u0001\u0010 \u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\tJ\u0012\u0010.\u001a\u00020\u001b2\b\b\u0002\u0010/\u001a\u00020*H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/idea/svn/config/SvnIniFile;", "", "myPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "_configFile", "Lorg/jetbrains/idea/svn/config/MyIni;", "allGroups", "", "", "Lorg/jetbrains/idea/svn/config/ProxyGroup;", "getAllGroups", "()Ljava/util/Map;", "configFile", "Lorg/ini4j/Ini;", "getConfigFile", "()Lorg/ini4j/Ini;", "defaultGroup", "Lorg/jetbrains/idea/svn/config/DefaultProxyGroup;", "getDefaultGroup", "()Lorg/jetbrains/idea/svn/config/DefaultProxyGroup;", "myDefaultProperties", "", "myLatestUpdate", "", "myPatternsMap", "addGroup", "", "name", "patterns", "properties", "addProperties", "groupName", "deleteGroup", "getValue", "propertyName", "getValues", "modifyGroup", "delete", "", "addOrModify", "isDefault", "", "save", "setValue", "value", "updateGroups", "force", "Companion", "intellij.vcs.svn"})
public final class SvnIniFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path myPath;
    @NotNull
    private final Map<String, String> myPatternsMap;
    private long myLatestUpdate;
    @NotNull
    private final Map<String, String> myDefaultProperties;
    @NotNull
    private final MyIni _configFile;
    @NonNls
    @NotNull
    public static final String SERVERS_FILE_NAME = "servers";
    @NonNls
    @NotNull
    public static final String CONFIG_FILE_NAME = "config";

    /*
     * WARNING - void declaration
     */
    public SvnIniFile(@NotNull Path myPath) {
        void $this$_configFile_u24lambda_u240;
        MyIni myIni;
        Intrinsics.checkNotNullParameter((Object)myPath, (String)"myPath");
        this.myPath = myPath;
        this.myPatternsMap = new LinkedHashMap();
        this.myLatestUpdate = -1L;
        this.myDefaultProperties = new LinkedHashMap();
        MyIni myIni2 = myIni = new MyIni();
        SvnIniFile svnIniFile = this;
        boolean bl = false;
        $this$_configFile_u24lambda_u240.getConfig().setTree(false);
        $this$_configFile_u24lambda_u240.getConfig().setEmptySection(true);
        svnIniFile._configFile = myIni;
    }

    private final Ini getConfigFile() {
        SvnIniFile.updateGroups$default(this, false, 1, null);
        return this._configFile;
    }

    @NotNull
    public final Map<String, ProxyGroup> getAllGroups() {
        HashMap<String, ProxyGroup> result = new HashMap<String, ProxyGroup>(this.myPatternsMap.size());
        for (Map.Entry<String, String> entry : this.myPatternsMap.entrySet()) {
            String groupName = entry.getKey();
            String value = entry.getValue();
            result.put(groupName, new ProxyGroup(groupName, value, this.getValues(groupName)));
        }
        return result;
    }

    @NotNull
    public final DefaultProxyGroup getDefaultGroup() {
        return new DefaultProxyGroup(this.myDefaultProperties);
    }

    @JvmOverloads
    public final void updateGroups(boolean force) {
        long l;
        try {
            l = Files.getLastModifiedTime(this.myPath, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            l = 0L;
        }
        long lastModified = l;
        if (force || this.myLatestUpdate != lastModified) {
            this._configFile.clear();
            try {
                this._configFile.load(this.myPath.toFile());
            }
            catch (IOException e) {
                SvnIniFileKt.access$getLOG$p().info("Could not load " + this.myPath, (Throwable)e);
            }
            this.myLatestUpdate = lastModified;
            this.myPatternsMap.clear();
            this.myPatternsMap.putAll(this.getValues("groups"));
            this.myDefaultProperties.clear();
            this.myDefaultProperties.putAll(this.getValues("global"));
        }
    }

    public static /* synthetic */ void updateGroups$default(SvnIniFile svnIniFile, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        svnIniFile.updateGroups(bl);
    }

    @Nullable
    public final String getValue(@NonNls @NotNull String groupName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.getConfigFile().get((Object)groupName, (Object)propertyName);
    }

    @NotNull
    public final Map<String, String> getValues(@NonNls @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Profile.Section section = (Profile.Section)this.getConfigFile().get((Object)groupName);
        return section == null ? MapsKt.emptyMap() : (Map)section;
    }

    public final void setValue(@NonNls @NotNull String groupName, @NotNull String propertyName, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.getConfigFile().put(groupName, propertyName, (Object)value);
    }

    public final void deleteGroup(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)"global", (Object)name)) {
            this.myDefaultProperties.clear();
        }
        this.setValue("groups", name, null);
        this.getConfigFile().remove((Object)name);
    }

    public final void addGroup(@NotNull String name, @Nullable String patterns, @NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.setValue("groups", name, patterns);
        this.addProperties(name, properties);
    }

    private final void addProperties(String groupName, Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.setValue(groupName, key, value);
        }
    }

    public final void modifyGroup(@NotNull String name, @Nullable String patterns, @NotNull Collection<String> delete, @NotNull Map<String, String> addOrModify, boolean isDefault) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(delete, (String)"delete");
        Intrinsics.checkNotNullParameter(addOrModify, (String)"addOrModify");
        if (!isDefault) {
            this.setValue("groups", name, patterns);
        }
        HashMap<String, Object> deletedPrepared = new HashMap<String, Object>(delete.size());
        for (String property : delete) {
            deletedPrepared.put(property, null);
        }
        this.addProperties(name, (Map<String, String>)deletedPrepared);
        this.addProperties(name, addOrModify);
    }

    public final void save() {
        try {
            this._configFile.store(this.myPath.toFile());
            this.updateGroups(true);
        }
        catch (IOException e) {
            SvnIniFileKt.access$getLOG$p().info("Could not save " + this.myPath, (Throwable)e);
        }
    }

    @JvmOverloads
    public final void updateGroups() {
        SvnIniFile.updateGroups$default(this, false, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final String getNewGroupName(@NotNull String host, @NotNull SvnIniFile configFile) {
        return Companion.getNewGroupName(host, configFile);
    }

    @JvmStatic
    @Nullable
    public static final String getPropertyIdea(@NotNull String host, @NotNull Couple<SvnIniFile> serversFile, @NotNull String name) {
        return Companion.getPropertyIdea(host, serversFile, name);
    }

    @JvmStatic
    public static final boolean checkHostGroup(@NotNull String url, @Nullable String patterns, @Nullable String exceptions) {
        return Companion.checkHostGroup(url, patterns, exceptions);
    }

    @JvmStatic
    @Nullable
    public static final String getGroupForHost(@NotNull String host, @NotNull SvnIniFile serversFile) {
        return Companion.getGroupForHost(host, serversFile);
    }

    @JvmStatic
    public static final boolean isTurned(@Nullable String value, boolean nullValue) {
        return Companion.isTurned(value, nullValue);
    }

    @JvmStatic
    @Nullable
    public static final String getValue(@NotNull Couple<SvnIniFile> files, @NonNls @NotNull String groupName, @NotNull String propertyName) {
        return Companion.getValue(files, groupName, propertyName);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getValues(@NotNull Couple<SvnIniFile> files, @NotNull String groupName) {
        return Companion.getValues(files, groupName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J(\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00112\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000eH\u0007J(\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J*\u0010\u0017\u001a\u0004\u0018\u00010\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J,\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u001a\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0007H\u0007J\u001a\u0010\u001f\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/svn/config/SvnIniFile$Companion;", "", "()V", "CONFIG_FILE_NAME", "", "SERVERS_FILE_NAME", "checkHostGroup", "", "url", "patterns", "exceptions", "getGroupForHost", "host", "serversFile", "Lorg/jetbrains/idea/svn/config/SvnIniFile;", "getGroupName", "groups", "", "getNewGroupName", "configFile", "getPropertyIdea", "Lcom/intellij/openapi/util/Couple;", "name", "getValue", "files", "groupName", "propertyName", "getValues", "isTurned", "value", "nullValue", "matches", "matchesPattern", "pattern", "intellij.vcs.svn"})
    @SourceDebugExtension(value={"SMAP\nSvnIniFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvnIniFile.kt\norg/jetbrains/idea/svn/config/SvnIniFile$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n1747#2,3:275\n1747#2,3:278\n*S KotlinDebug\n*F\n+ 1 SvnIniFile.kt\norg/jetbrains/idea/svn/config/SvnIniFile$Companion\n*L\n170#1:275,3\n197#1:278,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getNewGroupName(@NotNull String host, @NotNull SvnIniFile configFile) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Object groupName = host;
            Map<String, ProxyGroup> groups = configFile.getAllGroups();
            while (StringUtil.isEmptyOrSpaces((String)groupName) || groups.containsKey(groupName)) {
                groupName = (String)groupName + "1";
            }
            return groupName;
        }

        @JvmStatic
        @Nullable
        public final String getPropertyIdea(@NotNull String host, @NotNull Couple<SvnIniFile> serversFile, @NotNull String name) {
            Map<String, String> hostProps;
            String value;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(serversFile, (String)"serversFile");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String groupName = this.getGroupName(this.getValues(serversFile, "groups"), host);
            if (groupName != null && (value = (hostProps = this.getValues(serversFile, groupName)).get(name)) != null) {
                return value;
            }
            return this.getValues(serversFile, "global").get(name);
        }

        @JvmStatic
        public final boolean checkHostGroup(@NotNull String url, @Nullable String patterns, @Nullable String exceptions) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Url svnurl = null;
            try {
                Url url2 = SvnUtil.createUrl(url);
                Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"createUrl(url)");
                svnurl = url2;
            }
            catch (SvnBindException e) {
                return false;
            }
            String host = svnurl.getHost();
            return this.matches(patterns, host) && !this.matches(exceptions, host);
        }

        private final boolean matches(String patterns, String host) {
            boolean bl;
            block4: {
                String string = patterns;
                if (string == null) {
                    string = "";
                }
                char[] cArray = new char[]{','};
                Iterable $this$any$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Companion.matchesPattern(((Object)StringsKt.trim((CharSequence)it)).toString(), host)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchesPattern(String pattern, String host) {
            boolean bl;
            try {
                bl = new Perl5Matcher().matches(host, new GlobCompiler().compile(pattern));
            }
            catch (MalformedPatternException e) {
                SvnIniFileKt.access$getLOG$p().debug("Could not compile pattern " + pattern, (Throwable)e);
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        @Nullable
        public final String getGroupForHost(@NotNull String host, @NotNull SvnIniFile serversFile) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)serversFile, (String)"serversFile");
            Map<String, ProxyGroup> groups = serversFile.getAllGroups();
            for (Map.Entry<String, ProxyGroup> entry : groups.entrySet()) {
                String key = entry.getKey();
                ProxyGroup value = entry.getValue();
                if (!this.matches(value.getPatterns(), host)) continue;
                return key;
            }
            return null;
        }

        private final String getGroupName(Map<String, String> groups, String host) {
            for (Map.Entry<String, String> entry : groups.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!this.matches(value, host)) continue;
                return key;
            }
            return null;
        }

        @JvmStatic
        public final boolean isTurned(@Nullable String value, boolean nullValue) {
            boolean bl;
            block5: {
                if (value == null) {
                    bl = nullValue;
                } else {
                    Iterable $this$any$iv = SvnIniFileKt.access$getTRUE_VALUES$p();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it, (String)value, (boolean)true)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
            }
            return bl;
        }

        @JvmStatic
        @Nullable
        public final String getValue(@NotNull Couple<SvnIniFile> files, @NonNls @NotNull String groupName, @NotNull String propertyName) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            String string = ((SvnIniFile)files.second).getValue(groupName, propertyName);
            if (string == null) {
                string = ((SvnIniFile)files.first).getValue(groupName, propertyName);
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> getValues(@NotNull Couple<SvnIniFile> files, @NotNull String groupName) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            Map map = ContainerUtil.union(((SvnIniFile)files.first).getValues(groupName), ((SvnIniFile)files.second).getValues(groupName));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"union(files.first.getVal\u2026ond.getValues(groupName))");
            return map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

