/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.component;

import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.util.ActionUtilKt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.component.GHErrorPanelModel;
import org.jetbrains.plugins.github.ui.component.GHImmutableErrorPanelModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel;", "", "()V", "ERROR_ACTION_HREF", "", "create", "Ljavax/swing/JComponent;", "errorPrefix", "error", "", "errorAction", "Ljavax/swing/Action;", "horizontalAlignment", "", "model", "Lorg/jetbrains/plugins/github/ui/component/GHErrorPanelModel;", "getLoadingErrorText", "Controller", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHHtmlErrorPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHHtmlErrorPanel.kt\norg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 GHHtmlErrorPanel.kt\norg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel\n*L\n107#1:118\n107#1:119,3\n*E\n"})
public final class GHHtmlErrorPanel {
    @NotNull
    public static final GHHtmlErrorPanel INSTANCE = new GHHtmlErrorPanel();
    @NotNull
    private static final String ERROR_ACTION_HREF = "ERROR_ACTION";

    private GHHtmlErrorPanel() {
    }

    @NotNull
    public final JComponent create(@NotNull String errorPrefix, @NotNull Throwable error, @Nullable Action errorAction, int horizontalAlignment) {
        Intrinsics.checkNotNullParameter((Object)errorPrefix, (String)"errorPrefix");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        GHImmutableErrorPanelModel model2 = new GHImmutableErrorPanelModel(errorPrefix, error, errorAction);
        return this.create(model2, horizontalAlignment);
    }

    public static /* synthetic */ JComponent create$default(GHHtmlErrorPanel gHHtmlErrorPanel, String string, Throwable throwable, Action action2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            action2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return gHHtmlErrorPanel.create(string, throwable, action2, n);
    }

    @NotNull
    public final JComponent create(@NotNull GHErrorPanelModel model2, int horizontalAlignment) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        JEditorPane $this$create_u24lambda_u241 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, (int)13, null);
        boolean bl = false;
        $this$create_u24lambda_u241.setForeground(NamedColorUtil.getErrorForeground());
        $this$create_u24lambda_u241.setFocusable(true);
        $this$create_u24lambda_u241.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(model2, $this$create_u24lambda_u241){
            final /* synthetic */ GHErrorPanelModel $model;
            final /* synthetic */ JEditorPane $this_apply;
            {
                this.$model = $model;
                this.$this_apply = $receiver;
            }

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!Intrinsics.areEqual((Object)e.getDescription(), (Object)"ERROR_ACTION")) break block1;
                    Action action2 = this.$model.getErrorAction();
                    if (action2 != null) {
                        action2.actionPerformed(new ActionEvent(this.$this_apply, 1001, "perform"));
                    }
                }
            }
        });
        $this$create_u24lambda_u241.registerKeyboardAction(arg_0 -> GHHtmlErrorPanel.create$lambda$1$lambda$0(model2, arg_0), KeyStroke.getKeyStroke(10, 0), 0);
        JEditorPane pane2 = jEditorPane;
        new Controller(model2, pane2, horizontalAlignment);
        return pane2;
    }

    public static /* synthetic */ JComponent create$default(GHHtmlErrorPanel gHHtmlErrorPanel, GHErrorPanelModel gHErrorPanelModel, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return gHHtmlErrorPanel.create(gHErrorPanelModel, n);
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String getLoadingErrorText(Throwable error) {
        String string;
        if (error instanceof GithubStatusCodeException && ((GithubStatusCodeException)error).getError() != null) {
            GithubErrorMessage githubErrorMessage = ((GithubStatusCodeException)error).getError();
            Intrinsics.checkNotNull((Object)githubErrorMessage);
            if (githubErrorMessage.getMessage() != null) {
                List list;
                GithubErrorMessage githubErrorMessage2 = ((GithubStatusCodeException)error).getError();
                Intrinsics.checkNotNull((Object)githubErrorMessage2);
                GithubErrorMessage githubError = githubErrorMessage2;
                String string2 = githubError.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                String message = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string2, (CharSequence)"["), (CharSequence)"]");
                HtmlBuilder builder = new HtmlBuilder().append(message);
                if (StringsKt.startsWith((String)message, (String)"Could not resolve to a Repository", (boolean)true)) {
                    String explanation = " Either repository doesn't exist or you don't have access. The most probable cause is that OAuth App access restrictions are enabled in organization.";
                    builder.append(explanation);
                }
                List<GithubErrorMessage.Error> list2 = githubError.getErrors();
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void e;
                        GithubErrorMessage.Error error2 = (GithubErrorMessage.Error)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string3 = e.getMessage();
                        if (string3 == null) {
                            Object[] objectArray = new Object[3];
                            objectArray[0] = e.getCode();
                            objectArray[1] = e.getResource();
                            String string4 = e.getField();
                            if (string4 == null) {
                                string4 = "";
                            }
                            objectArray[2] = string4;
                            string3 = GithubBundle.message("gql.error.in.field", objectArray);
                        }
                        collection.add(HtmlChunk.text((String)string3));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                List errors = list;
                Collection collection = errors;
                if (!(collection == null || collection.isEmpty())) {
                    builder.append(": ").append((HtmlChunk)HtmlChunk.br()).appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)errors);
                }
                String string5 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"builder.toString()");
                return string5;
            }
        }
        if ((string = error.getMessage()) == null) {
            String string6 = GithubBundle.message("unknown.loading.error", new Object[0]);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"unknown.loading.error\")");
        }
        return string;
    }

    private static final void create$lambda$1$lambda$0(GHErrorPanelModel $model, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
            Action action2 = $model.getErrorAction();
            if (action2 == null) break block0;
            action2.actionPerformed(it);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\r\u001a\u00020\u000e*\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/ui/component/GHHtmlErrorPanel$Controller;", "", "model", "Lorg/jetbrains/plugins/github/ui/component/GHErrorPanelModel;", "pane", "Ljavax/swing/JEditorPane;", "horizontalAlignment", "", "(Lorg/jetbrains/plugins/github/ui/component/GHErrorPanelModel;Ljavax/swing/JEditorPane;I)V", "alignmentText", "", "update", "", "appendP", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "chunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "text", "intellij.vcs.github"})
    private static final class Controller {
        @NotNull
        private final GHErrorPanelModel model;
        @NotNull
        private final JEditorPane pane;
        @NotNull
        private final String alignmentText;

        public Controller(@NotNull GHErrorPanelModel model2, @NotNull JEditorPane pane2, int horizontalAlignment) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
            this.model = model2;
            this.pane = pane2;
            this.alignmentText = switch (horizontalAlignment) {
                case 2 -> "left";
                case 4 -> "right";
                default -> "center";
            };
            this.model.addAndInvokeChangeEventListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((Controller)this.receiver).update();
                }
            }));
        }

        private final void update() {
            Throwable error = this.model.getError();
            if (error != null) {
                this.pane.setVisible(true);
                HtmlBuilder errorTextBuilder = this.appendP(this.appendP(new HtmlBuilder(), this.model.getErrorPrefix()), INSTANCE.getLoadingErrorText(error));
                Action errorAction = this.model.getErrorAction();
                if (errorAction != null) {
                    HtmlBuilder htmlBuilder = errorTextBuilder.br();
                    Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"errorTextBuilder.br()");
                    String string = ActionUtilKt.getName((Action)errorAction);
                    if (string == null) {
                        string = "";
                    }
                    HtmlChunk.Element element = HtmlChunk.link((String)GHHtmlErrorPanel.ERROR_ACTION_HREF, (String)string);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(ERROR_ACTION_HREF, \u2026rorAction.name.orEmpty())");
                    this.appendP(htmlBuilder, (HtmlChunk)element);
                }
                String string = errorTextBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorTextBuilder.toString()");
                HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)this.pane, (String)string);
            } else {
                this.pane.setVisible(false);
                HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)this.pane, (String)"");
            }
            this.pane.setSize(0x3FFFFFFF, 0x3FFFFFFF);
        }

        private final HtmlBuilder appendP(HtmlBuilder $this$appendP, HtmlChunk chunk) {
            HtmlBuilder htmlBuilder = $this$appendP.append((HtmlChunk)HtmlChunk.p().attr("align", this.alignmentText).child(chunk));
            Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"append(HtmlChunk.p().att\u2026gnmentText).child(chunk))");
            return htmlBuilder;
        }

        private final HtmlBuilder appendP(HtmlBuilder $this$appendP, @Nls String text) {
            HtmlChunk htmlChunk = HtmlChunk.text((String)text);
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(text)");
            return this.appendP($this$appendP, htmlChunk);
        }
    }
}

