/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.action.ImmutableToolbarLabelAction;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import git4idea.changes.GitBranchComparisonResult;
import git4idea.changes.GitBranchComparisonResultKt;
import git4idea.changes.GitTextFilePatchWithHistory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupport;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupportImpl;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsReloadAction;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRDiffRequestChainProducer;
import org.jetbrains.plugins.github.util.ChangeDiffRequestProducerFactory;
import org.jetbrains.plugins.github.util.DiffRequestChainProducer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J \u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JJ\u0010$\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0(H\u0002R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRDiffRequestChainProducer;", "Lorg/jetbrains/plugins/github/util/DiffRequestChainProducer;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "currentUser", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/api/data/GHUser;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "changeProducerFactory", "Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;", "getChangeProducerFactory$intellij_vcs_github", "()Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;", "createCustomContext", "", "Lcom/intellij/openapi/util/Key;", "", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "changes", "Lcom/intellij/openapi/ListSelection;", "getReviewSupport", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHPRDiffReviewSupport;", "changesProvider", "Lgit4idea/changes/GitBranchComparisonResult;", "loadRequestDataKeys", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "changesProviderFuture", "Ljava/util/concurrent/CompletableFuture;", "fetchFuture", "Ljava/lang/Void;", "intellij.vcs.github"})
public class GHPRDiffRequestChainProducer
implements DiffRequestChainProducer {
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRDataProvider dataProvider;
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHUser ghostUser;
    @NotNull
    private final GHUser currentUser;
    @NotNull
    private final ChangeDiffRequestProducerFactory changeProducerFactory;

    public GHPRDiffRequestChainProducer(@NotNull Project project, @NotNull GHPRDataProvider dataProvider, @NotNull AsyncHtmlImageLoader htmlImageLoader, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHUser ghostUser, @NotNull GHUser currentUser) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)htmlImageLoader, (String)"htmlImageLoader");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        Intrinsics.checkNotNullParameter((Object)ghostUser, (String)"ghostUser");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        this.project = project;
        this.dataProvider = dataProvider;
        this.htmlImageLoader = htmlImageLoader;
        this.avatarIconsProvider = avatarIconsProvider;
        this.repositoryDataService = repositoryDataService;
        this.ghostUser = ghostUser;
        this.currentUser = currentUser;
        this.changeProducerFactory = (arg_0, arg_1) -> GHPRDiffRequestChainProducer.changeProducerFactory$lambda$0(this, arg_0, arg_1);
    }

    @NotNull
    public final ChangeDiffRequestProducerFactory getChangeProducerFactory$intellij_vcs_github() {
        return this.changeProducerFactory;
    }

    @Override
    @NotNull
    public DiffRequestChain getRequestChain(@NotNull ListSelection<Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        return (DiffRequestChain)new AsyncDiffRequestChain(changes, this){
            final /* synthetic */ ListSelection<Change> $changes;
            final /* synthetic */ GHPRDiffRequestChainProducer this$0;
            {
                this.$changes = $changes;
                this.this$0 = $receiver;
            }

            @NotNull
            protected ListSelection<? extends DiffRequestProducer> loadRequestProducers() {
                ListSelection listSelection = this.$changes.map(arg_0 -> getRequestChain.1.loadRequestProducers$lambda$0((Function1)new Function1<Change, DiffRequestProducer>(this.this$0){
                    final /* synthetic */ GHPRDiffRequestChainProducer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final DiffRequestProducer invoke(Change change) {
                        ChangeDiffRequestProducerFactory changeDiffRequestProducerFactory = this.this$0.getChangeProducerFactory$intellij_vcs_github();
                        Project project = GHPRDiffRequestChainProducer.access$getProject$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"change");
                        return changeDiffRequestProducerFactory.create(project, change);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"override fun getRequestC\u2026ange) }\n      }\n    }\n  }");
                return listSelection;
            }

            private static final DiffRequestProducer loadRequestProducers$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (DiffRequestProducer)$tmp0.invoke(p0);
            }
        };
    }

    @NotNull
    protected Map<Key<?>, Object> createCustomContext(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return MapsKt.emptyMap();
    }

    private final Map<Key<? extends Object>, Object> loadRequestDataKeys(ProgressIndicator indicator, Change change, CompletableFuture<GitBranchComparisonResult> changesProviderFuture, CompletableFuture<Void> fetchFuture) {
        DiffUserDataKeysEx.DiffComputer diffComputer;
        GitBranchComparisonResult changesProvider = (GitBranchComparisonResult)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)changesProviderFuture, (ProgressIndicator)indicator);
        ProgressIndicatorUtils.awaitWithCheckCanceled((Future)fetchFuture, (ProgressIndicator)indicator);
        Map requestDataKeys = new LinkedHashMap();
        VcsDiffUtil.putFilePathsIntoChangeContext((Change)change, (Map)requestDataKeys);
        GitTextFilePatchWithHistory gitTextFilePatchWithHistory = (GitTextFilePatchWithHistory)changesProvider.getPatchesByChange().get(change);
        Object object = diffComputer = gitTextFilePatchWithHistory != null ? GitBranchComparisonResultKt.getDiffComputer((GitTextFilePatchWithHistory)gitTextFilePatchWithHistory) : null;
        if (diffComputer != null) {
            Map map2 = requestDataKeys;
            Key key = DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CUSTOM_DIFF_COMPUTER");
            map2.put(key, diffComputer);
        }
        Intrinsics.checkNotNullExpressionValue((Object)changesProvider, (String)"changesProvider");
        GHPRDiffReviewSupport reviewSupport = this.getReviewSupport(changesProvider, change);
        if (reviewSupport != null) {
            Object object2;
            requestDataKeys.put(GHPRDiffReviewSupport.Companion.getKEY(), reviewSupport);
            Map map3 = requestDataKeys;
            Key key = DiffUserDataKeys.DATA_PROVIDER;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"DATA_PROVIDER");
            Key key2 = key;
            Object[] $this$loadRequestDataKeys_u24lambda_u241 = object2 = new GenericDataProvider();
            boolean bl = false;
            $this$loadRequestDataKeys_u24lambda_u241.putData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER(), (Object)this.dataProvider);
            $this$loadRequestDataKeys_u24lambda_u241.putData(GHPRDiffReviewSupport.Companion.getDATA_KEY(), (Object)reviewSupport);
            map3.put(key2, object2);
            map3 = requestDataKeys;
            Key key3 = DiffUserDataKeys.CONTEXT_ACTIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"CONTEXT_ACTIONS");
            key2 = key3;
            object2 = new AnAction[3];
            String string = CollaborationToolsBundle.message((String)"review.diff.toolbar.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"review.diff.toolbar.label\")");
            object2[0] = new ImmutableToolbarLabelAction(string);
            object2[1] = new GHPRDiffReviewThreadsReloadAction();
            object2[2] = ActionManager.getInstance().getAction("Github.PullRequest.Review.Submit");
            object2 = CollectionsKt.listOf((Object[])object2);
            map3.put(key2, object2);
        }
        return requestDataKeys;
    }

    private final GHPRDiffReviewSupport getReviewSupport(GitBranchComparisonResult changesProvider, Change change) {
        GitTextFilePatchWithHistory gitTextFilePatchWithHistory = (GitTextFilePatchWithHistory)changesProvider.getPatchesByChange().get(change);
        if (gitTextFilePatchWithHistory == null) {
            return null;
        }
        GitTextFilePatchWithHistory diffData = gitTextFilePatchWithHistory;
        return new GHPRDiffReviewSupportImpl(this.project, this.dataProvider.getReviewData(), this.dataProvider.getDetailsData(), this.htmlImageLoader, this.avatarIconsProvider, this.repositoryDataService, diffData, this.ghostUser, this.currentUser);
    }

    private static final DiffRequestProducer changeProducerFactory$lambda$0(GHPRDiffRequestChainProducer this$0, Project project, Change change) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        GHPRChangesDataProvider changesData = this$0.dataProvider.getChangesData();
        CompletableFuture<GitBranchComparisonResult> changesProviderFuture = changesData.loadChanges();
        CompletableFuture[] completableFutureArray = new CompletableFuture[]{changesData.fetchBaseBranch(), changesData.fetchHeadBranch()};
        CompletableFuture<Void> fetchFuture = CompletableFuture.allOf(completableFutureArray);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        Intrinsics.checkNotNullExpressionValue(fetchFuture, (String)"fetchFuture");
        Map<Key<? extends Object>, Object> changeDataKeys = this$0.loadRequestDataKeys(indicator, change, changesProviderFuture, fetchFuture);
        Map<Key<?>, Object> customDataKeys = this$0.createCustomContext(change);
        return (DiffRequestProducer)ChangeDiffRequestProducer.create((Project)project, (Change)change, (Map)MapsKt.plus(changeDataKeys, customDataKeys));
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRDiffRequestChainProducer $this) {
        return $this.project;
    }
}

