/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.ui.codereview.diff.MutableDiffRequestChainProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffRequestChainProcessorKt;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffRequestModel;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0012\u0010\u0011\u001a\f0\u0003\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHNewPRDiffVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFileBase;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "createProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "equals", "", "other", "", "getName", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPresentablePath", "intellij.vcs.github"})
public final class GHNewPRDiffVirtualFile
extends GHPRDiffVirtualFileBase {
    public GHNewPRDiffVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        super(fileManagerId, project, repository);
    }

    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project) {
        MutableDiffRequestChainProcessor mutableDiffRequestChainProcessor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GHPRDataContext gHPRDataContext = GHPRDataContextRepository.Companion.getInstance(project).findContext(this.getRepository());
        Intrinsics.checkNotNull((Object)gHPRDataContext);
        GHPRDataContext dataContext = gHPRDataContext;
        GHPRDiffRequestModel diffRequestModel = dataContext.getNewPRDiffModel();
        MutableDiffRequestChainProcessor it = mutableDiffRequestChainProcessor = new MutableDiffRequestChainProcessor(project, null);
        boolean bl = false;
        GHPRDiffRequestChainProcessorKt.process(diffRequestModel, it);
        return (DiffRequestProcessor)mutableDiffRequestChainProcessor;
    }

    @NotNull
    public String getName() {
        return "newPR.diff";
    }

    @NotNull
    public String getPresentableName() {
        String string = GithubBundle.message("pull.request.new.diff.editor.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.new.diff.editor.title\")");
        return string;
    }

    @NotNull
    public String getPath() {
        VirtualFileSystem virtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)virtualFileSystem).getPath(this.getFileManagerId(), this.getProject(), this.getRepository(), null, null, true);
    }

    @NotNull
    public String getPresentablePath() {
        return this.getRepository().toUrl() + "/pulls/newPR.diff";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHNewPRDiffVirtualFile)) {
            return false;
        }
        return super.equals(other);
    }
}

