/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.changesHandler.CommonInjectedFileChangesHandlerKt;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class TemporaryPlacesRegistry {
    private final Project myProject;
    private final List<TempPlace> myTempPlaces;
    private volatile long myPsiModificationCounter;
    public static final String SUPPORT_ID = "temp";

    public static TemporaryPlacesRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            TemporaryPlacesRegistry.$$$reportNull$$$0(0);
        }
        return (TemporaryPlacesRegistry)project.getService(TemporaryPlacesRegistry.class);
    }

    public TemporaryPlacesRegistry(@NotNull Project project) {
        if (project == null) {
            TemporaryPlacesRegistry.$$$reportNull$$$0(1);
        }
        this.myTempPlaces = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    private List<TempPlace> getInjectionPlacesSafe() {
        long modificationCount = PsiModificationTracker.getInstance((Project)this.myProject).getModificationCount();
        if (this.myPsiModificationCounter == modificationCount) {
            return this.myTempPlaces;
        }
        this.myPsiModificationCounter = modificationCount;
        List placesToRemove = ContainerUtil.findAll(this.myTempPlaces, place -> {
            PsiLanguageInjectionHost element = (PsiLanguageInjectionHost)place.elementPointer.getElement();
            if (element == null) {
                Segment range = place.elementPointer.getRange();
                if (range == null) {
                    return true;
                }
                PsiFile file = place.elementPointer.getContainingFile();
                if (file == null) {
                    return true;
                }
                PsiLanguageInjectionHost newHost = CommonInjectedFileChangesHandlerKt.getInjectionHostAtRange((PsiFile)file, (Segment)range);
                if (newHost == null) {
                    return true;
                }
                newHost.putUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, (Object)place.language);
                place.elementPointer = SmartPointerManager.createPointer((PsiElement)newHost);
            } else {
                if (!element.isValidHost()) {
                    element.putUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, null);
                    return true;
                }
                element.putUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, (Object)place.language);
            }
            return false;
        });
        if (!placesToRemove.isEmpty()) {
            this.myTempPlaces.removeAll(placesToRemove);
        }
        return this.myTempPlaces;
    }

    private void addInjectionPlace(TempPlace place) {
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)place.elementPointer.getElement();
        if (host == null) {
            return;
        }
        HashSet<PsiLanguageInjectionHost> hosts = new HashSet<PsiLanguageInjectionHost>();
        hosts.add(host);
        InjectedLanguageManager.getInstance((Project)this.myProject).enumerate((PsiElement)host, (injectedPsi, places) -> {
            injectedPsi.putUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, (Object)place.language);
            for (PsiLanguageInjectionHost.Shred shred : places) {
                hosts.add(shred.getHost());
            }
        });
        List<TempPlace> injectionPoints = this.getInjectionPlacesSafe();
        for (TempPlace tempPlace : injectionPoints) {
            if (!hosts.contains(tempPlace.elementPointer.getElement())) continue;
            injectionPoints.remove(tempPlace);
            break;
        }
        if (place.language != null) {
            injectionPoints.add(place);
        }
        host.putUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, (Object)place.language);
        host.getManager().dropPsiCaches();
    }

    public boolean removeHostWithUndo(Project project, PsiLanguageInjectionHost host) {
        InjectedLanguage prevLanguage = (InjectedLanguage)host.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE);
        if (prevLanguage == null) {
            return false;
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myProject);
        SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)host);
        TempPlace place = new TempPlace(prevLanguage, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        TempPlace nextPlace = new TempPlace(null, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        Configuration.replaceInjectionsWithUndo(project, host.getContainingFile(), nextPlace, place, false, Collections.emptyList(), (add, remove) -> {
            this.addInjectionPlace((TempPlace)add);
            return true;
        });
        return true;
    }

    public boolean removeHost(PsiLanguageInjectionHost host) {
        InjectedLanguage prevLanguage = (InjectedLanguage)host.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE);
        if (prevLanguage == null) {
            return false;
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myProject);
        SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)host);
        TempPlace nextPlace = new TempPlace(null, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        this.addInjectionPlace(nextPlace);
        return true;
    }

    public void addHostWithUndo(PsiLanguageInjectionHost host, InjectedLanguage language) {
        InjectedLanguage prevLanguage = (InjectedLanguage)host.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE);
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)host);
        TempPlace prevPlace = new TempPlace(prevLanguage, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        TempPlace place = new TempPlace(language, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        Configuration.replaceInjectionsWithUndo(this.myProject, host.getContainingFile(), place, prevPlace, false, Collections.emptyList(), (add, remove) -> {
            this.addInjectionPlace((TempPlace)add);
            return true;
        });
    }

    public void addHost(PsiLanguageInjectionHost host, InjectedLanguage language) {
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)host);
        TempPlace place = new TempPlace(language, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        this.addInjectionPlace(place);
    }

    public LanguageInjectionSupport getLanguageInjectionSupport() {
        return InjectorUtils.findInjectionSupport(SUPPORT_ID);
    }

    @Nullable
    public InjectedLanguage getLanguageFor(@NotNull PsiLanguageInjectionHost host, PsiFile containingFile) {
        PsiLanguageInjectionHost originalHost;
        if (host == null) {
            TemporaryPlacesRegistry.$$$reportNull$$$0(2);
        }
        PsiLanguageInjectionHost injectionHost = (originalHost = (PsiLanguageInjectionHost)CompletionUtilCoreImpl.getOriginalElement((PsiElement)host, (PsiFile)containingFile)) == null ? host : originalHost;
        this.getInjectionPlacesSafe();
        return (InjectedLanguage)injectionHost.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/intelliLang/inject/TemporaryPlacesRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguageFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TempPlace {
        final InjectedLanguage language;
        SmartPsiElementPointer<PsiLanguageInjectionHost> elementPointer;

        TempPlace(InjectedLanguage language, SmartPsiElementPointer<PsiLanguageInjectionHost> elementPointer) {
            this.language = language;
            this.elementPointer = elementPointer;
        }
    }
}

