/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.offline;

import com.intellij.rt.coverage.offline.RawClassData;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawProjectData {
    private final Map<String, RawClassData> myClasses = new ConcurrentHashMap<String, RawClassData>();

    public Collection<RawClassData> getClasses() {
        return this.myClasses.values();
    }

    public RawClassData getOrCreateClass(String className, int length) {
        RawClassData classData = this.myClasses.get(className);
        if (classData != null) {
            RawProjectData.checkLength(classData, length);
            return classData;
        }
        return this.createClassData(className, length);
    }

    public synchronized RawClassData createClassData(String className, int length) {
        RawClassData classData = this.myClasses.get(className);
        if (classData != null) {
            RawProjectData.checkLength(classData, length);
            return classData;
        }
        classData = new RawClassData(className, new int[length]);
        this.myClasses.put(className, classData);
        return classData;
    }

    private static void checkLength(RawClassData classData, int length) {
        if (classData.hits.length < length) {
            throw new RuntimeException("Class " + classData.name + " is loaded twice with different hits length");
        }
    }
}

