/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.testTracking;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.BranchesEnumerator;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.DataAccessUtil;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingClassDataInstrumenter;
import com.intellij.rt.coverage.instrumentation.util.LocalVariableInserter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class TestTrackingArrayInstrumenter
extends TestTrackingClassDataInstrumenter {
    private static final String TRACE_MASK_LOCAL_VARIABLE_NAME = "__$traceMaskLocal$__";
    private final CoverageDataAccess myArrayDataAccess;
    private final String myInternalClassName;

    public TestTrackingArrayInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldSaveSource, CoverageDataAccess dataAccess) {
        super(projectData, classVisitor, cr, className, shouldSaveSource, dataAccess);
        this.myInternalClassName = ClassNameUtil.convertToInternalName(className);
        this.myArrayDataAccess = DataAccessUtil.createTestTrackingDataAccess(className, cr, true);
    }

    protected MethodVisitor createMethodTransformer(MethodVisitor mv, BranchesEnumerator enumerator, int access, String name, String desc) {
        if (enumerator.hasNoLines()) {
            return this.myArrayDataAccess.createMethodVisitor(this.myDataAccess.createMethodVisitor(mv, name, false), name, false);
        }
        LocalVariableInserter visitor = new LocalVariableInserter(mv, access, desc, TRACE_MASK_LOCAL_VARIABLE_NAME, "[Z"){

            public void visitLineNumber(int line, Label start) {
                LineData lineData = TestTrackingArrayInstrumenter.this.getLineData(line);
                if (lineData != null) {
                    this.mv.visitVarInsn(25, this.getLVIndex());
                    this.mv.visitInsn(89);
                    this.mv.visitInsn(3);
                    this.mv.visitInsn(51);
                    Label skip = new Label();
                    this.mv.visitJumpInsn(154, skip);
                    this.mv.visitFieldInsn(178, TestTrackingArrayInstrumenter.this.myInternalClassName, "__$classData$__", "Ljava/lang/Object;");
                    this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "registerClassForTrace", "(Ljava/lang/Object;)Z", false);
                    this.mv.visitJumpInsn(153, skip);
                    this.mv.visitVarInsn(25, this.getLVIndex());
                    this.mv.visitInsn(3);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(84);
                    this.mv.visitLabel(skip);
                    InstrumentationUtils.pushInt(this.mv, line);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(84);
                }
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                TestTrackingArrayInstrumenter.this.myArrayDataAccess.onMethodStart(this.mv, this.getLVIndex());
                super.visitCode();
            }
        };
        return this.myArrayDataAccess.createMethodVisitor(this.myDataAccess.createMethodVisitor(visitor, name, true), name, true);
    }

    public void visitEnd() {
        this.myArrayDataAccess.onClassEnd(this);
        super.visitEnd();
    }

    protected void initLineData() {
        this.myClassData.createTraceMask(this.myMaxLineNumber + 1);
        super.initLineData();
    }
}

