/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classFilter;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinAnonymousClassInIgnoredMethodFilter
extends ClassFilter {
    private boolean myShouldIgnoreClass = false;

    public boolean isApplicable(Instrumenter context) {
        return true;
    }

    public void visitOuterClass(String owner, String name, String descriptor) {
        super.visitOuterClass(owner, name, descriptor);
        if (this.myShouldIgnoreClass) {
            return;
        }
        String ownerName = ClassNameUtil.convertToFQName(owner);
        boolean ignored = this.myContext.getProjectData().isMethodIgnored(ownerName, name, descriptor);
        if (ignored) {
            this.myContext.setIgnoreSection(true);
            this.myShouldIgnoreClass = true;
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.myShouldIgnoreClass) {
            this.myContext.getProjectData().addIgnoredMethod(this.myContext.getClassName(), name, descriptor);
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        if (this.myShouldIgnoreClass) {
            this.myContext.setIgnoreSection(false);
        }
        super.visitEnd();
    }
}

