/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class BooleanInvertFilter
extends BranchesFilter {
    private Label myTrueLabel;
    private Label myFalseLabel;
    private int myState = 0;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return true;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (opcode == 154 && this.myState == 0) {
            this.myFalseLabel = label;
            this.myState = 1;
        } else if (opcode == 167 && this.myState == 2) {
            this.myTrueLabel = label;
            this.myState = 3;
        } else {
            this.myState = 0;
        }
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.myState = opcode == 4 && this.myState == 1 ? 2 : (opcode == 3 && this.myState == 4 ? 5 : 0);
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (label == this.myFalseLabel && this.myState == 3) {
            this.myState = 4;
        } else if (label == this.myTrueLabel && this.myState == 5) {
            this.myBranchData.removeLastJump();
            this.myState = 0;
        } else {
            this.myState = 0;
        }
    }
}

