/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.platform.diagnostic.telemetry.IJNoopTracer;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.SpanBuilderWithSystemInfoAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import org.jetbrains.annotations.NotNull;

public abstract class PerformanceCommand
extends AbstractCommand {
    private static final String PREFIX = "%";
    private final Tracer tracer;

    public PerformanceCommand(@NotNull String text, int line) {
        if (text == null) {
            PerformanceCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.tracer = this.isWarmupMode() != false ? IJNoopTracer.INSTANCE : PerformanceTestSpan.TRACER;
    }

    public PerformanceCommand(@NotNull String text, int line, boolean executeInAwt) {
        if (text == null) {
            PerformanceCommand.$$$reportNull$$$0(1);
        }
        super(text, line, executeInAwt);
        this.tracer = this.isWarmupMode() != false ? IJNoopTracer.INSTANCE : PerformanceTestSpan.TRACER;
    }

    protected abstract String getName();

    protected String getPrefix() {
        return PREFIX + this.getName();
    }

    protected Boolean isWarmupMode() {
        return this.extractCommandArgument(this.getPrefix()).contains("WARMUP");
    }

    protected Boolean systemMetricsEnabled() {
        return this.extractCommandArgument(this.getPrefix()).contains("ENABLE_SYSTEM_METRICS");
    }

    private SpanBuilder wrapIfNeed(SpanBuilder spanBuilder) {
        if (this.systemMetricsEnabled().booleanValue()) {
            return new SpanBuilderWithSystemInfoAttributes(spanBuilder);
        }
        return spanBuilder;
    }

    protected Span startSpan(String name) {
        SpanBuilder spanBuilder = this.wrapIfNeed(this.tracer.spanBuilder(name));
        return spanBuilder.startSpan();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/PerformanceCommand", "<init>"));
    }
}

