/*
 * Decompiled with CFR 0.152.
 */
package runtime.routing;

import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.EncodingKt;
import runtime.routing.Location;
import runtime.routing.LocationKt;
import runtime.routing.LocationParameterBuilderKt;
import runtime.routing.LocationParameters;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u001f\u0010\"\u001a\u00020\u00032\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030$\"\u00020\u0003\u00a2\u0006\u0002\u0010%J\u0013\u0010&\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0018\u0010(\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\b\b\u0002\u0010)\u001a\u00020\bJ\b\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000bJ\b\u0010.\u001a\u00020\u0003H\u0016J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003J\u001c\u00100\u001a\u00020\u00002\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u0019\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011\u00a8\u00063"}, d2={"Lruntime/routing/Location;", "", "url", "", "parameters", "", "testId", "absolute", "", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Z)V", "locationParameters", "Lruntime/routing/LocationParameters;", "(Ljava/lang/String;Lruntime/routing/LocationParameters;Ljava/lang/String;Z)V", "getAbsolute", "()Z", "href", "getHref", "()Ljava/lang/String;", "href$delegate", "Lkotlin/Lazy;", "lastPart", "getLastPart", "getLocationParameters", "()Lruntime/routing/LocationParameters;", "path", "getPath", "path$delegate", "getTestId", "getUrl", "absoluteHref", "hostUrl", "forceBrowser", "append", "part", "appendParts", "parts", "", "([Ljava/lang/String;)Ljava/lang/String;", "equals", "other", "fragment", "encode", "hashCode", "", "plusParameters", "additionalParameters", "toString", "withFragment", "withParameters", "newParameters", "Companion", "platform-runtime"})
public class Location {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final LocationParameters locationParameters;
    @Nullable
    private final String testId;
    private final boolean absolute;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final Lazy href$delegate;
    @NotNull
    private static final Location empty = new Location("#", null, null, false, 14, null);
    @NotNull
    private static final String ZERO = "null";
    @NotNull
    private static final Location zero = new Location("null", null, null, false, 14, null);
    @NotNull
    public static final String FORCE_BROWSER_PREFIX = "force-browser";

    public Location(@NotNull String url2, @NotNull LocationParameters locationParameters, @Nullable String testId, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)locationParameters, (String)"locationParameters");
        this.url = url2;
        this.locationParameters = locationParameters;
        this.testId = testId;
        this.absolute = absolute;
        this.path$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Location this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder;
                Location location2 = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.append(location2.getUrl());
                String queryString2 = LocationKt.encodeAndJoinUrlParamsToQueryString(location2.getLocationParameters(), true);
                if (((CharSequence)queryString2).length() > 0) {
                    $this$invoke_u24lambda_u240.append("?" + queryString2);
                }
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                return string2;
            }
        }));
        this.href$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Location this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getAbsolute() ? this.this$0.getPath() : "/" + this.this$0.getPath();
            }
        }));
    }

    public /* synthetic */ Location(String string2, LocationParameters locationParameters, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            locationParameters = LocationParameterBuilderKt.emptyLocationParameters();
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string2, locationParameters, string3, bl);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final LocationParameters getLocationParameters() {
        return this.locationParameters;
    }

    @Nullable
    public final String getTestId() {
        return this.testId;
    }

    public final boolean getAbsolute() {
        return this.absolute;
    }

    public Location(@NotNull String url2, @NotNull Map<String, String> parameters2, @Nullable String testId, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        this(url2, LocationParameterBuilderKt.locationParameters(parameters2), testId, absolute);
    }

    public /* synthetic */ Location(String string2, Map map2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string2, map2, string3, bl);
    }

    @NotNull
    public final String getLastPart() {
        return StringsKt.substringAfterLast$default((String)this.url, (String)"/", null, (int)2, null);
    }

    @NotNull
    public final String append(@NotNull String part) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        if (!Intrinsics.areEqual((Object)this.url, (Object)"")) {
            if (((CharSequence)part).length() == 0) {
                object = this.url;
            } else {
                char[] cArray = new char[]{'/'};
                object = this.url + "/" + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)part, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)append.1.INSTANCE, (int)30, null);
            }
        } else {
            char[] cArray = new char[]{'/'};
            object = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)part, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)append.2.INSTANCE, (int)30, null);
        }
        return object;
    }

    @NotNull
    public final String appendParts(String ... parts) {
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        return !Intrinsics.areEqual((Object)this.url, (Object)"") ? (parts.length == 0 ? this.url : this.url + "/" + ArraysKt.joinToString$default((Object[])parts, (CharSequence)"/", null, null, (int)0, null, (Function1)appendParts.1.INSTANCE, (int)30, null)) : ArraysKt.joinToString$default((Object[])parts, (CharSequence)"/", null, null, (int)0, null, (Function1)appendParts.2.INSTANCE, (int)30, null);
    }

    @NotNull
    public final String fragment(@NotNull String fragment2, boolean encode2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)fragment2, (String)"fragment");
        StringBuilder $this$fragment_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$fragment_u24lambda_u240.append(this.getPath());
        $this$fragment_u24lambda_u240.append("#");
        char[] cArray = new char[]{'#'};
        String fragmentValue = StringsKt.trimStart((String)fragment2, (char[])cArray);
        if (encode2) {
            $this$fragment_u24lambda_u240.append(EncodingKt.urlEncode(fragmentValue));
        } else {
            $this$fragment_u24lambda_u240.append(fragmentValue);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String fragment$default(Location location2, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fragment");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return location2.fragment(string2, bl);
    }

    @NotNull
    public final Location withFragment(@NotNull String fragment2) {
        Intrinsics.checkNotNullParameter((Object)fragment2, (String)"fragment");
        return new Location(Location.fragment$default(this, fragment2, false, 2, null), null, null, this.absolute, 6, null);
    }

    @NotNull
    public final String getPath() {
        Lazy lazy = this.path$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getHref() {
        Lazy lazy = this.href$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String absoluteHref(@NotNull String hostUrl, boolean forceBrowser) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)hostUrl, (String)"hostUrl");
        if (this.absolute) {
            string2 = this.getHref();
        } else if (forceBrowser) {
            char[] cArray = new char[]{'/'};
            string2 = Companion.absoluteHref(hostUrl, "/force-browser/" + StringsKt.trimStart((String)this.getHref(), (char[])cArray));
        } else {
            string2 = Companion.absoluteHref(hostUrl, this.getHref());
        }
        return string2;
    }

    public static /* synthetic */ String absoluteHref$default(Location location2, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: absoluteHref");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return location2.absoluteHref(string2, bl);
    }

    @NotNull
    public final Location withParameters(@NotNull Map<String, String> newParameters) {
        Intrinsics.checkNotNullParameter(newParameters, (String)"newParameters");
        return new Location(this.url, newParameters, this.testId, this.absolute);
    }

    @NotNull
    public final Location withParameters(@NotNull LocationParameters newParameters) {
        Intrinsics.checkNotNullParameter((Object)newParameters, (String)"newParameters");
        return new Location(this.url, newParameters, this.testId, this.absolute);
    }

    @NotNull
    public final Location plusParameters(@NotNull LocationParameters additionalParameters) {
        Intrinsics.checkNotNullParameter((Object)additionalParameters, (String)"additionalParameters");
        return new Location(this.url, LocationParameterBuilderKt.plus(this.locationParameters, additionalParameters), this.testId, this.absolute);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Location cfr_ignored_0 = (Location)other;
        return Intrinsics.areEqual((Object)((Location)other).url, (Object)this.url) && ((Location)other).locationParameters.match(this.locationParameters);
    }

    public int hashCode() {
        int result2 = this.url.hashCode();
        result2 = 31 * result2 + this.locationParameters.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.getHref();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0011"}, d2={"Lruntime/routing/Location$Companion;", "", "()V", "FORCE_BROWSER_PREFIX", "", "ZERO", "empty", "Lruntime/routing/Location;", "getEmpty", "()Lruntime/routing/Location;", "zero", "getZero", "absoluteHref", "hostUrl", "href", "parse", "url", "platform-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Location getEmpty() {
            return empty;
        }

        @NotNull
        public final String absoluteHref(@NotNull String hostUrl, @NotNull String href2) {
            Intrinsics.checkNotNullParameter((Object)hostUrl, (String)"hostUrl");
            Intrinsics.checkNotNullParameter((Object)href2, (String)"href");
            char[] cArray = new char[]{'/'};
            return StringsKt.trimEnd((String)hostUrl, (char[])cArray) + href2;
        }

        @NotNull
        public final Location getZero() {
            return zero;
        }

        @NotNull
        public final Location parse(@NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            return new Location(StringsKt.substringBefore$default((String)url2, (String)"?", null, (int)2, null), LocationKt.parseAndDecodeUrlParameters(url2), null, false, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

