/*
 * Decompiled with CFR 0.152.
 */
package runtime.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.json.JsonArray;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.json.JsonObject;
import runtime.json.JsonValue;
import runtime.json.JsonValueBuilderContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0086\u0004J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0004J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0086\u0004J%\u0010\u000f\u001a\u00020\u00102\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u0015\u00a2\u0006\u0002\b\u0017H\u0086\f\u00f8\u0001\u0000J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0018H\u0086\u0004J%\u0010\u0019\u001a\u00020\u00102\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00100\u0015\u00a2\u0006\u0002\b\u0017H\u0086\f\u00f8\u0001\u0000J\u0006\u0010\u001a\u001a\u00020\u001bJ%\u0010\u001c\u001a\u00020\u00102\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00100\u0015\u00a2\u0006\u0002\b\u0017H\u0086\f\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"Lruntime/json/JsonArrayBuilderContext;", "", "node", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "factory", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/node/ArrayNode;Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getFactory", "()Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getNode", "()Lcom/fasterxml/jackson/databind/node/ArrayNode;", "push", "", "value", "", "", "worker", "Lkotlin/Function1;", "Lruntime/json/JsonBuilderContext;", "Lkotlin/ExtensionFunctionType;", "Lruntime/json/JsonElement;", "pushArray", "pushContext", "Lruntime/json/JsonValueBuilderContext;", "pushValue", "platform-runtime"})
public final class JsonArrayBuilderContext {
    @NotNull
    private final ArrayNode node;
    @NotNull
    private final JsonNodeFactory factory;
    @NotNull
    private final ObjectMapper mapper;

    public JsonArrayBuilderContext(@NotNull ArrayNode node, @NotNull JsonNodeFactory factory2, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.node = node;
        this.factory = factory2;
        this.mapper = mapper;
    }

    @NotNull
    public final ArrayNode getNode() {
        return this.node;
    }

    @NotNull
    public final JsonNodeFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    public final void push(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.node.add(value2);
    }

    public final void push(int value2) {
        this.node.add(value2);
    }

    public final void push(@Nullable Object value2) {
        this.node.add(this.mapper.valueToTree(value2));
    }

    public final void push(@Nullable JsonElement value2) {
        BaseJsonNode baseJsonNode;
        JsonElement jsonElement = value2;
        if (jsonElement instanceof JsonValue) {
            baseJsonNode = (BaseJsonNode)JsonDslKt.node((JsonValue)value2);
        } else if (jsonElement instanceof JsonArray) {
            baseJsonNode = (BaseJsonNode)JsonDslKt.node((JsonArray)value2);
        } else if (jsonElement instanceof JsonObject) {
            baseJsonNode = (BaseJsonNode)JsonDslKt.node((JsonObject)value2);
        } else if (jsonElement == null) {
            baseJsonNode = null;
        } else {
            throw new IllegalStateException(("Unsupported element type " + Reflection.getOrCreateKotlinClass(value2.getClass()).getSimpleName()).toString());
        }
        this.node.add((JsonNode)baseJsonNode);
    }

    public final void pushArray(@NotNull Function1<? super JsonArrayBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        boolean $i$f$pushArray = false;
        ArrayNode objNode = this.getFactory().arrayNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonArrayBuilderContext(objNode, this.getFactory(), this.getMapper()));
        this.getNode().add((JsonNode)objNode);
    }

    public final void push(@NotNull Function1<? super JsonBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        boolean $i$f$push = false;
        ObjectNode objNode = this.getFactory().objectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objNode, (String)"objNode");
        worker.invoke((Object)new JsonBuilderContext(objNode, this.getFactory(), this.getMapper()));
        this.getNode().add((JsonNode)objNode);
    }

    public final void pushValue(@NotNull Function1<? super JsonValueBuilderContext, Unit> worker) {
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        boolean $i$f$pushValue = false;
        worker.invoke((Object)this.pushContext());
    }

    @NotNull
    public final JsonValueBuilderContext pushContext() {
        return new JsonValueBuilderContext((Function1<? super JsonNode, Unit>)((Function1)new Function1<JsonNode, Unit>(this){
            final /* synthetic */ JsonArrayBuilderContext this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getNode().add(it);
            }
        }), this.factory, this.mapper);
    }
}

