/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.util.filter.ArtifactTypeFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public final class FilterHelper {
    public static final Filter<Artifact> NO_FILTER = NoFilter.instance();

    private FilterHelper() {
    }

    public static Filter<Artifact> getArtifactTypeFilter(String types) {
        if (types == null || types.trim().equals("*")) {
            return NO_FILTER;
        }
        String[] t = types.split(",");
        return FilterHelper.getArtifactTypeFilter(t);
    }

    public static Filter<Artifact> getArtifactTypeFilter(String[] types) {
        if (types == null || types.length == 0) {
            return NO_FILTER;
        }
        ArrayList<String> acceptedTypes = new ArrayList<String>(types.length);
        for (String type2 : types) {
            String current2 = type2.trim();
            if ("*".equals(current2)) {
                return NO_FILTER;
            }
            acceptedTypes.add(current2);
        }
        return new ArtifactTypeFilter(acceptedTypes);
    }

    public static <T> Collection<T> filter(Collection<T> col, Filter<T> filter2) {
        if (filter2 == null) {
            return col;
        }
        ArrayList<T> ret = new ArrayList<T>(col);
        Iterator iter = ret.iterator();
        while (iter.hasNext()) {
            if (filter2.accept(iter.next())) continue;
            iter.remove();
        }
        return ret;
    }
}

