/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.regex.PatternSyntaxException;
import org.apache.ivy.plugins.matcher.AbstractPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public final class GlobPatternMatcher
extends AbstractPatternMatcher {
    public static final GlobPatternMatcher INSTANCE = new GlobPatternMatcher();

    public GlobPatternMatcher() {
        super("glob");
    }

    @Override
    protected Matcher newMatcher(String expression2) {
        return new GlobMatcher(expression2);
    }

    private static class GlobMatcher
    implements Matcher {
        private Pattern pattern;
        private String expression;
        private Boolean exact;

        public GlobMatcher(String expression2) throws PatternSyntaxException {
            this.expression = expression2;
            try {
                this.pattern = new GlobCompiler().compile(expression2);
            }
            catch (MalformedPatternException e) {
                throw new PatternSyntaxException(e.getMessage(), expression2, 0);
            }
        }

        @Override
        public boolean matches(String input) {
            if (input == null) {
                throw new NullPointerException();
            }
            return new Perl5Matcher().matches(input, this.pattern);
        }

        @Override
        public boolean isExact() {
            if (this.exact == null) {
                this.exact = this.calculateExact();
            }
            return this.exact;
        }

        private Boolean calculateExact() {
            Boolean result2 = Boolean.TRUE;
            for (char ch : this.expression.toCharArray()) {
                if (ch != '*' && ch != '?' && ch != '[' && ch != ']') continue;
                result2 = Boolean.FALSE;
                break;
            }
            return result2;
        }
    }
}

