/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class ExecutionEnvironmentProfileProvider {
    private static final String DEFAULT_PROFILES_FILE = "jvm-packages.properties";
    private static final String PACKAGE_PREFIX = "org/apache/ivy/osgi/core/";
    private Map<String, ExecutionEnvironmentProfile> profileList = ExecutionEnvironmentProfileProvider.loadDefaultProfileList();
    private static final ExecutionEnvironmentProfileProvider INSTANCE;

    public static ExecutionEnvironmentProfileProvider getInstance() {
        return INSTANCE;
    }

    public ExecutionEnvironmentProfile getProfile(String profile2) {
        return this.profileList.get(profile2);
    }

    public static Map<String, ExecutionEnvironmentProfile> loadDefaultProfileList() throws IOException {
        ClassLoader loader2 = ExecutionEnvironmentProfileProvider.class.getClassLoader();
        InputStream defaultProfilesFile = loader2.getResourceAsStream("org/apache/ivy/osgi/core/jvm-packages.properties");
        if (defaultProfilesFile == null) {
            throw new FileNotFoundException("org/apache/ivy/osgi/core/jvm-packages.properties not found in the classpath");
        }
        Properties props = new Properties();
        try {
            props.load(defaultProfilesFile);
        }
        finally {
            defaultProfilesFile.close();
        }
        HashMap<String, ExecutionEnvironmentProfile> profiles2 = new HashMap<String, ExecutionEnvironmentProfile>();
        for (Map.Entry<Object, Object> prop2 : props.entrySet()) {
            String profileName;
            String propName = (String)prop2.getKey();
            if (!propName.endsWith(".pkglist") || profiles2.containsKey(profileName = propName.substring(0, propName.length() - 8))) continue;
            ExecutionEnvironmentProfileProvider.loadProfile(props, profiles2, profileName);
        }
        return profiles2;
    }

    private static ExecutionEnvironmentProfile loadProfile(Properties props, Map<String, ExecutionEnvironmentProfile> profiles2, String name2) {
        ExecutionEnvironmentProfile profile2 = new ExecutionEnvironmentProfile(name2);
        String extendedProfileName = props.getProperty(name2 + ".extends");
        if (extendedProfileName != null) {
            ExecutionEnvironmentProfile extendedProfile = profiles2.get(extendedProfileName);
            if (extendedProfile == null) {
                extendedProfile = ExecutionEnvironmentProfileProvider.loadProfile(props, profiles2, extendedProfileName);
            }
            profile2.pkgNames.addAll(extendedProfile.pkgNames);
        }
        String pkgList = props.getProperty(name2 + ".pkglist");
        for (String pkg : StringUtils.splitToArray(pkgList)) {
            if (pkg.isEmpty()) continue;
            profile2.pkgNames.add(pkg);
        }
        profiles2.put(name2, profile2);
        String aliasList = props.getProperty(name2 + ".aliases");
        if (aliasList != null) {
            for (String alias : StringUtils.splitToArray(aliasList)) {
                if (alias.isEmpty()) continue;
                ExecutionEnvironmentProfile profileAlias = new ExecutionEnvironmentProfile(alias);
                profileAlias.pkgNames = profile2.pkgNames;
                profiles2.put(alias, profileAlias);
            }
        }
        Message.verbose("Execution environment profile " + profile2.getName() + " loaded");
        return profile2;
    }

    static {
        try {
            INSTANCE = new ExecutionEnvironmentProfileProvider();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

