/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.log;

import circlet.client.api.FulfillmentStatus;
import circlet.client.api.ProjectsKt;
import circlet.code.api.ExternalCheckChangedEvent;
import circlet.code.api.ExternalCheckDTO;
import circlet.code.api.impl.ExternalChecksServiceProxyKt;
import circlet.pipelines.api.ExecutionStatusChangedEvent;
import circlet.pipelines.api.JobWithLastExecutionDTO;
import circlet.pipelines.api.impl.JobServiceProxyKt;
import circlet.platform.api.InitializedChannel;
import circlet.platform.client.ConnectionStatusSource;
import circlet.platform.client.FluxHandlersKt;
import circlet.workspaces.Workspace;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.util.ClickableCellRenderer;
import com.intellij.collaboration.ui.util.LinkMouseListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.SpaceIcons;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.ui.Scroll;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.SpaceProjectContextKt;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.log.SpaceCommitStatus;
import com.intellij.space.vcs.log.SpaceCommitStatusPresentation;
import com.intellij.space.vcs.log.SpaceExternalCheckRenderer;
import com.intellij.space.vcs.log.SpaceJobExecution;
import com.intellij.space.vcs.log.SpaceJobExecutionRenderer;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusPresentation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.ReceiveChannel;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.Lifetimed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0015\u0010\u0016\u001a\u00020\u00172\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014H\u0002J \u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/intellij/space/vcs/log/SpaceCommitStatusPresentation;", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation$Clickable;", "project", "Lcom/intellij/openapi/project/Project;", "status", "Lcom/intellij/space/vcs/log/SpaceCommitStatus;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/space/vcs/log/SpaceCommitStatus;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "text", "", "getText", "()Ljava/lang/String;", "clickEnabled", "", "e", "Ljava/awt/event/InputEvent;", "createChecksList", "Lcom/intellij/ui/components/JBList;", "Lcirclet/code/api/ExternalCheckDTO;", "createHeader", "Lcom/intellij/ui/components/JBLabel;", "Lorg/jetbrains/annotations/Nls;", "createJobsList", "Lcom/intellij/space/vcs/log/SpaceJobExecution;", "createPanel", "Ljavax/swing/JPanel;", "jobsList", "checksList", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "scrollPane", "Ljavax/swing/JScrollPane;", "onClick", "Companion", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceCommitStatusPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceCommitStatusPresentation.kt\ncom/intellij/space/vcs/log/SpaceCommitStatusPresentation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class SpaceCommitStatusPresentation
implements VcsCommitExternalStatusPresentation.Clickable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SpaceCommitStatus status;
    @NotNull
    private final Icon icon;
    @NotNull
    private final String text;
    @NotNull
    private static final JBDimension DEFAULT_POPUP_SIZE;
    private static final int DURATION_REFRESH_INTERVAL = 1000;

    public SpaceCommitStatusPresentation(@NotNull Project project2, @NotNull SpaceCommitStatus status2) {
        String string2;
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        this.project = project2;
        this.status = status2;
        FulfillmentStatus fulfillmentStatus = this.status.getFulfillmentStatus();
        switch (fulfillmentStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fulfillmentStatus.ordinal()]) {
            case 1: 
            case 2: {
                Icon icon3 = SpaceIcons.Icons.Pending;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Pending");
                break;
            }
            case 3: {
                Icon icon4 = SpaceIcons.Icons.Running;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Running");
                break;
            }
            case 4: {
                Icon icon5 = SpaceIcons.Icons.Failing;
                icon2 = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Failing");
                break;
            }
            case 5: {
                Icon icon6 = SpaceIcons.Icons.Hanging;
                icon2 = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Hanging");
                break;
            }
            case 6: {
                Icon icon7 = AllIcons.RunConfigurations.ToolbarPassed;
                icon2 = icon7;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"ToolbarPassed");
                break;
            }
            case 7: {
                Icon icon8 = SpaceIcons.Icons.Failed;
                icon2 = icon8;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"Failed");
                break;
            }
            case 8: {
                Icon icon9 = SpaceIcons.Icons.Terminated;
                icon2 = icon9;
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"Terminated");
                break;
            }
            default: {
                Icon icon10 = EmptyIcon.ICON_16;
                icon2 = icon10;
                Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"ICON_16");
            }
        }
        this.icon = icon2;
        FulfillmentStatus fulfillmentStatus2 = this.status.getFulfillmentStatus();
        switch (fulfillmentStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fulfillmentStatus2.ordinal()]) {
            case 2: {
                String string3 = SpaceBundle.message("label.commit.status.ready.to.start", new Object[0]);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"label.commit.status.ready.to.start\")");
                break;
            }
            case 1: {
                String string4 = SpaceBundle.message("label.commit.status.pending", new Object[0]);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"label.commit.status.pending\")");
                break;
            }
            case 3: {
                String string5 = SpaceBundle.message("label.commit.status.running", new Object[0]);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"label.commit.status.running\")");
                break;
            }
            case 4: {
                String string6 = SpaceBundle.message("label.commit.status.failing", new Object[0]);
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"label.commit.status.failing\")");
                break;
            }
            case 5: {
                String string7 = SpaceBundle.message("label.commit.status.hanging", new Object[0]);
                string2 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"label.commit.status.hanging\")");
                break;
            }
            case 6: {
                String string8 = SpaceBundle.message("label.commit.status.succeeded", new Object[0]);
                string2 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(\"label.commit.status.succeeded\")");
                break;
            }
            case 7: {
                String string9 = SpaceBundle.message("label.commit.status.failed", new Object[0]);
                string2 = string9;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(\"label.commit.status.failed\")");
                break;
            }
            case 8: {
                String string10 = SpaceBundle.message("label.commit.status.terminated", new Object[0]);
                string2 = string10;
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(\"label.commit.status.terminated\")");
                break;
            }
            case -1: {
                String string11 = SpaceBundle.message("label.commit.status.none", new Object[0]);
                string2 = string11;
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(\"label.commit.status.none\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.text = string2;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean clickEnabled(@Nullable InputEvent e) {
        return !Intrinsics.areEqual((Object)this.status, (Object)SpaceCommitStatus.Companion.getNONE());
    }

    public boolean onClick(@Nullable InputEvent e) {
        JBList<SpaceJobExecution> jBList;
        Object object;
        Workspace workspace2;
        block7: {
            block6: {
                Workspace workspace3 = SpaceWorkspaceComponent.Companion.getInstance().getWorkspace().getValue();
                if (workspace3 == null) {
                    return false;
                }
                workspace2 = workspace3;
                object = this.status.getCommitId();
                if (object == null) break block6;
                CommitId it = object;
                boolean bl = false;
                Companion.SpaceCommitId spaceCommitId = Companion.SpaceCommitId.Companion.create(this.project, it);
                object = spaceCommitId;
                if (spaceCommitId != null) break block7;
            }
            return false;
        }
        Object spaceCommitId = object;
        Object $this$onClick_u24lambda_u241 = jBList = this.createJobsList();
        boolean bl = false;
        $this$onClick_u24lambda_u241.setEmptyText(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
        JBList<SpaceJobExecution> jobsList = jBList;
        Object $this$onClick_u24lambda_u242 = $this$onClick_u24lambda_u241 = this.createChecksList();
        boolean bl2 = false;
        $this$onClick_u24lambda_u242.setEmptyText(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
        Object checksList = $this$onClick_u24lambda_u241;
        JScrollPane scrollPane = Scroll.INSTANCE.wrapWithScrollPane(this.createPanel(jobsList, (JBList<?>)checksList));
        scrollPane.setPreferredSize((Dimension)DEFAULT_POPUP_SIZE);
        LifetimeSource lifetime = new LifetimeSource();
        SpaceCommitStatusPresentation.Companion.trackJobs(lifetime, (JBList<SpaceJobExecution>)jobsList, workspace2, (Companion.SpaceCommitId)spaceCommitId);
        SpaceCommitStatusPresentation.Companion.trackExternalChecks(lifetime, (JBList<ExternalCheckDTO>)checksList, workspace2, (Companion.SpaceCommitId)spaceCommitId);
        SpaceCommitStatusPresentation.Companion.showDynamicDuration(lifetime, jobsList, checksList);
        JBPopup popup2 = this.createPopup(lifetime, scrollPane);
        if (e instanceof MouseEvent) {
            popup2.show(new RelativePoint((MouseEvent)e));
            return true;
        }
        if (e != null && e.getComponent() != null) {
            popup2.show(e.getComponent());
            return true;
        }
        return false;
    }

    private final JPanel createPanel(JBList<?> jobsList, JBList<?> checksList) {
        JPanel jPanel;
        JPanel $this$createPanel_u24lambda_u243 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        boolean bl = false;
        String string2 = SpaceBundle.message("label.jobs", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"label.jobs\")");
        $this$createPanel_u24lambda_u243.add((Component)this.createHeader(string2));
        $this$createPanel_u24lambda_u243.add((Component)jobsList);
        String string3 = SpaceBundle.message("label.external.checks", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"label.external.checks\")");
        $this$createPanel_u24lambda_u243.add((Component)this.createHeader(string3));
        $this$createPanel_u24lambda_u243.add((Component)checksList);
        return jPanel;
    }

    private final JBLabel createHeader(String text2) {
        JBLabel jBLabel;
        JBLabel $this$createHeader_u24lambda_u244 = jBLabel = new JBLabel(text2);
        boolean bl = false;
        $this$createHeader_u24lambda_u244.setBorder(JBUI.Borders.empty((int)4));
        return jBLabel;
    }

    private final JBList<SpaceJobExecution> createJobsList() {
        JBList list2 = new JBList();
        SpaceJobExecutionRenderer renderer2 = new SpaceJobExecutionRenderer();
        list2.setCellRenderer((ListCellRenderer)((Object)renderer2));
        new LinkMouseListener((ClickableCellRenderer)renderer2).installOn((Component)list2);
        return list2;
    }

    private final JBList<ExternalCheckDTO> createChecksList() {
        JBList list2 = new JBList();
        SpaceExternalCheckRenderer renderer2 = new SpaceExternalCheckRenderer();
        list2.setCellRenderer((ListCellRenderer)((Object)renderer2));
        new LinkMouseListener((ClickableCellRenderer)renderer2).installOn((Component)list2);
        return list2;
    }

    private final JBPopup createPopup(LifetimeSource lifetime, JScrollPane scrollPane) {
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, null).setTitle(SpaceBundle.message("column.name.commit.status", new Object[0])).setMovable(true).setResizable(true).setDimensionServiceKey(null, "Space.LogColumn.CommitStatus.Popup", true).setCancelOnWindowDeactivation(false).addListener(new JBPopupListener(lifetime){
            final /* synthetic */ LifetimeSource $lifetime;
            {
                this.$lifetime = $lifetime;
            }

            public void onClosed(@NotNull LightweightWindowEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.$lifetime.terminate();
            }
        }).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"lifetime: LifetimeSource\u2026  })\n      .createPopup()");
        return jBPopup;
    }

    static {
        JBDimension jBDimension = JBUI.size((int)500, (int)300);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(500, 300)");
        DEFAULT_POPUP_SIZE = jBDimension;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b*\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J*\u0010\r\u001a\u00020\b*\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u0014\u001a\u00020\b*\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/space/vcs/log/SpaceCommitStatusPresentation$Companion;", "", "()V", "DEFAULT_POPUP_SIZE", "Lcom/intellij/util/ui/JBDimension;", "DURATION_REFRESH_INTERVAL", "", "showDynamicDuration", "", "Llibraries/coroutines/extra/Lifetimed;", "jobsList", "Lcom/intellij/ui/components/JBList;", "checksList", "trackExternalChecks", "list", "Lcirclet/code/api/ExternalCheckDTO;", "workspace", "Lcirclet/workspaces/Workspace;", "spaceCommitId", "Lcom/intellij/space/vcs/log/SpaceCommitStatusPresentation$Companion$SpaceCommitId;", "trackJobs", "Lcom/intellij/space/vcs/log/SpaceJobExecution;", "SpaceCommitId", "intellij.space.vcs"})
    public static final class Companion {
        private Companion() {
        }

        private final void showDynamicDuration(Lifetimed $this$showDynamicDuration, JBList<?> jobsList, JBList<?> checksList) {
            Source.Companion.interval(1000).forEach($this$showDynamicDuration.getLifetime(), (Function1<Unit, Unit>)((Function1)new Function1<Unit, Unit>(jobsList, checksList){
                final /* synthetic */ JBList<?> $jobsList;
                final /* synthetic */ JBList<?> $checksList;
                {
                    this.$jobsList = $jobsList;
                    this.$checksList = $checksList;
                    super(1);
                }

                public final void invoke(@NotNull Unit it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$jobsList.repaint();
                    this.$checksList.repaint();
                }
            }));
        }

        private final void trackJobs(Lifetimed $this$trackJobs, JBList<SpaceJobExecution> list2, Workspace workspace2, SpaceCommitId spaceCommitId) {
            FluxHandlersKt.durableFlux($this$trackJobs, (ConnectionStatusSource)workspace2.getClient(), (Function2)new Function2<LifetimeSource, Continuation<? super ReceiveChannel<? extends ExecutionStatusChangedEvent>>, Object>(workspace2, spaceCommitId, list2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ Workspace $workspace;
                final /* synthetic */ SpaceCommitId $spaceCommitId;
                final /* synthetic */ JBList<SpaceJobExecution> $list;
                {
                    this.$workspace = $workspace;
                    this.$spaceCommitId = $spaceCommitId;
                    this.$list = $list;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var20_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            lt = (LifetimeSource)this.L$0;
                            service = JobServiceProxyKt.jobService(this.$workspace.getClient().getApi());
                            v0 = ProjectsKt.getIdentifier(this.$spaceCommitId.getProject().getKey());
                            v1 = this.$spaceCommitId.getRepository().getName();
                            var5_5 = this.$spaceCommitId.getHash().asString();
                            Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"spaceCommitId.hash.asString()");
                            this.label = 1;
                            v2 = var3_4.getJobsWithLastExecution(lt, v0, v1, var5_5, (Continuation<? super InitializedChannel<ExecutionStatusChangedEvent, ? extends List<JobWithLastExecutionDTO>>>)((Continuation)this));
                            if (v2 == var20_2) {
                                return var20_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl19:
                            // 2 sources

                            var4_6 = (InitializedChannel)v2;
                            channel = var4_6.component1();
                            jobs = (List)var4_6.component2();
                            this.$list.setEmptyText(SpaceBundle.message("status.text.no.automation.script.found", new Object[0]));
                            var7_8 = jobs;
                            var8_9 = this.$spaceCommitId;
                            var17_10 = this.$list;
                            $i$f$map = false;
                            var10_12 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var15_17 = (JobWithLastExecutionDTO)item$iv$iv;
                                var18_19 = destination$iv$iv;
                                $i$a$-map-SpaceCommitStatusPresentation$Companion$trackJobs$1$1 = false;
                                var18_19.add(new SpaceJobExecution(var8_9.getProject(), it.getJob().getId(), it.getJob().getName(), it.getExecution()));
                            }
                            var19_20 = (List)destination$iv$iv;
                            var17_10.setModel((ListModel)new CollectionListModel(var19_20));
                            return channel;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull LifetimeSource p1, @Nullable Continuation<? super ReceiveChannel<ExecutionStatusChangedEvent>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function2)new Function2<ExecutionStatusChangedEvent, Continuation<? super Unit>, Object>(spaceCommitId, list2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ SpaceCommitId $spaceCommitId;
                final /* synthetic */ JBList<SpaceJobExecution> $list;
                {
                    this.$spaceCommitId = $spaceCommitId;
                    this.$list = $list;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            e = (ExecutionStatusChangedEvent)this.L$0;
                            newExecution = new SpaceJobExecution(this.$spaceCommitId.getProject(), e.getExecution());
                            v0 = this.$list.getModel();
                            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionListModel<com.intellij.space.vcs.log.SpaceJobExecution>");
                            model = (CollectionListModel)v0;
                            v1 = model.getItems();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"model.items");
                            $this$indexOfFirst$iv = v1;
                            $i$f$indexOfFirst = false;
                            index$iv = 0;
                            for (E item$iv : $this$indexOfFirst$iv) {
                                it = (SpaceJobExecution)item$iv;
                                $i$a$-indexOfFirst-SpaceCommitStatusPresentation$Companion$trackJobs$2$index$1 = false;
                                if (!Intrinsics.areEqual((Object)it.getJobId(), (Object)newExecution.getJobId())) ** GOTO lbl22
                                v2 = index$iv;
                                ** GOTO lbl25
lbl22:
                                // 1 sources

                                ++index$iv;
                            }
                            v2 = index = -1;
lbl25:
                            // 2 sources

                            if (index >= 0) {
                                model.setElementAt((Object)newExecution, index);
                            } else {
                                model.add((Object)newExecution);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull ExecutionStatusChangedEvent p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        private final void trackExternalChecks(Lifetimed $this$trackExternalChecks, JBList<ExternalCheckDTO> list2, Workspace workspace2, SpaceCommitId spaceCommitId) {
            FluxHandlersKt.durableFlux($this$trackExternalChecks, (ConnectionStatusSource)workspace2.getClient(), (Function2)new Function2<LifetimeSource, Continuation<? super ReceiveChannel<? extends ExternalCheckChangedEvent>>, Object>(workspace2, spaceCommitId, list2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ Workspace $workspace;
                final /* synthetic */ SpaceCommitId $spaceCommitId;
                final /* synthetic */ JBList<ExternalCheckDTO> $list;
                {
                    this.$workspace = $workspace;
                    this.$spaceCommitId = $spaceCommitId;
                    this.$list = $list;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            lt = (LifetimeSource)this.L$0;
                            service = ExternalChecksServiceProxyKt.externalChecksService(this.$workspace.getClient().getApi());
                            v0 = ProjectsKt.getIdentifier(this.$spaceCommitId.getProject().getKey());
                            v1 = this.$spaceCommitId.getRepository().getName();
                            var5_5 = this.$spaceCommitId.getHash().asString();
                            Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"spaceCommitId.hash.asString()");
                            this.label = 1;
                            v2 = var3_4.getExternalChecksForCommitChannel(lt, v0, v1, var5_5, (Continuation<? super InitializedChannel<ExternalCheckChangedEvent, ? extends List<ExternalCheckDTO>>>)((Continuation)this));
                            if (v2 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl19:
                            // 2 sources

                            var4_6 = (InitializedChannel)v2;
                            channel = var4_6.component1();
                            checks = (List)var4_6.component2();
                            this.$list.setEmptyText(SpaceBundle.message("status.text.no.external.checks.have.been.triggered", new Object[0]));
                            var7_8 = new Function1[]{trackExternalChecks.1.INSTANCE, trackExternalChecks.2.INSTANCE};
                            this.$list.setModel((ListModel)new SortedListModel((Collection)checks, ComparisonsKt.compareBy((Function1[])var7_8)));
                            return channel;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull LifetimeSource p1, @Nullable Continuation<? super ReceiveChannel<ExternalCheckChangedEvent>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function2)new Function2<ExternalCheckChangedEvent, Continuation<? super Unit>, Object>(list2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ JBList<ExternalCheckDTO> $list;
                {
                    this.$list = $list;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            e = (ExternalCheckChangedEvent)this.L$0;
                            newCheck = e.getExternalCheckDTO();
                            v0 = this.$list.getModel();
                            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.ui.SortedListModel<circlet.code.api.ExternalCheckDTO>");
                            model = (SortedListModel)v0;
                            v1 = model.getItems();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"model.items");
                            $this$indexOfFirst$iv = v1;
                            $i$f$indexOfFirst = false;
                            index$iv = 0;
                            for (E item$iv : $this$indexOfFirst$iv) {
                                it = (ExternalCheckDTO)item$iv;
                                $i$a$-indexOfFirst-SpaceCommitStatusPresentation$Companion$trackExternalChecks$2$index$1 = false;
                                if (!it.forSameTask(newCheck)) ** GOTO lbl22
                                v2 = index$iv;
                                ** GOTO lbl25
lbl22:
                                // 1 sources

                                ++index$iv;
                            }
                            v2 = index = -1;
lbl25:
                            // 2 sources

                            if (index >= 0) {
                                model.remove(index);
                            }
                            model.add((Object)newCheck);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull ExternalCheckChangedEvent p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/space/vcs/log/SpaceCommitStatusPresentation$Companion$SpaceCommitId;", "", "project", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "repository", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/space/vcs/SpaceProjectInfo;Lcom/intellij/space/vcs/SpaceRepoInfo;Lcom/intellij/vcs/log/Hash;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getProject", "()Lcom/intellij/space/vcs/SpaceProjectInfo;", "getRepository", "()Lcom/intellij/space/vcs/SpaceRepoInfo;", "Companion", "intellij.space.vcs"})
        private static final class SpaceCommitId {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final SpaceProjectInfo project;
            @NotNull
            private final SpaceRepoInfo repository;
            @NotNull
            private final Hash hash;

            public SpaceCommitId(@NotNull SpaceProjectInfo project2, @NotNull SpaceRepoInfo repository2, @NotNull Hash hash) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                this.project = project2;
                this.repository = repository2;
                this.hash = hash;
            }

            @NotNull
            public final SpaceProjectInfo getProject() {
                return this.project;
            }

            @NotNull
            public final SpaceRepoInfo getRepository() {
                return this.repository;
            }

            @NotNull
            public final Hash getHash() {
                return this.hash;
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/space/vcs/log/SpaceCommitStatusPresentation$Companion$SpaceCommitId$Companion;", "", "()V", "create", "Lcom/intellij/space/vcs/log/SpaceCommitStatusPresentation$Companion$SpaceCommitId;", "project", "Lcom/intellij/openapi/project/Project;", "commitId", "Lcom/intellij/vcs/log/CommitId;", "intellij.space.vcs"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final SpaceCommitId create(@NotNull Project project2, @NotNull CommitId commitId) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
                    VirtualFile virtualFile = commitId.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commitId.root");
                    Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry = SpaceProjectContextKt.firstMappingOrNull(SpaceProjectContext.Companion.findProjectMappings(project2, virtualFile));
                    if (entry == null) {
                        return null;
                    }
                    Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry2 = entry;
                    SpaceRepoInfo spaceRepo = entry2.getKey();
                    SpaceProjectInfo spaceProject = entry2.getValue();
                    Hash hash = commitId.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commitId.hash");
                    return new SpaceCommitId(spaceProject, spaceRepo, hash);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FulfillmentStatus.values().length];
            try {
                nArray[FulfillmentStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FulfillmentStatus.READY_TO_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FulfillmentStatus.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FulfillmentStatus.FAILING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FulfillmentStatus.HANGING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FulfillmentStatus.SUCCEEDED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FulfillmentStatus.FAILED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FulfillmentStatus.TERMINATED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

