/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.ui.image;

import circlet.workspaces.Workspace;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.space.components.SpaceWorkspaceCachedLoader;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.EmojiCommon;
import platform.common.EmojiFormat;
import platform.common.EmojiScale;
import platform.common.EmojiSize;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001b\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/intellij/space/ui/image/SpaceEmojisLoader;", "Lcom/intellij/space/components/SpaceWorkspaceCachedLoader;", "", "Ljava/awt/image/BufferedImage;", "()V", "getEndpoint", "item", "workspace", "Lcirclet/workspaces/Workspace;", "loadEmoji", "emoji", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processResult", "responseBody", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.space"})
public final class SpaceEmojisLoader
extends SpaceWorkspaceCachedLoader<String, BufferedImage> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Object loadEmoji(@NotNull String emoji, @NotNull Continuation<? super BufferedImage> $completion) {
        return this.load(emoji, $completion);
    }

    @Override
    @NotNull
    protected String getEndpoint(@NotNull String item2, @NotNull Workspace workspace2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter((Object)workspace2, (String)"workspace");
        String emojiEndpoint = EmojiCommon.emojiHref$default(EmojiCommon.INSTANCE, item2, EmojiFormat.Raster, EmojiSize.Small, EmojiScale.HighDensity, null, 16, null);
        return workspace2.getServer() + "/" + emojiEndpoint;
    }

    @Override
    @Nullable
    protected Object processResult(@NotNull byte[] responseBody, @NotNull Continuation<? super BufferedImage> $completion) {
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(responseBody));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(ByteArrayInputStream(responseBody))");
        return bufferedImage;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/ui/image/SpaceEmojisLoader$Companion;", "", "()V", "getInstance", "Lcom/intellij/space/ui/image/SpaceEmojisLoader;", "intellij.space"})
    @SourceDebugExtension(value={"SMAP\nSpaceEmojisLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceEmojisLoader.kt\ncom/intellij/space/ui/image/SpaceEmojisLoader$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,31:1\n43#2,3:32\n*S KotlinDebug\n*F\n+ 1 SpaceEmojisLoader.kt\ncom/intellij/space/ui/image/SpaceEmojisLoader$Companion\n*L\n29#1:32,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpaceEmojisLoader getInstance() {
            boolean $i$f$service = false;
            Class<SpaceEmojisLoader> serviceClass$iv = SpaceEmojisLoader.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (SpaceEmojisLoader)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

