/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.kotlin.scriptdefinition.detect;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.space.kotlin.scriptdefinition.detect.DslFileFinder;
import com.intellij.space.kotlin.scriptdefinition.detect.SpaceKtsFileDetector;
import com.intellij.space.utils.LifetimedDisposable;
import com.intellij.space.utils.UtilitiesKt;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.coroutines.extra.Lifetime;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\r\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/space/kotlin/scriptdefinition/detect/SpaceKtsFileDetector;", "Lcom/intellij/space/utils/LifetimedDisposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_dslFile", "Lruntime/reactive/MutableProperty;", "Lcom/intellij/openapi/vfs/VirtualFile;", "dslFile", "Lruntime/reactive/Property;", "getDslFile", "()Lruntime/reactive/Property;", "fileListener", "com/intellij/space/kotlin/scriptdefinition/detect/SpaceKtsFileDetector$fileListener$1", "Lcom/intellij/space/kotlin/scriptdefinition/detect/SpaceKtsFileDetector$fileListener$1;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "checkIsDslFileExists", "dispose", "", "handleFileChanged", "name", "", "refreshScript", "Companion", "intellij.space.kotlin"})
@SourceDebugExtension(value={"SMAP\nSpaceKtsFileDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceKtsFileDetector.kt\ncom/intellij/space/kotlin/scriptdefinition/detect/SpaceKtsFileDetector\n+ 2 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,83:1\n16#2:84\n*S KotlinDebug\n*F\n+ 1 SpaceKtsFileDetector.kt\ncom/intellij/space/kotlin/scriptdefinition/detect/SpaceKtsFileDetector\n*L\n81#1:84\n*E\n"})
public final class SpaceKtsFileDetector
implements LifetimedDisposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final /* synthetic */ LifetimedDisposable $$delegate_0;
    @NotNull
    private final MutableProperty<VirtualFile> _dslFile;
    @NotNull
    private final fileListener.1 fileListener;
    @NotNull
    private static final KLogger LOG;

    public SpaceKtsFileDetector(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.$$delegate_0 = UtilitiesKt.LifetimedDisposable();
        this._dslFile = PropertyKt.mutableProperty(null);
        this.fileListener = new VirtualFileListener(this){
            final /* synthetic */ SpaceKtsFileDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (Intrinsics.areEqual((Object)event2.getPropertyName(), (Object)"name")) {
                    SpaceKtsFileDetector.access$handleFileChanged(this.this$0, event2.getOldValue().toString());
                    SpaceKtsFileDetector.access$handleFileChanged(this.this$0, event2.getNewValue().toString());
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                String string2 = event2.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.fileName");
                SpaceKtsFileDetector.access$handleFileChanged(this.this$0, string2);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                String string2 = event2.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.fileName");
                SpaceKtsFileDetector.access$handleFileChanged(this.this$0, string2);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                String string2 = event2.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.fileName");
                SpaceKtsFileDetector.access$handleFileChanged(this.this$0, string2);
            }
        };
        LOG.info("SpaceKtsFileDetector");
        this.refreshScript();
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this.fileListener);
        this.getLifetime().add((Function)new Function0<Unit>(){

            public final void invoke() {
                LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)fileListener);
            }
        });
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.$$delegate_0.getLifetime();
    }

    public void dispose() {
        this.$$delegate_0.dispose();
    }

    @NotNull
    public final Property<VirtualFile> getDslFile() {
        return this._dslFile;
    }

    private final void refreshScript() {
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SpaceKtsFileDetector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!SpaceKtsFileDetector.access$getProject$p(this.this$0).isDisposed()) {
                    SpaceKtsFileDetector.access$get_dslFile$p(this.this$0).setValue(SpaceKtsFileDetector.access$checkIsDslFileExists(this.this$0));
                }
            }
        }));
    }

    private final void handleFileChanged(String name2) {
        if (DslFileFinder.INSTANCE.checkFileNameIsApplicable(name2)) {
            this.refreshScript();
        }
    }

    private final VirtualFile checkIsDslFileExists() {
        return DslFileFinder.INSTANCE.find(this.project);
    }

    public static final /* synthetic */ Project access$getProject$p(SpaceKtsFileDetector $this) {
        return $this.project;
    }

    public static final /* synthetic */ MutableProperty access$get_dslFile$p(SpaceKtsFileDetector $this) {
        return $this._dslFile;
    }

    public static final /* synthetic */ VirtualFile access$checkIsDslFileExists(SpaceKtsFileDetector $this) {
        return $this.checkIsDslFileExists();
    }

    public static final /* synthetic */ void access$handleFileChanged(SpaceKtsFileDetector $this, String name2) {
        $this.handleFileChanged(name2);
    }

    static {
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceKtsFileDetector.class));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/kotlin/scriptdefinition/detect/SpaceKtsFileDetector$Companion;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "intellij.space.kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

