/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.HiDPIImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/space/gateway/ui/ImageLoader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "loadImage", "Ljava/awt/Image;", "path", "", "width", "", "height", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\npromo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 promo.kt\ncom/intellij/space/gateway/ui/ImageLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n10#2:165\n*S KotlinDebug\n*F\n+ 1 promo.kt\ncom/intellij/space/gateway/ui/ImageLoader\n*L\n135#1:165\n*E\n"})
final class ImageLoader {
    @NotNull
    public static final ImageLoader INSTANCE = new ImageLoader();
    @NotNull
    private static final Logger LOG;

    private ImageLoader() {
    }

    @Nullable
    public final Image loadImage(@NotNull String path2, int width, int height) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path2));
            Intrinsics.checkNotNullExpressionValue((Object)img, (String)"img");
            image = (Image)new HiDPIImage((Image)img, width, height, img.getType());
        }
        catch (Exception e) {
            LOG.error("Image " + path2 + " is not loaded");
            image = null;
        }
        return image;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ImageLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        LOG = logger2;
    }
}

