/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.components;

import circlet.client.api.TeamDirectoryKt;
import circlet.workspaces.Workspace;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.ui.SpaceAvatarUtils;
import com.intellij.space.ui.icons.SpaceMeIcon;
import com.intellij.space.ui.image.SpaceImageLoader;
import com.intellij.space.utils.LifetimedDisposable;
import com.intellij.space.utils.UtilitiesKt;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.Lifetimed;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Property;
import runtime.reactive.property.MapInitKt;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/intellij/space/components/SpaceUserAvatarProvider;", "Lcom/intellij/space/utils/LifetimedDisposable;", "()V", "_avatarStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/space/ui/icons/SpaceMeIcon;", "avatarPlaceholder", "avatarStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getAvatarStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "avatars", "Lruntime/reactive/Property;", "getAvatars", "()Lruntime/reactive/Property;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "dispose", "", "Companion", "intellij.space"})
@SourceDebugExtension(value={"SMAP\nSpaceUserAvatarProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceUserAvatarProvider.kt\ncom/intellij/space/components/SpaceUserAvatarProvider\n+ 2 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,70:1\n16#2:71\n*S KotlinDebug\n*F\n+ 1 SpaceUserAvatarProvider.kt\ncom/intellij/space/components/SpaceUserAvatarProvider\n*L\n64#1:71\n*E\n"})
public final class SpaceUserAvatarProvider
implements LifetimedDisposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ LifetimedDisposable $$delegate_0;
    @NotNull
    private final SpaceMeIcon avatarPlaceholder = SpaceMeIcon.Placeholder.INSTANCE;
    @NotNull
    private final Property<SpaceMeIcon> avatars = MapInitKt.mapInit((Lifetimed)this.getLifetime(), SpaceWorkspaceComponent.Companion.getInstance().getWorkspace(), this.avatarPlaceholder, (Function3)new Function3<Lifetimed, Workspace, Continuation<? super SpaceMeIcon>, Object>(this, null){
        Object L$1;
        int label;
        /* synthetic */ Object L$0;
        final /* synthetic */ SpaceUserAvatarProvider this$0;
        {
            this.this$0 = $receiver;
            super(3, $completion);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Object invokeSuspend(@NotNull Object object) {
            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch (this.label) {
                case 0: {
                    BufferedImage loadedImage;
                    ResultKt.throwOnFailure((Object)object);
                    Workspace ws = (Workspace)this.L$0;
                    if (ws == null) {
                        return SpaceUserAvatarProvider.access$getAvatarPlaceholder$p(this.this$0);
                    }
                    String id2 = ws.getMe().getValue().getUsername();
                    String name2 = TeamDirectoryKt.englishFullName(ws.getMe().getValue());
                    String string2 = ws.getMe().getValue().getSmallAvatar();
                    if (string2 == null) {
                        return SpaceAvatarUtils.INSTANCE.generateAvatars(id2, name2);
                    }
                    String avatarTID = string2;
                    SpaceImageLoader imageLoader = SpaceImageLoader.Companion.getInstance();
                    KLogger this_$iv = SpaceUserAvatarProvider.access$getLOG$cp();
                    boolean $i$f$info = false;
                    if (this_$iv.isInfoEnabled()) {
                        boolean bl = false;
                        String msgStr$iv = "loading user avatar: " + avatarTID;
                        this_$iv.info(msgStr$iv);
                    }
                    this.L$0 = id2;
                    this.L$1 = name2;
                    this.label = 1;
                    Object object3 = imageLoader.loadImage(avatarTID, (Continuation<? super BufferedImage>)((Continuation)this));
                    if (object3 != object2) return loadedImage == null ? SpaceAvatarUtils.INSTANCE.generateAvatars(id2, name2) : SpaceAvatarUtils.INSTANCE.createAvatars(loadedImage);
                    return object2;
                }
                case 1: {
                    BufferedImage loadedImage;
                    Object object3;
                    String name2 = (String)this.L$1;
                    String id2 = (String)this.L$0;
                    try {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        object3 = $result;
                        loadedImage = (BufferedImage)object3;
                        return loadedImage == null ? SpaceAvatarUtils.INSTANCE.generateAvatars(id2, name2) : SpaceAvatarUtils.INSTANCE.createAvatars(loadedImage);
                    }
                    catch (CancellationException th) {
                        throw th;
                    }
                    catch (Exception e) {
                        KLogger this_$iv = SpaceUserAvatarProvider.access$getLOG$cp();
                        boolean $i$f$error = false;
                        if (!this_$iv.isErrorEnabled()) return SpaceUserAvatarProvider.access$getAvatarPlaceholder$p(this.this$0);
                        boolean bl = false;
                        String msgStr$iv = "user avatar not loaded: " + e;
                        this_$iv.error(msgStr$iv);
                        return SpaceUserAvatarProvider.access$getAvatarPlaceholder$p(this.this$0);
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Nullable
        public final Object invoke(@NotNull Lifetimed p1, @Nullable Workspace p2, @Nullable Continuation<? super SpaceMeIcon> p3) {
            var var4_4 = new /* invalid duplicate definition of identical inner class */;
            var4_4.L$0 = p2;
            return var4_4.invokeSuspend(Unit.INSTANCE);
        }
    });
    @NotNull
    private final MutableStateFlow<SpaceMeIcon> _avatarStateFlow = StateFlowKt.MutableStateFlow((Object)this.avatarPlaceholder);
    @ApiStatus.Experimental
    @NotNull
    private final StateFlow<SpaceMeIcon> avatarStateFlow = FlowKt.asStateFlow(this._avatarStateFlow);
    @NotNull
    private static final KLogger LOG;

    public SpaceUserAvatarProvider() {
        this.$$delegate_0 = UtilitiesKt.LifetimedDisposable();
        this.avatars.forEach(this.getLifetime(), (Function1<SpaceMeIcon, Unit>)((Function1)new Function1<SpaceMeIcon, Unit>(){

            public final void invoke(@NotNull SpaceMeIcon it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                _avatarStateFlow.setValue((Object)it);
            }
        }));
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.$$delegate_0.getLifetime();
    }

    public void dispose() {
        this.$$delegate_0.dispose();
    }

    @NotNull
    public final Property<SpaceMeIcon> getAvatars() {
        return this.avatars;
    }

    @NotNull
    public final StateFlow<SpaceMeIcon> getAvatarStateFlow() {
        return this.avatarStateFlow;
    }

    public static final /* synthetic */ SpaceMeIcon access$getAvatarPlaceholder$p(SpaceUserAvatarProvider $this) {
        return $this.avatarPlaceholder;
    }

    public static final /* synthetic */ KLogger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceUserAvatarProvider.class));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/components/SpaceUserAvatarProvider$Companion;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "getInstance", "Lcom/intellij/space/components/SpaceUserAvatarProvider;", "intellij.space"})
    @SourceDebugExtension(value={"SMAP\nSpaceUserAvatarProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceUserAvatarProvider.kt\ncom/intellij/space/components/SpaceUserAvatarProvider$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,70:1\n43#2,3:71\n*S KotlinDebug\n*F\n+ 1 SpaceUserAvatarProvider.kt\ncom/intellij/space/components/SpaceUserAvatarProvider$Companion\n*L\n66#1:71,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpaceUserAvatarProvider getInstance() {
            boolean $i$f$service = false;
            Class<SpaceUserAvatarProvider> serviceClass$iv = SpaceUserAvatarProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (SpaceUserAvatarProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

