/*
 * Decompiled with CFR 0.152.
 */
package circlet.teamdir;

import circlet.client.api.ProfileMembershipRecord;
import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TD_Membership;
import circlet.client.api.TD_ProfileLanguage;
import circlet.client.api.TD_ProfileName;
import circlet.client.api.TD_Team;
import circlet.client.api.TeamDirectoryKt;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import circlet.teamdir.SearchResult;
import circlet.teamdir.TeamDirectoryStateKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.matchers.PatternMatcher;
import runtime.matchers.PatternMatcherKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005JQ\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u000e2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016JG\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00180\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u000e\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\fJ\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\u0010\"\u001a\u00060\fj\u0002`#R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lcirclet/teamdir/TeamDirectoryState;", "", "records", "", "Lcirclet/teamdir/TeamDirectoryState$Record;", "(Ljava/util/List;)V", "getRecords", "()Ljava/util/List;", "calcScore", "", "record", "byQuery", "", "starredMembers", "", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TD_MemberProfile;", "starredTeams", "Lcirclet/client/api/TD_Team;", "cachedToday", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "(Lcirclet/teamdir/TeamDirectoryState$Record;Ljava/lang/String;[Lcirclet/platform/api/Ref;[Lcirclet/platform/api/Ref;Lcirclet/platform/api/KotlinXDate;)I", "filter", "Lcirclet/teamdir/SearchResult;", "(Ljava/lang/String;[Lcirclet/platform/api/Ref;[Lcirclet/platform/api/Ref;)Ljava/util/List;", "filterTeamMember", "", "member", "findById", "profileId", "findByUsername", "username", "teamMembersWithSubteamsMembers", "teamId", "Lcirclet/platform/api/TID;", "Record", "app-state"})
@SourceDebugExtension(value={"SMAP\nTeamDirectoryState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamDirectoryState.kt\ncirclet/teamdir/TeamDirectoryState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,143:1\n1#2:144\n766#3:145\n857#3,2:146\n766#3:148\n857#3,2:149\n1549#3:151\n1620#3,3:152\n1054#3:155\n1549#3:156\n1620#3,3:157\n1963#3,14:160\n1747#3,3:177\n12744#4,2:174\n12744#4:176\n12745#4:180\n*S KotlinDebug\n*F\n+ 1 TeamDirectoryState.kt\ncirclet/teamdir/TeamDirectoryState\n*L\n30#1:145\n30#1:146,2\n35#1:148\n35#1:149,2\n37#1:151\n37#1:152,3\n40#1:155\n59#1:156\n59#1:157,3\n64#1:160,14\n68#1:177,3\n67#1:174,2\n68#1:176\n68#1:180\n*E\n"})
public final class TeamDirectoryState {
    @NotNull
    private final List<Record> records;

    public TeamDirectoryState(@NotNull List<Record> records2) {
        Intrinsics.checkNotNullParameter(records2, (String)"records");
        this.records = records2;
    }

    @NotNull
    public final List<Record> getRecords() {
        return this.records;
    }

    @Nullable
    public final Record findByUsername(@NotNull String username) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Iterable iterable = this.records;
            for (Object t : iterable) {
                Record it = (Record)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)RefResolveKt.resolve(it.getProfile()).getUsername(), (Object)username)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Record findById(@NotNull String profileId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
            Iterable iterable = this.records;
            for (Object t : iterable) {
                Record it = (Record)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProfile().getId(), (Object)profileId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Record> teamMembersWithSubteamsMembers(@NotNull String teamId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)teamId, (String)"teamId");
        KotlinXDate cachedToday = ADateJvmKt.getToday();
        Iterable $this$filter$iv = this.records;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Record it = (Record)element$iv$iv;
            boolean bl = false;
            if (!it.isMember(teamId, true, cachedToday)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SearchResult<Record>> filter(@NotNull String byQuery, @NotNull Ref<TD_MemberProfile>[] starredMembers2, @NotNull Ref<TD_Team>[] starredTeams2) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Record it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)byQuery, (String)"byQuery");
        Intrinsics.checkNotNullParameter(starredMembers2, (String)"starredMembers");
        Intrinsics.checkNotNullParameter(starredTeams2, (String)"starredTeams");
        KotlinXDate cachedToday = ADateJvmKt.getToday();
        Iterable $this$filter$iv = this.records;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Record)element$iv$iv;
            boolean bl = false;
            if (!this.filterTeamMember(it, byQuery)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Record)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int score2 = this.calcScore(it, byQuery, starredMembers2, starredTeams2, cachedToday);
            collection.add(new SearchResult<Record>(RefResolveKt.resolve(it.getProfile()).getUsername(), it, it.getProfile().getId(), score2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SearchResult it = (SearchResult)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getScore());
                it = (SearchResult)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getScore()));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean filterTeamMember(Record member, String byQuery) {
        String string2 = byQuery.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String query2 = string2;
        TD_MemberProfile profile2 = RefResolveKt.resolve(member.getProfile());
        String string3 = TeamDirectoryKt.englishFullName(profile2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)query2, (boolean)false, (int)2, null)) return true;
        String string4 = profile2.getUsername().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)query2, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int calcScore(Record record2, String byQuery, Ref<TD_MemberProfile>[] starredMembers2, Ref<TD_Team>[] starredTeams2, KotlinXDate cachedToday) {
        boolean bl;
        boolean isStarredAsMember;
        int maxScoreEver;
        TD_MemberProfile profile2;
        block13: {
            boolean bl2;
            int n;
            block11: {
                Object v3;
                void $this$mapTo$iv$iv;
                String string2 = byQuery.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                PatternMatcher matcher2 = PatternMatcherKt.patternMatcher$default(string2, false, false, 6, null);
                profile2 = RefResolveKt.resolve(record2.getProfile());
                Iterable $this$map$iv = profile2.getLanguages();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TD_ProfileLanguage tD_ProfileLanguage = (TD_ProfileLanguage)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    TD_ProfileName tD_ProfileName = it.getName();
                    TD_ProfileName tD_ProfileName2 = it.getName();
                    int matchRes = matcher2.matchResult((tD_ProfileName != null ? tD_ProfileName.getFirstName() : null) + " " + (tD_ProfileName2 != null ? tD_ProfileName2.getLastName() : null));
                    collection.add(TuplesKt.to((Object)matchRes, (Object)it.getLanguage().getId()));
                }
                List matches2 = (List)destination$iv$iv;
                Iterable $this$maxByOrNull$iv = matches2;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v3 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v3 = maxElem$iv;
                    } else {
                        Pair it = (Pair)maxElem$iv;
                        boolean bl4 = false;
                        int maxValue$iv = ((Number)it.getFirst()).intValue();
                        do {
                            Object e$iv = iterator$iv.next();
                            Pair it2 = (Pair)e$iv;
                            $i$a$-maxByOrNull-TeamDirectoryState$calcScore$maxScoreLang$1 = false;
                            int v$iv = ((Number)it2.getFirst()).intValue();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v3 = maxElem$iv;
                    }
                }
                Pair maxScoreLang = v3;
                int usernameMatch = matcher2.matchResult(profile2.getUsername());
                Pair pair = maxScoreLang;
                maxScoreEver = Math.max(pair != null ? ((Number)pair.getFirst()).intValue() : 0, usernameMatch);
                Ref<TD_MemberProfile>[] $this$any$iv = starredMembers2;
                boolean $i$f$any = false;
                n = $this$any$iv.length;
                for (int e$iv = 0; e$iv < n; ++e$iv) {
                    Ref<TD_MemberProfile> element$iv;
                    Ref<TD_MemberProfile> it = element$iv = $this$any$iv[e$iv];
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)RefResolveKt.resolve(it).getUsername(), (Object)profile2.getUsername())) continue;
                    bl2 = true;
                    break block11;
                }
                bl2 = false;
            }
            isStarredAsMember = bl2;
            Ref<TD_Team>[] $this$any$iv = starredTeams2;
            boolean $i$f$any = false;
            int n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                boolean bl6;
                block12: {
                    Ref<TD_Team> element$iv;
                    Ref<TD_Team> it = element$iv = $this$any$iv[n];
                    boolean bl7 = false;
                    Iterable $this$any$iv2 = RefResolveKt.resolve(record2.getMemberships()).getMemberships();
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv2) {
                            TD_Membership m2 = (TD_Membership)element$iv2;
                            boolean bl8 = false;
                            if (!(TeamDirectoryStateKt.access$outdatedPerf(m2, cachedToday) && Intrinsics.areEqual((Object)m2.getTeam().getId(), (Object)it.getId()))) continue;
                            bl6 = true;
                            break block12;
                        }
                        bl6 = false;
                    }
                }
                if (!bl6) continue;
                bl = true;
                break block13;
            }
            bl = false;
        }
        boolean isStarredAsTeam = bl;
        return maxScoreEver | 0x40 | (profile2.getNotAMember() ? 2048 : 0) | (isStarredAsTeam || isStarredAsMember ? 256 : 0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\f2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lcirclet/teamdir/TeamDirectoryState$Record;", "", "profile", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TD_MemberProfile;", "memberships", "Lcirclet/client/api/ProfileMembershipRecord;", "(Lcirclet/platform/api/Ref;Lcirclet/platform/api/Ref;)V", "getMemberships", "()Lcirclet/platform/api/Ref;", "getProfile", "isMember", "", "teamId", "", "Lcirclet/platform/api/TID;", "subteams", "day", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "app-state"})
    @SourceDebugExtension(value={"SMAP\nTeamDirectoryState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamDirectoryState.kt\ncirclet/teamdir/TeamDirectoryState$Record\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1747#2,3:144\n*S KotlinDebug\n*F\n+ 1 TeamDirectoryState.kt\ncirclet/teamdir/TeamDirectoryState$Record\n*L\n16#1:144,3\n*E\n"})
    public static final class Record {
        @NotNull
        private final Ref<TD_MemberProfile> profile;
        @NotNull
        private final Ref<ProfileMembershipRecord> memberships;

        public Record(@NotNull Ref<TD_MemberProfile> profile2, @NotNull Ref<ProfileMembershipRecord> memberships2) {
            Intrinsics.checkNotNullParameter(profile2, (String)"profile");
            Intrinsics.checkNotNullParameter(memberships2, (String)"memberships");
            this.profile = profile2;
            this.memberships = memberships2;
        }

        @NotNull
        public final Ref<TD_MemberProfile> getProfile() {
            return this.profile;
        }

        @NotNull
        public final Ref<ProfileMembershipRecord> getMemberships() {
            return this.memberships;
        }

        public final boolean isMember(@NotNull String teamId, boolean subteams, @NotNull KotlinXDate day) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)teamId, (String)"teamId");
                Intrinsics.checkNotNullParameter((Object)day, (String)"day");
                Iterable $this$any$iv = RefResolveKt.resolve(this.memberships).getMemberships();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TD_Membership it = (TD_Membership)element$iv;
                        boolean bl2 = false;
                        if (!TeamDirectoryStateKt.isMember(it, teamId, subteams, day)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

