/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.BusyStatus;
import circlet.common.calendar.CalendarEventSpec;
import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.FormatKt;
import circlet.common.calendar.SpecInstancesKt;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.WeekdayFormat;
import circlet.platform.api.WorkingDaysKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.date.DateFormat;
import runtime.date.FormattersKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a6\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0005\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u001e\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e\u001a\"\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0000\u001a\u001e\u0010\u0015\u001a\u00020\u000b*\u00020\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0017*\u00020\u0001\u001a\f\u0010\u001b\u001a\u00020\t*\u0004\u0018\u00010\t\u001a\u001c\u0010\u001c\u001a\u00020\u000b*\u00020\u00012\u0010\b\u0002\u0010\u001d\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u001a\n\u0010\u001e\u001a\u00020\u0012*\u00020\u0001\u00a8\u0006\u001f"}, d2={"allDayEventSpec", "Lcirclet/common/calendar/CalendarEventSpec;", "sinceDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "tillDate", "timezone", "Lcirclet/platform/api/ATimeZone;", "busyStatus", "Lcirclet/common/calendar/BusyStatus;", "meetingTimeRangeInConflicts", "", "start", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "end", "timeRangeTextImpl", "from", "", "to", "daysBetween", "buildOccurrenceText", "withTime", "", "weekdayFormat", "Lcirclet/platform/api/WeekdayFormat;", "isRecurring", "orDefault", "timeRangeText", "targetDate", "toDuration", "common"})
@SourceDebugExtension(value={"SMAP\nCalendarEventSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarEventSpec.kt\ncirclet/common/calendar/CalendarEventSpecKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1#2:130\n819#3:131\n847#3,2:132\n*S KotlinDebug\n*F\n+ 1 CalendarEventSpec.kt\ncirclet/common/calendar/CalendarEventSpecKt\n*L\n91#1:131\n91#1:132,2\n*E\n"})
public final class CalendarEventSpecKt {
    @NotNull
    public static final BusyStatus orDefault(@Nullable BusyStatus $this$orDefault) {
        BusyStatus busyStatus = $this$orDefault;
        if (busyStatus == null) {
            busyStatus = BusyStatus.Busy;
        }
        return busyStatus;
    }

    public static final boolean isRecurring(@NotNull CalendarEventSpec $this$isRecurring) {
        Intrinsics.checkNotNullParameter((Object)$this$isRecurring, (String)"<this>");
        return $this$isRecurring.getRecurrenceRule() != null || $this$isRecurring.getParentId() != null;
    }

    public static final int toDuration(@NotNull CalendarEventSpec $this$toDuration) {
        Intrinsics.checkNotNullParameter((Object)$this$toDuration, (String)"<this>");
        return ADateKt.minutesDifferenceAbs($this$toDuration.getEnd(), $this$toDuration.getStart());
    }

    @NotNull
    public static final String timeRangeText(@NotNull CalendarEventSpec $this$timeRangeText, @Nullable KotlinXDate targetDate) {
        Intrinsics.checkNotNullParameter((Object)$this$timeRangeText, (String)"<this>");
        KotlinXDate kotlinXDate = targetDate;
        if (kotlinXDate == null && (kotlinXDate = EventCountersKt.nextStartDate($this$timeRangeText, ADateJvmKt.getANow(), true)) == null) {
            kotlinXDate = ADateJvmKt.toDate($this$timeRangeText.getStart());
        }
        KotlinXDate rangeOnDate = kotlinXDate;
        return CalendarEventSpecKt.timeRangeTextImpl(ADateKt.toLocalMinutesOnDate$default($this$timeRangeText.getStart(), $this$timeRangeText.getTimezone(), rangeOnDate, null, 4, null), ADateKt.toLocalMinutesOnDate$default($this$timeRangeText.getEnd(), $this$timeRangeText.getTimezone(), rangeOnDate, null, 4, null), SpecInstancesKt.durationInDays$default($this$timeRangeText, null, 1, null));
    }

    public static /* synthetic */ String timeRangeText$default(CalendarEventSpec calendarEventSpec, KotlinXDate kotlinXDate, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDate = null;
        }
        return CalendarEventSpecKt.timeRangeText(calendarEventSpec, kotlinXDate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String buildOccurrenceText(@NotNull CalendarEventSpec $this$buildOccurrenceText, boolean withTime, @NotNull WeekdayFormat weekdayFormat) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$buildOccurrenceText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)weekdayFormat), (String)"weekdayFormat");
        List res = new ArrayList();
        if (withTime) {
            res.add(CalendarEventSpecKt.timeRangeText$default($this$buildOccurrenceText, null, 1, null));
        }
        if ($this$buildOccurrenceText.getRecurrenceRule() == null) {
            res.add(PrimitivesExKt.format($this$buildOccurrenceText.getStart(), DateFormat.DAY_MONTH_AND_YEAR) + ", " + WorkingDaysKt.title(ADateJvmKt.getWeekday($this$buildOccurrenceText.getStart()), weekdayFormat));
        } else {
            String it = FormatKt.format($this$buildOccurrenceText.getRecurrenceRule(), $this$buildOccurrenceText.getStart(), weekdayFormat);
            boolean bl = false;
            res.add(it);
        }
        Iterable $this$filterNot$iv = res;
        boolean $i$f$filterNot = false;
        Iterable bl = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
    }

    public static /* synthetic */ String buildOccurrenceText$default(CalendarEventSpec calendarEventSpec, boolean bl, WeekdayFormat weekdayFormat, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            weekdayFormat = WeekdayFormat.LONG;
        }
        return CalendarEventSpecKt.buildOccurrenceText(calendarEventSpec, bl, weekdayFormat);
    }

    @NotNull
    public static final String timeRangeTextImpl(int from, int to, int daysBetween) {
        Object object;
        String string2 = FormatKt.formatMinutesAsTime(from);
        if (to == 0) {
            object = "24:00";
        } else {
            Object object2;
            String string3 = FormatKt.formatMinutesAsTime(to);
            switch (daysBetween) {
                case 0: {
                    object2 = "";
                    break;
                }
                case 1: {
                    object2 = " (+1 day)";
                    break;
                }
                default: {
                    object2 = " (+" + daysBetween + " days)";
                }
            }
            object = string3 + (String)object2;
        }
        return FormattersKt.timeRangeText(string2, (String)object);
    }

    public static /* synthetic */ String timeRangeTextImpl$default(int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return CalendarEventSpecKt.timeRangeTextImpl(n, n2, n3);
    }

    @NotNull
    public static final String meetingTimeRangeInConflicts(@NotNull KotlinXDateTime start2, @NotNull KotlinXDateTime end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        KotlinXDateTime startTime = ADateJvmKt.withZone(start2, ADateJvmKt.getClientTimeZone());
        KotlinXDateTime endTime = ADateJvmKt.withZone(end, ADateJvmKt.getClientTimeZone());
        if (ADateJvmKt.getMinuteOfDay(startTime) == 0) {
            return "until " + PrimitivesExKt.format(endTime, DateFormat.HOURS_AND_MINUTES);
        }
        if (ADateJvmKt.getMinuteOfDay(endTime) == 0 || ADateJvmKt.getMinuteOfDay(ADateJvmKt.plusMinutes(endTime, 1)) == 0 || ADateJvmKt.getMinuteOfDay(ADateJvmKt.plusMinutes(endTime, 2)) == 0) {
            return "after " + PrimitivesExKt.format(startTime, DateFormat.HOURS_AND_MINUTES);
        }
        return CalendarEventSpecKt.timeRangeTextImpl(ADateJvmKt.getMinuteOfDay(startTime), ADateJvmKt.getMinuteOfDay(endTime), SpecInstancesKt.durationInDays$default(new Pair((Object)startTime, (Object)endTime), null, 1, null));
    }

    @NotNull
    public static final CalendarEventSpec allDayEventSpec(@NotNull KotlinXDate sinceDate, @NotNull KotlinXDate tillDate, @NotNull ATimeZone timezone, @Nullable BusyStatus busyStatus) {
        Intrinsics.checkNotNullParameter((Object)sinceDate, (String)"sinceDate");
        Intrinsics.checkNotNullParameter((Object)tillDate, (String)"tillDate");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        return new CalendarEventSpec(ADateJvmKt.toDateTimeAtStartOfDay(sinceDate, timezone), ADateJvmKt.plusMinutes(ADateJvmKt.plusDays(ADateJvmKt.toDateTimeAtStartOfDay(tillDate, timezone), 1), -1), null, true, timezone, null, null, busyStatus, null, 352, null);
    }

    public static /* synthetic */ CalendarEventSpec allDayEventSpec$default(KotlinXDate kotlinXDate, KotlinXDate kotlinXDate2, ATimeZone aTimeZone, BusyStatus busyStatus, int n, Object object) {
        if ((n & 2) != 0) {
            kotlinXDate2 = kotlinXDate;
        }
        if ((n & 4) != 0) {
            aTimeZone = ADateKt.getUtcTimeZone();
        }
        if ((n & 8) != 0) {
            busyStatus = null;
        }
        return CalendarEventSpecKt.allDayEventSpec(kotlinXDate, kotlinXDate2, aTimeZone, busyStatus);
    }
}

