/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.richText;

import circlet.client.api.richText.CellDim;
import circlet.client.api.richText.RichTextNodePathItem;
import circlet.client.api.richText.RichTextSchemaVersion;
import circlet.client.api.richText.RichTextValidationError;
import circlet.client.api.richText.RtDocument;
import circlet.client.api.richText.RtDocumentMark;
import circlet.client.api.richText.RtDocumentNode;
import circlet.client.api.richText.RtFirstListItemContentNode;
import circlet.client.api.richText.RtInlineNodeWithMarks;
import circlet.client.api.richText.RtListItem;
import circlet.client.api.richText.RtNodeWithChildren;
import circlet.client.api.richText.RtTable;
import circlet.client.api.richText.RtTableRow;
import circlet.client.api.richText.RtTableRowContent;
import circlet.client.api.richText.RtText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\t\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003*\u00020\f\u001a0\u0010\n\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"tableWidth", "", "rows", "", "Lcirclet/client/api/richText/RtTableRow;", "validateTableDimensions", "", "schemaVersion", "tableHeight", "Lcirclet/client/api/richText/RtTable;", "validate", "Lcirclet/client/api/richText/RichTextValidationError;", "Lcirclet/client/api/richText/RtDocument;", "", "", "path", "Lcirclet/client/api/richText/RichTextNodePathItem;", "node", "Lcirclet/client/api/richText/RtNodeWithChildren;", "client-api"})
@SourceDebugExtension(value={"SMAP\nvalidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 validation.kt\ncirclet/client/api/richText/ValidationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,122:1\n1#2:123\n1864#3,2:124\n1655#3,8:126\n1866#3:134\n1864#3,2:135\n1864#3,2:137\n1866#3:145\n1866#3:146\n1627#4,6:139\n*S KotlinDebug\n*F\n+ 1 validation.kt\ncirclet/client/api/richText/ValidationKt\n*L\n30#1:124,2\n37#1:126,8\n30#1:134\n66#1:135,2\n69#1:137,2\n69#1:145\n66#1:146\n73#1:139,6\n*E\n"})
public final class ValidationKt {
    @NotNull
    public static final List<RichTextValidationError> validate(@NotNull RtDocument $this$validate) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        RichTextSchemaVersion.INSTANCE.checkClientVersion($this$validate.getVersion());
        List $this$validate_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        ValidationKt.validate($this$validate_u24lambda_u240, new ArrayList(), $this$validate, $this$validate.getVersion());
        return CollectionsKt.build((List)list2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void validate(List<RichTextValidationError> $this$validate, List<RichTextNodePathItem> path2, RtNodeWithChildren node, String schemaVersion) {
        if (node instanceof RtTable) {
            String string2 = ValidationKt.validateTableDimensions(((RtTable)node).getChildren(), schemaVersion);
            if (string2 != null) {
                String error2 = string2;
                boolean bl = false;
                $this$validate.add(new RichTextValidationError(CollectionsKt.toList((Iterable)path2), error2));
            }
        }
        Iterable $this$forEachIndexed$iv = node.getChildren();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void child;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RtDocumentNode rtDocumentNode = (RtDocumentNode)item$iv;
            int ix = n;
            boolean bl = false;
            path2.add(new RichTextNodePathItem((KClass<? extends RtDocumentNode>)Reflection.getOrCreateKotlinClass(child.getClass()), (Integer)ix));
            if (child instanceof RtText && ((CharSequence)((RtText)child).getValue()).length() == 0) {
                $this$validate.add(new RichTextValidationError(CollectionsKt.toList((Iterable)path2), "Empty text nodes are not allowed"));
            }
            if (child instanceof RtInlineNodeWithMarks) {
                void $this$distinctBy$iv;
                List<RtDocumentMark> marks = ((RtInlineNodeWithMarks)child).getMarks();
                boolean bl2 = false;
                Iterable iterable = marks;
                int n2 = ((Collection)marks).size();
                boolean $i$f$distinctBy = false;
                HashSet<KClass> set$iv = new HashSet<KClass>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    RtDocumentMark it = (RtDocumentMark)e$iv;
                    boolean bl3 = false;
                    KClass key$iv = Reflection.getOrCreateKotlinClass(it.getClass());
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                List list2 = list$iv;
                if (n2 != ((Collection)list2).size()) {
                    $this$validate.add(new RichTextValidationError(CollectionsKt.toList((Iterable)path2), "Only single mark of a type is allowed"));
                }
            }
            if (child instanceof RtListItem) {
                if (((RtListItem)child).getChildren().isEmpty()) {
                    $this$validate.add(new RichTextValidationError(CollectionsKt.toList((Iterable)path2), Reflection.getOrCreateKotlinClass(RtListItem.class).getSimpleName() + " must contain at least one child"));
                } else if (!(CollectionsKt.first(((RtListItem)child).getChildren()) instanceof RtFirstListItemContentNode)) {
                    $this$validate.add(new RichTextValidationError(CollectionsKt.toList((Iterable)path2), "First child of " + Reflection.getOrCreateKotlinClass(RtListItem.class).getSimpleName() + " must be of type " + Reflection.getOrCreateKotlinClass(RtFirstListItemContentNode.class).getSimpleName()));
                }
            }
            if (child instanceof RtNodeWithChildren) {
                ValidationKt.validate($this$validate, path2, (RtNodeWithChildren)child, schemaVersion);
            }
            CollectionsKt.removeLast(path2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String validateTableDimensions(@NotNull List<RtTableRow> rows2, @NotNull String schemaVersion) {
        int n;
        Intrinsics.checkNotNullParameter(rows2, (String)"rows");
        Intrinsics.checkNotNullParameter((Object)schemaVersion, (String)"schemaVersion");
        RichTextSchemaVersion.INSTANCE.checkClientVersion(schemaVersion);
        if (rows2.isEmpty()) {
            return null;
        }
        int tableWidth = ValidationKt.tableWidth(rows2);
        int tableHeight = rows2.size();
        CellDim[][] cellDimArrayArray = new CellDim[tableHeight][];
        for (int i = 0; i < tableHeight; ++i) {
            int n2 = i;
            int n3 = 0;
            CellDim[] cellDimArray = new CellDim[tableWidth];
            int n4 = n2;
            CellDim[][] cellDimArrayArray2 = cellDimArrayArray;
            while (n3 < tableWidth) {
                n = n3++;
                cellDimArray[n] = null;
            }
            cellDimArrayArray2[n4] = cellDimArray;
        }
        CellDim[][] tableMap = cellDimArrayArray;
        Iterable $this$forEachIndexed$iv = rows2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void row;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RtTableRow rtTableRow = (RtTableRow)item$iv;
            int rowIndex = n;
            boolean bl = false;
            CellDim[] mapRow = tableMap[rowIndex];
            Iterable $this$forEachIndexed$iv2 = row.getChildren();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                int startW;
                int height;
                int width;
                int cellIndex;
                block15: {
                    int n5;
                    void cell2;
                    int n6;
                    if ((n6 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    RtTableRowContent rtTableRowContent = (RtTableRowContent)item$iv2;
                    cellIndex = n6;
                    boolean bl2 = false;
                    width = cell2.getColspan();
                    height = cell2.getRowspan();
                    CellDim[] $this$indexOfFirst$iv = mapRow;
                    boolean $i$f$indexOfFirst = false;
                    int n7 = $this$indexOfFirst$iv.length;
                    for (int index$iv3 = 0; index$iv3 < n7; ++index$iv3) {
                        CellDim it = $this$indexOfFirst$iv[index$iv3];
                        boolean bl3 = false;
                        if (!(it == null)) continue;
                        n5 = index$iv3;
                        break block15;
                    }
                    n5 = startW = -1;
                }
                if (startW == -1) {
                    throw new IllegalArgumentException("row " + rowIndex + " is already filled");
                }
                CellDim cellDim = new CellDim(rowIndex, startW, rowIndex, cellIndex, height, width);
                int n8 = rowIndex + height;
                for (int h = rowIndex; h < n8; ++h) {
                    if (h >= tableHeight) {
                        return "Too long rowspan at row " + rowIndex + ": " + height;
                    }
                    CellDim[] r = tableMap[h];
                    int n9 = startW + width;
                    for (int w = startW; w < n9; ++w) {
                        CellDim cellDim2 = r[w];
                        if (cellDim2 != null) {
                            CellDim it = cellDim2;
                            boolean bl4 = false;
                            return "Cell collision at row=" + h + ", column=" + w;
                        }
                        r[w] = cellDim;
                    }
                }
            }
        }
        for (int h = 0; h < tableHeight; ++h) {
            for (int w = 0; w < tableWidth; ++w) {
                if (tableMap[h][w] != null) continue;
                return "Cell at row=" + h + ", column=" + w + " is not defined";
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final int tableWidth(List<RtTableRow> rows2) {
        Iterable iterable = rows2.get(0).getChildren();
        int n = 0;
        for (Object t : iterable) {
            void it;
            RtTableRowContent rtTableRowContent = (RtTableRowContent)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getColspan();
            n = n2 + n3;
        }
        return n;
    }

    public static final int tableWidth(@NotNull RtTable $this$tableWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$tableWidth, (String)"<this>");
        return $this$tableWidth.getChildren().isEmpty() ? 0 : ValidationKt.tableWidth($this$tableWidth.getChildren());
    }

    public static final int tableHeight(@NotNull RtTable $this$tableHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$tableHeight, (String)"<this>");
        return $this$tableHeight.getChildren().size();
    }
}

