/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.paste;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.datatransfer.Transferable;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtils;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J$\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/paste/MarkdownFileDropHandler;", "Lcom/intellij/openapi/editor/CustomFileDropHandler;", "()V", "canHandle", "", "transferable", "Ljava/awt/datatransfer/Transferable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleDrop", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.markdown.core"})
public final class MarkdownFileDropHandler
extends CustomFileDropHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canHandle(@NotNull Transferable transferable, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        if (editor2 == null) return false;
        if (!editor2.getDocument().isWritable()) {
            return false;
        }
        if (!MarkdownCodeInsightSettings.Companion.getInstance().getState().getEnableFilesDrop()) {
            return false;
        }
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
        if (file == null) return false;
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        if (!MarkdownLanguageUtils.INSTANCE.isMarkdownLanguage(language)) return false;
        return true;
    }

    public boolean handleDrop(@NotNull Transferable transferable, @Nullable Editor editor2, @Nullable Project project) {
        PsiFile file;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
                if (editor2 == null || project == null || !editor2.getDocument().isWritable()) {
                    return false;
                }
                file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
                if (file == null) break block5;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
                if (MarkdownLanguageUtils.INSTANCE.isMarkdownLanguage(language)) break block6;
            }
            return false;
        }
        List list2 = FileCopyPasteUtil.getFiles((Transferable)transferable);
        if (list2 == null || (list2 = CollectionsKt.asSequence((Iterable)list2)) == null) {
            return false;
        }
        List files2 = list2;
        String content2 = Companion.buildTextContent$intellij_markdown_core((Sequence<? extends Path>)files2, file);
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(project, document2, editor2, content2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Document $document;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $content;
            {
                this.$project = $project;
                this.$document = $document;
                this.$editor = $editor;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                MarkdownFileDropHandler.Companion.handleReadOnlyModificationException$intellij_markdown_core(this.$project, this.$document, (Function0<Unit>)((Function0)new Function0<Unit>(this.$project, this.$editor, this.$document, this.$content){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ String $content;
                    {
                        this.$project = $project;
                        this.$editor = $editor;
                        this.$document = $document;
                        this.$content = $content;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void name$iv;
                        void project$iv;
                        Project project = this.$project;
                        String string = org.intellij.plugins.markdown.editor.paste.MarkdownFileDropHandler$Companion.access$getCommandName(MarkdownFileDropHandler.Companion);
                        Editor editor2 = this.$editor;
                        Document document = this.$document;
                        String string2 = this.$content;
                        Object groupId$iv = null;
                        boolean $i$f$executeCommand = false;
                        CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(editor2, document, string2){
                            final /* synthetic */ Editor $editor$inlined;
                            final /* synthetic */ Document $document$inlined;
                            final /* synthetic */ String $content$inlined;
                            {
                                this.$editor$inlined = editor2;
                                this.$document$inlined = document;
                                this.$content$inlined = string;
                            }

                            public final void run() {
                                boolean bl = false;
                                CaretModel caretModel = this.$editor$inlined.getCaretModel();
                                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                                EditorUtilKt.runForEachCaret(caretModel, true, (Function1<? super Caret, Unit>)((Function1)new Function1<Caret, Unit>(this.$document$inlined, this.$content$inlined){
                                    final /* synthetic */ Document $document;
                                    final /* synthetic */ String $content;
                                    {
                                        this.$document = $document;
                                        this.$content = $content;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Caret caret) {
                                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                                        this.$document.insertString(caret.getOffset(), (CharSequence)this.$content);
                                        caret.moveToOffset(this.$content.length());
                                    }
                                }));
                            }
                        }, (String)name$iv, groupId$iv);
                    }
                }));
            }
        }));
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J+\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0002R\u001e\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/editor/paste/MarkdownFileDropHandler$Companion;", "", "()V", "commandName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getCommandName", "()Ljava/lang/String;", "buildTextContent", "files", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "file", "Lcom/intellij/psi/PsiFile;", "buildTextContent$intellij_markdown_core", "createFileLink", "createImageLink", "createUri", "url", "handleReadOnlyModificationException", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "block", "Lkotlin/Function0;", "handleReadOnlyModificationException$intellij_markdown_core", "obtainRelativePath", "path", "currentDirectory", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getCommandName() {
            String string = MarkdownBundle.message("markdown.image.file.drop.handler.drop.command.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.image.\u2026ndler.drop.command.name\")");
            return string;
        }

        @NotNull
        public final String buildTextContent$intellij_markdown_core(@NotNull Sequence<? extends Path> files2, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileType fileType2 = ImageFileTypeManager.getInstance().getImageFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getInstance().imageFileType");
            FileType imageFileType = fileType2;
            FileTypeRegistry registry = FileTypeRegistry.getInstance();
            PsiDirectory psiDirectory = file.getContainingDirectory();
            Path currentDirectory = psiDirectory != null && (psiDirectory = psiDirectory.getVirtualFile()) != null ? psiDirectory.toNioPath() : null;
            Sequence relativePaths2 = SequencesKt.map(files2, (Function1)((Function1)new Function1<Path, Path>(currentDirectory){
                final /* synthetic */ Path $currentDirectory;
                {
                    this.$currentDirectory = $currentDirectory;
                    super(1);
                }

                @NotNull
                public final Path invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return org.intellij.plugins.markdown.editor.paste.MarkdownFileDropHandler$Companion.access$obtainRelativePath(MarkdownFileDropHandler.Companion, it, this.$currentDirectory);
                }
            }));
            return SequencesKt.joinToString$default((Sequence)relativePaths2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Path, CharSequence>(registry, imageFileType){
                final /* synthetic */ FileTypeRegistry $registry;
                final /* synthetic */ FileType $imageFileType;
                {
                    this.$registry = $registry;
                    this.$imageFileType = $imageFileType;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Path path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    FileType fileType2 = this.$registry.getFileTypeByExtension(PathsKt.getExtension((Path)path));
                    return (Intrinsics.areEqual((Object)fileType2, (Object)this.$imageFileType) ? true : Intrinsics.areEqual((Object)fileType2, (Object)SvgFileType.INSTANCE)) ? (CharSequence)org.intellij.plugins.markdown.editor.paste.MarkdownFileDropHandler$Companion.access$createImageLink(MarkdownFileDropHandler.Companion, path) : (CharSequence)org.intellij.plugins.markdown.editor.paste.MarkdownFileDropHandler$Companion.access$createFileLink(MarkdownFileDropHandler.Companion, path);
                }
            }), (int)30, null);
        }

        private final Path obtainRelativePath(Path path, Path currentDirectory) {
            if (currentDirectory == null) {
                return path;
            }
            return PathsKt.relativeTo((Path)path, (Path)currentDirectory);
        }

        private final String createUri(String url) {
            String string = URLEncoder.encode(url, Charset.defaultCharset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(url, Charset.defaultCharset())");
            return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        }

        private final String createImageLink(Path file) {
            String string = PathsKt.getName((Path)file);
            String string2 = FileUtil.toSystemIndependentName((String)((Object)file).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(file.toString())");
            return ImageUtils.createMarkdownImageText$default(string, this.createUri(string2), null, 4, null);
        }

        private final String createFileLink(Path file) {
            String string = FileUtil.toSystemIndependentName((String)((Object)file).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName (file.toString())");
            String independentPath = this.createUri(string);
            return "[" + PathsKt.getName((Path)file) + "](" + independentPath + ")";
        }

        public final void handleReadOnlyModificationException$intellij_markdown_core(@NotNull Project project, @NotNull Document document, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                block.invoke();
            }
            catch (ReadOnlyModificationException exception) {
                Messages.showErrorDialog((Project)project, (String)exception.getLocalizedMessage(), (String)RefactoringBundle.message((String)"error.title"));
            }
            catch (ReadOnlyFragmentModificationException exception) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(exception);
            }
        }

        public static final /* synthetic */ String access$getCommandName(Companion $this) {
            return $this.getCommandName();
        }

        public static final /* synthetic */ Path access$obtainRelativePath(Companion $this, Path path, Path currentDirectory) {
            return $this.obtainRelativePath(path, currentDirectory);
        }

        public static final /* synthetic */ String access$createImageLink(Companion $this, Path file) {
            return $this.createImageLink(file);
        }

        public static final /* synthetic */ String access$createFileLink(Companion $this, Path file) {
            return $this.createFileLink(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

