/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.cli;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.cli.VueCliProjectSettingsStep;
import org.jetbrains.vuejs.cli.VueCliRunningGeneratorController;
import org.jetbrains.vuejs.cli.VueCliRunningGeneratorControllerKt;
import org.jetbrains.vuejs.cli.VueCreateProjectProcess;
import org.jetbrains.vuejs.cli.VueRunningGeneratorListener;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B%\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0017\u001a\u00020\u0010*\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/vuejs/cli/VueCliProjectSettingsStep;", "Lcom/intellij/ide/util/projectWizard/ProjectSettingsStepBase;", "Lcom/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings;", "projectGenerator", "Lcom/intellij/platform/DirectoryProjectGenerator;", "callback", "Lcom/intellij/ide/util/projectWizard/AbstractNewProjectStep$AbstractCallback;", "(Lcom/intellij/platform/DirectoryProjectGenerator;Lcom/intellij/ide/util/projectWizard/AbstractNewProjectStep$AbstractCallback;)V", "mainPanel", "Ljavax/swing/JPanel;", "process", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess;", "checkValid", "", "createPanel", "onError", "", "errorText", "", "removeActionListeners", "replacePanel", "questioningPanel", "setFirstStepActionListener", "startGeneration", "Ljava/awt/event/ActionListener;", "MyVueRunningGeneratorListener", "intellij.vuejs"})
public final class VueCliProjectSettingsStep
extends ProjectSettingsStepBase<NpmPackageProjectGenerator.Settings> {
    private VueCreateProjectProcess process;
    private JPanel mainPanel;

    @NotNull
    public JPanel createPanel() {
        JPanel mainPanel = super.createPanel();
        mainPanel.add((Component)WebProjectTemplate.createTitlePanel(), "North");
        JButton jButton = this.myCreateButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"myCreateButton");
        jButton.setText("Next");
        JPanel jPanel = mainPanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"mainPanel");
        this.setFirstStepActionListener(jPanel);
        this.mainPanel = mainPanel;
        return mainPanel;
    }

    private final void setFirstStepActionListener(JPanel mainPanel) {
        this.removeActionListeners();
        this.myCreateButton.addActionListener(new ActionListener(this, mainPanel){
            final /* synthetic */ VueCliProjectSettingsStep this$0;
            final /* synthetic */ JPanel $mainPanel;

            public void actionPerformed(@Nullable ActionEvent e) {
                VueCliProjectSettingsStep.access$startGeneration(this.this$0, this, this.$mainPanel);
            }
            {
                this.this$0 = $outer;
                this.$mainPanel = $captured_local_variable$1;
            }
        });
    }

    private final void startGeneration(@NotNull ActionListener $receiver, JPanel mainPanel) {
        String generationLocation;
        String string = generationLocation = this.getProjectLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generationLocation");
        ProjectGeneratorPeer projectGeneratorPeer = this.getPeer();
        if (projectGeneratorPeer == null) {
            Intrinsics.throwNpe();
        }
        Object object = projectGeneratorPeer.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"peer!!.settings");
        VueCliRunningGeneratorController controller = VueCliRunningGeneratorControllerKt.createVueRunningGeneratorController(string, (NpmPackageProjectGenerator.Settings)object, new MyVueRunningGeneratorListener(generationLocation), (Disposable)this);
        if (controller != null) {
            JPanel newPanel = controller.getPanel();
            this.replacePanel(mainPanel, newPanel);
            newPanel.addAncestorListener((AncestorListener)new AncestorListenerAdapter(this, controller, mainPanel){
                final /* synthetic */ VueCliProjectSettingsStep this$0;
                final /* synthetic */ VueCliRunningGeneratorController $controller;
                final /* synthetic */ JPanel $mainPanel;

                public void ancestorRemoved(@NotNull AncestorEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.$controller.stopProcess();
                    JPanel settingsPanel = this.this$0.createPanel();
                    LayoutManager layoutManager = settingsPanel.getLayout();
                    if (layoutManager == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
                    }
                    Component component = ((BorderLayout)layoutManager).getLayoutComponent("Center");
                    if (component == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.components.JBScrollPane");
                    }
                    JBScrollPane scrollPane = (JBScrollPane)component;
                    JViewport jViewport = scrollPane.getViewport();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"scrollPane.viewport");
                    Component component2 = jViewport.getView();
                    if (component2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.swing.JPanel");
                    }
                    VueCliProjectSettingsStep.access$replacePanel(this.this$0, this.$mainPanel, (JPanel)component2);
                    VueCliProjectSettingsStep.access$setFirstStepActionListener(this.this$0, this.$mainPanel);
                }
                {
                    this.this$0 = $outer;
                    this.$controller = $captured_local_variable$1;
                    this.$mainPanel = $captured_local_variable$2;
                }
            });
            this.myCreateButton.removeActionListener($receiver);
            this.myCreateButton.addActionListener(new ActionListener(controller){
                final /* synthetic */ VueCliRunningGeneratorController $controller;

                public final void actionPerformed(ActionEvent it) {
                    this.$controller.onNext();
                }
                {
                    this.$controller = vueCliRunningGeneratorController;
                }
            });
        } else {
            LayoutManager layoutManager = mainPanel.getLayout();
            if (layoutManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
            }
            UIUtil.setEnabled((Component)((BorderLayout)layoutManager).getLayoutComponent("Center"), (boolean)false, (boolean)true);
        }
    }

    public boolean checkValid() {
        String string;
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myLocationField;
        Intrinsics.checkExpressionValueIsNotNull((Object)textFieldWithBrowseButton, (String)"myLocationField");
        JTextField jTextField = textFieldWithBrowseButton.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"myLocationField.textField");
        String string2 = jTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"myLocationField.textField.text");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String text = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        if (Files.exists(Paths.get(text, new String[0]), new LinkOption[0])) {
            this.setErrorText(VueBundle.Companion.message("vue.project.generator.project.location.already.exists", new Object[0]));
            return false;
        }
        return super.checkValid();
    }

    private final void onError(String errorText) {
        this.setErrorText("Error: " + errorText);
        JButton jButton = this.myCreateButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"myCreateButton");
        jButton.setText("Close");
        JButton jButton2 = this.myCreateButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton2, (String)"myCreateButton");
        jButton2.setEnabled(true);
        if (this.process != null) {
            VueCreateProjectProcess vueCreateProjectProcess = this.process;
            if (vueCreateProjectProcess == null) {
                Intrinsics.throwNpe();
            }
            vueCreateProjectProcess.setListener((Function0<Unit>)((Function0)null));
            VueCreateProjectProcess vueCreateProjectProcess2 = this.process;
            if (vueCreateProjectProcess2 == null) {
                Intrinsics.throwNpe();
            }
            vueCreateProjectProcess2.cancel();
        }
    }

    private final void replacePanel(JPanel mainPanel, JPanel questioningPanel) {
        LayoutManager layoutManager = mainPanel.getLayout();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
        }
        Component component = ((BorderLayout)layoutManager).getLayoutComponent("Center");
        if (component == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.components.JBScrollPane");
        }
        JBScrollPane scrollPane = (JBScrollPane)component;
        scrollPane.setViewportView((Component)questioningPanel);
        mainPanel.revalidate();
        mainPanel.repaint();
    }

    private final void removeActionListeners() {
        ActionListener[] $receiver$iv;
        JButton jButton = this.myCreateButton;
        Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"myCreateButton");
        ActionListener[] actionListeners = jButton.getActionListeners();
        Intrinsics.checkExpressionValueIsNotNull((Object)actionListeners, (String)"actionListeners");
        ActionListener[] actionListenerArray = $receiver$iv = actionListeners;
        int n = actionListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ActionListener element$iv;
            ActionListener it = element$iv = actionListenerArray[i];
            this.myCreateButton.removeActionListener(it);
        }
    }

    public VueCliProjectSettingsStep(@Nullable DirectoryProjectGenerator<NpmPackageProjectGenerator.Settings> projectGenerator, @Nullable AbstractNewProjectStep.AbstractCallback<NpmPackageProjectGenerator.Settings> callback2) {
        super(projectGenerator, callback2);
    }

    public static final /* synthetic */ void access$setMyCreateButton$p(VueCliProjectSettingsStep $this, JButton jButton) {
        $this.myCreateButton = jButton;
    }

    public static final /* synthetic */ void access$startGeneration(VueCliProjectSettingsStep $this, @NotNull ActionListener $receiver, @NotNull JPanel mainPanel) {
        $this.startGeneration($receiver, mainPanel);
    }

    public static final /* synthetic */ void access$replacePanel(VueCliProjectSettingsStep $this, @NotNull JPanel mainPanel, @NotNull JPanel questioningPanel) {
        $this.replacePanel(mainPanel, questioningPanel);
    }

    public static final /* synthetic */ void access$setFirstStepActionListener(VueCliProjectSettingsStep $this, @NotNull JPanel mainPanel) {
        $this.setFirstStepActionListener(mainPanel);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/vuejs/cli/VueCliProjectSettingsStep$MyVueRunningGeneratorListener;", "Lorg/jetbrains/vuejs/cli/VueRunningGeneratorListener;", "generationLocation", "", "(Lorg/jetbrains/vuejs/cli/VueCliProjectSettingsStep;Ljava/lang/String;)V", "cancelCloseUI", "", "disableNext", "validationError", "enableNext", "error", "finishedQuestionsCloseUI", "callback", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "intellij.vuejs"})
    public final class MyVueRunningGeneratorListener
    implements VueRunningGeneratorListener {
        private final String generationLocation;

        @Override
        public void enableNext() {
            JButton jButton = VueCliProjectSettingsStep.this.myCreateButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"myCreateButton");
            jButton.setEnabled(true);
        }

        @Override
        public void disableNext(@Nullable String validationError) {
            VueCliProjectSettingsStep.this.setErrorText(validationError);
            JButton jButton = VueCliProjectSettingsStep.this.myCreateButton;
            Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"myCreateButton");
            jButton.setEnabled(false);
        }

        @Override
        public void error(@Nullable String validationError) {
            String string = validationError;
            if (string == null) {
                string = "";
            }
            VueCliProjectSettingsStep.this.onError(string);
        }

        @Override
        public void cancelCloseUI() {
            block0: {
                DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)VueCliProjectSettingsStep.this.myCreateButton);
                if (dialogWrapper == null) break block0;
                dialogWrapper.close(0);
            }
        }

        @Override
        public void finishedQuestionsCloseUI(@NotNull Function1<? super Project, Unit> callback2) {
            Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
            DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)VueCliProjectSettingsStep.this.myCreateButton);
            if (dialogWrapper != null) {
                dialogWrapper.close(0);
            }
            Runnable function2 = new Runnable(this, callback2){
                final /* synthetic */ MyVueRunningGeneratorListener this$0;
                final /* synthetic */ Function1 $callback;

                public final void run() {
                    VirtualFile projectVFolder = LocalFileSystem.getInstance().refreshAndFindFileByPath(MyVueRunningGeneratorListener.access$getGenerationLocation$p(this.this$0));
                    if (projectVFolder == null) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "Create Vue Project: can not find project directory in '%s'";
                        Object[] objectArray = new Object[]{MyVueRunningGeneratorListener.access$getGenerationLocation$p(this.this$0)};
                        Logger logger = VueCreateProjectProcess.Companion.getLOG();
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                        String string3 = string2;
                        logger.info(string3);
                    } else {
                        RecentProjectsManager recentProjectsManager = RecentProjectsManager.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)recentProjectsManager, (String)"RecentProjectsManager.getInstance()");
                        Path path = Paths.get(MyVueRunningGeneratorListener.access$getGenerationLocation$p(this.this$0), new String[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(generationLocation)");
                        recentProjectsManager.setLastProjectCreationLocation(PathUtil.toSystemIndependentName((String)((Object)path.getParent().normalize()).toString()));
                        PlatformProjectOpenProcessor.doOpenProject((VirtualFile)projectVFolder, null, (int)-1, (ProjectOpenedCallback)new ProjectOpenedCallback(this){
                            final /* synthetic */ finishedQuestionsCloseUI.function.1 this$0;

                            public final void projectOpened(Project project, Module $noName_1) {
                                if (project != null) {
                                    this.this$0.$callback.invoke((Object)project);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class));
                    }
                }
                {
                    this.this$0 = myVueRunningGeneratorListener;
                    this.$callback = function1;
                }
            };
            ApplicationManager.getApplication().invokeLater(function2, ModalityState.NON_MODAL);
        }

        public MyVueRunningGeneratorListener(String generationLocation) {
            Intrinsics.checkParameterIsNotNull((Object)generationLocation, (String)"generationLocation");
            this.generationLocation = generationLocation;
        }

        @NotNull
        public static final /* synthetic */ String access$getGenerationLocation$p(MyVueRunningGeneratorListener $this) {
            return $this.generationLocation;
        }
    }
}

