/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.data.FrameworkCommand;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class FrameworkOption {
    @NonNls
    static final String OPTION = "option";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String PATTERN = "pattern";
    @NonNls
    private static final String SHORTCUT = "shortcut";
    private final String myName;
    private final String myShortcut;
    private final ValuePattern myValuePattern;
    private final String myHelp;

    public FrameworkOption(String name, @Nullable String shortcut, @Nullable ValuePattern valuePattern, @Nullable String help) {
        this.myName = name;
        this.myShortcut = shortcut;
        this.myValuePattern = valuePattern;
        this.myHelp = help;
    }

    public String getName() {
        return this.myName;
    }

    public boolean hasShortcut() {
        return !StringUtil.isEmpty((String)this.myShortcut);
    }

    @Nullable
    public String getShortcut() {
        return this.myShortcut;
    }

    public boolean hasValue() {
        return this.myValuePattern != null;
    }

    @Nullable
    public ValuePattern getValuePattern() {
        return this.myValuePattern;
    }

    @Nullable
    public String getHelp() {
        return this.myHelp;
    }

    public void writeToElement(Element element) {
        Element option = new Element(OPTION);
        element.addContent(option);
        option.setAttribute(NAME, this.getName());
        if (this.myShortcut != null) {
            option.setAttribute(SHORTCUT, this.myShortcut);
        }
        if (this.myValuePattern != null) {
            option.setAttribute(PATTERN, this.myValuePattern.getName());
        }
        FrameworkCommand.writeHelp(option, this.myHelp);
    }

    public static FrameworkOption readFromElement(Element element, String parentName) throws SAXException {
        String shortcut;
        if (!OPTION.equals(element.getName())) {
            throw new SAXException(FrameworkBundle.message("framework.0.element.should.contain.only.1.elements", parentName, OPTION));
        }
        String name = element.getAttributeValue(NAME);
        if (StringUtil.isEmpty((String)name)) {
            throw new SAXException(FrameworkBundle.message("framework.missing.required.non.empty.attribute.0.in.1.element", NAME, OPTION));
        }
        String patternName = element.getAttributeValue(PATTERN);
        ValuePattern pattern = null;
        if (!StringUtil.isEmptyOrSpaces((String)patternName)) {
            patternName = patternName.trim();
            for (ValuePattern valuePattern : ValuePattern.values()) {
                if (!patternName.equals(valuePattern.getName())) continue;
                pattern = valuePattern;
                break;
            }
        }
        shortcut = (shortcut = element.getAttributeValue(SHORTCUT)) != null ? shortcut.trim() : shortcut;
        String help = FrameworkCommand.readHelp(element);
        return new FrameworkOption(name, shortcut, pattern, help);
    }

    public void handleInsert(InsertionContext context) {
        if (this.myValuePattern == null) {
            Document document = context.getDocument();
            document.insertString(context.getTailOffset(), (CharSequence)" ");
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
        } else {
            this.myValuePattern.handleInsert(context);
        }
    }

    public static enum ValuePattern {
        SPACE{

            @Override
            String getName() {
                return "space";
            }

            @Override
            public boolean hasSeparateValue() {
                return true;
            }

            @Override
            public void handleInsert(InsertionContext context) {
                Document document = context.getDocument();
                document.insertString(context.getTailOffset(), (CharSequence)" ");
                context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
            }

            @Override
            public boolean matches(FrameworkOption param, String part) {
                return param.getName().equals(part) || param.getShortcut() != null && param.getShortcut().equals(part);
            }
        }
        ,
        EQUALS{

            @Override
            String getName() {
                return "equals";
            }

            @Override
            public boolean hasSeparateValue() {
                return false;
            }

            @Override
            public void handleInsert(InsertionContext context) {
                Document document = context.getDocument();
                document.insertString(context.getTailOffset(), (CharSequence)"=");
                context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
            }

            @Override
            public boolean matches(FrameworkOption param, String part) {
                return part.startsWith(param.getName() + "=") || param.getShortcut() != null && part.startsWith(param.getShortcut() + "=");
            }

            @Override
            public Pair<String, String> parseOptionAndValue(String text) {
                super.parseOptionAndValue(text);
                int index = text.indexOf(61);
                if (index == -1) {
                    return Pair.create((Object)text, null);
                }
                return Pair.create((Object)text.substring(0, index), (Object)text.substring(index + 1));
            }
        };


        @NonNls
        abstract String getName();

        public abstract boolean hasSeparateValue();

        public abstract void handleInsert(InsertionContext var1);

        public Pair<String, String> parseOptionAndValue(String text) {
            if (this.hasSeparateValue()) {
                throw new IllegalStateException("Option has separate value");
            }
            return Pair.create((Object)this.getName(), null);
        }

        public abstract boolean matches(FrameworkOption var1, String var2);
    }
}

