/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ChildFocusWatcher
implements AWTEventListener,
Disposable {
    private final JComponent myParent;

    public ChildFocusWatcher(JComponent parent) {
        this.myParent = parent;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof FocusEvent) {
            FocusEvent fe = (FocusEvent)event;
            Component component = fe.getComponent();
            if (component == null) {
                return;
            }
            if (!SwingUtilities.isDescendingFrom(component, this.myParent)) {
                return;
            }
            if (fe.getID() == 1004) {
                this.onFocusGained(fe);
            } else if (fe.getID() == 1005) {
                this.onFocusLost(fe);
            }
        }
    }

    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    protected abstract void onFocusGained(FocusEvent var1);

    protected abstract void onFocusLost(FocusEvent var1);
}

