/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeWalker;
import com.intellij.sql.formatter.model.NodeWalker$WhenMappings;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlErrorFlowBlock;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.model.StepResult;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u00016B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010)\u001a\u00020*J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\rJ\u0006\u0010,\u001a\u00020*J\b\u0010-\u001a\u00020*H\u0002J\u0018\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020*H\u0002J \u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u0002052\u0006\u00100\u001a\u000201H\u0002R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00067"}, d2={"Lcom/intellij/sql/formatter/model/NodeWalker;", "", "parentBlock", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "(Lcom/intellij/sql/formatter/model/SqlFlowBlock;Ljava/util/List;Ljava/util/Map;)V", "<set-?>", "", "currIndex", "getCurrIndex", "()I", "setCurrIndex", "(I)V", "currNode", "getCurrNode", "()Lcom/intellij/lang/ASTNode;", "setCurrNode", "(Lcom/intellij/lang/ASTNode;)V", "currType", "getCurrType", "()Lcom/intellij/psi/tree/IElementType;", "setCurrType", "(Lcom/intellij/psi/tree/IElementType;)V", "n", "getN", "getNodes", "()Ljava/util/List;", "getParentBlock", "()Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "getPatterns", "()Ljava/util/Map;", "theEnd", "", "getTheEnd", "()Z", "advance", "", "toIndex", "processAll", "processCurrent", "newBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "processIteration", "processSequence", "till", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "InternalException", "intellij.database.sql.impl"})
public class NodeWalker {
    private final int n;
    private int currIndex;
    @Nullable
    private ASTNode currNode;
    @Nullable
    private IElementType currType;
    @NotNull
    private final SqlFlowBlock parentBlock;
    @NotNull
    private final List<ASTNode> nodes;
    @NotNull
    private final Map<IElementType, FlowPattern> patterns;

    public final int getN() {
        return this.n;
    }

    public final int getCurrIndex() {
        return this.currIndex;
    }

    private final void setCurrIndex(int n) {
        this.currIndex = n;
    }

    public final boolean getTheEnd() {
        return this.currIndex >= this.n;
    }

    @Nullable
    public final ASTNode getCurrNode() {
        return this.currNode;
    }

    private final void setCurrNode(ASTNode aSTNode) {
        this.currNode = aSTNode;
    }

    @Nullable
    public final IElementType getCurrType() {
        return this.currType;
    }

    private final void setCurrType(IElementType iElementType) {
        this.currType = iElementType;
    }

    public final void advance() {
        this.advance(this.currIndex + 1);
    }

    public final void advance(int toIndex) {
        this.currIndex = toIndex;
        if (this.currIndex < this.n) {
            ASTNode theNode;
            this.currNode = theNode = this.nodes.get(this.currIndex);
            this.currType = theNode.getElementType();
        } else {
            this.currNode = null;
            this.currType = null;
        }
    }

    public final void processAll() {
        while (!this.getTheEnd()) {
            this.processIteration();
        }
    }

    private final void processIteration() {
        int currTextLength;
        ASTNode aSTNode = this.currNode;
        int n = currTextLength = aSTNode != null ? aSTNode.getTextLength() : 0;
        if (currTextLength == 0) {
            this.advance();
            return;
        }
        IElementType iElementType = this.currType;
        if (iElementType == null) {
            throw (Throwable)new IllegalStateException("Something has gone wrong");
        }
        IElementType t = iElementType;
        if (t instanceof PsiErrorElement || Intrinsics.areEqual((Object)t, (Object)TokenType.ERROR_ELEMENT)) {
            SqlBlock sqlBlock;
            SqlBlock parent$iv;
            SqlRangeBlock $receiver$iv;
            int recoverIndex;
            for (recoverIndex = this.currIndex + 1; recoverIndex < this.n && SqlUtilFun.isLeaf(this.nodes.get(recoverIndex)); ++recoverIndex) {
            }
            if (this.currIndex + 1 == recoverIndex) {
                SqlLeafBlock sqlLeafBlock = new SqlErrorNodeBlock();
                SqlBlock sqlBlock2 = this.parentBlock;
                ASTNode aSTNode2 = this.currNode;
                if (aSTNode2 == null) {
                    Intrinsics.throwNpe();
                }
                ASTNode node$iv = aSTNode2;
                ((SqlLeafBlock)((Object)$receiver$iv)).setup$intellij_database_sql_impl(parent$iv, node$iv);
                sqlBlock = $receiver$iv;
            } else {
                $receiver$iv = new SqlErrorFlowBlock();
                parent$iv = this.parentBlock;
                List<ASTNode> nodes$iv = this.nodes.subList(this.currIndex, recoverIndex);
                $receiver$iv.setup$intellij_database_sql_impl(parent$iv, nodes$iv);
                sqlBlock = $receiver$iv;
            }
            SqlBlock theErrorBlock = sqlBlock;
            this.parentBlock.addNestedBlock$intellij_database_sql_impl(theErrorBlock);
            this.advance(recoverIndex);
            return;
        }
        FlowPattern pattern = this.patterns.get(t);
        if (pattern != null) {
            int nLimited;
            int n2;
            int acceptedTill = 0;
            int k = this.currIndex + 1;
            if (pattern.limitLength() == Integer.MAX_VALUE) {
                n2 = this.n;
            } else {
                int nodes$iv = k + pattern.limitLength() - 1;
                int $i$f$withSetup = this.n;
                n2 = nLimited = Math.min(nodes$iv, $i$f$withSetup);
            }
            while (k <= nLimited && acceptedTill == 0) {
                ASTNode node = k < this.n ? this.nodes.get(k) : null;
                ++k;
                if (node != null) {
                    IElementType t_k;
                    if (node instanceof PsiErrorElement) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)node.getElementType(), (String)"node.elementType");
                    if (t_k == TokenType.WHITE_SPACE) continue;
                }
                StepResult r = pattern.input(node);
                switch (NodeWalker$WhenMappings.$EnumSwitchMapping$0[r.ordinal()]) {
                    case 1: {
                        acceptedTill = -1;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        acceptedTill = k - 1;
                        break;
                    }
                    case 4: {
                        acceptedTill = k;
                    }
                }
            }
            while (acceptedTill > this.currIndex && pattern.rollback(this.nodes.get(acceptedTill - 1))) {
                --acceptedTill;
            }
            int n3 = acceptedTill - this.currIndex;
            if (n3 == 1) {
                this.processCurrent((SqlBlock)pattern.getBlockConstructor().invoke(), pattern.getRole());
            } else if (n3 >= 2) {
                SqlRangeBlock sqlRangeBlock;
                SqlBlock newBlock = (SqlBlock)pattern.getBlockConstructor().invoke();
                try {
                    SqlBlock sqlBlock = newBlock;
                    if (sqlBlock == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.formatter.model.SqlRangeBlock");
                    }
                    sqlRangeBlock = (SqlRangeBlock)sqlBlock;
                }
                catch (ClassCastException cce) {
                    StringBuilder stringBuilder = new StringBuilder().append("\n                |Problem with processing flow in the ").append(Reflection.getOrCreateKotlinClass(this.parentBlock.getClass()).getSimpleName()).append(":\n                |Failed to setup ").append(Reflection.getOrCreateKotlinClass(newBlock.getClass()).getSimpleName()).append(" as a SqlRangeBlock for ").append(n3).append(" AST nodes.\n                |AST nodes: ").append(CollectionsKt.joinToString$default((Iterable)this.nodes.subList(this.currIndex, acceptedTill), null, null, null, (int)0, null, (Function1)processIteration.newRangeBlock.message.1.INSTANCE, (int)31, null)).append("\n                |Text:\n                |---- 8< ----\n                |");
                    CharSequence charSequence = this.parentBlock.getContext().getText();
                    int n4 = this.nodes.get(this.currIndex).getStartOffset();
                    TextRange textRange = this.nodes.get(acceptedTill - 1).getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"nodes[acceptedTill-1].textRange");
                    String message2 = StringsKt.trimMargin$default((String)stringBuilder.append(charSequence.subSequence(n4, textRange.getEndOffset())).append("\n                |---- >8 ----\n              ").toString(), null, (int)1, null);
                    throw (Throwable)new InternalException(message2, cce);
                }
                SqlRangeBlock newRangeBlock2 = sqlRangeBlock;
                this.processSequence(acceptedTill, newRangeBlock2, pattern.getRole());
            } else {
                this.processCurrent();
            }
        } else {
            this.processCurrent();
        }
    }

    private final void processCurrent() {
        ASTNode aSTNode = this.currNode;
        if (aSTNode == null) {
            throw (Throwable)new IllegalStateException(this.getTheEnd() ? "The end of list is reached" : "Something has gone wrong: the node is null when the index is " + this.currIndex + " of " + this.n);
        }
        ASTNode theNode = aSTNode;
        SqlBlock newBlock = this.parentBlock.makeBlock(theNode);
        if (newBlock.getRole() == BlockRole.NOTHING) {
            newBlock.setRole(this.parentBlock.determineRole$intellij_database_sql_impl(theNode));
        }
        this.parentBlock.addNestedBlock$intellij_database_sql_impl(newBlock);
        this.advance();
    }

    /*
     * WARNING - void declaration
     */
    private final void processCurrent(SqlBlock newBlock, BlockRole role) {
        ASTNode aSTNode = this.currNode;
        if (aSTNode == null) {
            throw (Throwable)new IllegalStateException(this.getTheEnd() ? "The end of list is reached" : "Something has gone wrong: the node is null when the index is " + this.currIndex + " of " + this.n);
        }
        ASTNode theNode = aSTNode;
        SqlBlock sqlBlock = newBlock;
        if (sqlBlock instanceof SqlNodeBlock) {
            void $receiver$iv;
            SqlNodeBlock sqlNodeBlock = (SqlNodeBlock)newBlock;
            SqlBlock parent$iv = this.parentBlock;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, theNode);
        } else if (sqlBlock instanceof SqlRangeBlock) {
            SqlRangeBlock $receiver$iv = (SqlRangeBlock)newBlock;
            SqlBlock parent$iv = this.parentBlock;
            List nodes$iv = CollectionsKt.listOf((Object)theNode);
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, nodes$iv);
        } else if (sqlBlock instanceof SqlLeafBlock) {
            SqlLeafBlock $receiver$iv = (SqlLeafBlock)newBlock;
            SqlBlock parent$iv = this.parentBlock;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, theNode);
        } else if (sqlBlock instanceof SqlRootBlock) {
            throw (Throwable)new IllegalArgumentException("Cannot create a root block from NodeWalker");
        }
        if (role != BlockRole.NOTHING) {
            newBlock.setRole(role);
        }
        this.parentBlock.addNestedBlock$intellij_database_sql_impl(newBlock);
        this.advance();
    }

    /*
     * WARNING - void declaration
     */
    private final void processSequence(int till, SqlRangeBlock newBlock, BlockRole role) {
        void $receiver$iv;
        boolean bl;
        boolean bl2 = bl = till <= this.n;
        if (_Assertions.ENABLED && !bl) {
            String string = "Sublist exceeds the node list: till " + till + " of " + this.n;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<ASTNode> subList = this.nodes.subList(this.currIndex, till);
        SqlRangeBlock $i$a$1$assert = newBlock;
        SqlBlock parent$iv = this.parentBlock;
        $receiver$iv.setup$intellij_database_sql_impl(parent$iv, subList);
        if (role != BlockRole.NOTHING) {
            newBlock.setRole(role);
        }
        this.parentBlock.addNestedBlock$intellij_database_sql_impl(newBlock);
        this.advance(till);
    }

    @NotNull
    public final SqlFlowBlock getParentBlock() {
        return this.parentBlock;
    }

    @NotNull
    public final List<ASTNode> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final Map<IElementType, FlowPattern> getPatterns() {
        return this.patterns;
    }

    public NodeWalker(@NotNull SqlFlowBlock parentBlock, @NotNull List<? extends ASTNode> nodes2, @NotNull Map<IElementType, ? extends FlowPattern> patterns2) {
        Intrinsics.checkParameterIsNotNull((Object)parentBlock, (String)"parentBlock");
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        Intrinsics.checkParameterIsNotNull(patterns2, (String)"patterns");
        this.parentBlock = parentBlock;
        this.nodes = nodes2;
        this.patterns = patterns2;
        this.n = this.nodes.size();
        ASTNode aSTNode = this.currNode = this.n > 0 ? (ASTNode)CollectionsKt.first(this.nodes) : null;
        this.currType = aSTNode != null ? aSTNode.getElementType() : null;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/NodeWalker$InternalException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "intellij.database.sql.impl"})
    public static final class InternalException
    extends RuntimeException {
        public InternalException(@NotNull String message2, @Nullable Exception exception) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            super(message2, exception);
        }
    }
}

