/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSessionToolWindowHelper;
import com.intellij.database.console.session.VisibleDatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.audit.DatabaseSessionLogger;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.BaseSessionView;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.EventListener;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DatabaseSessionView
extends BaseSessionView<DatabaseSessionView, VisibleDatabaseSession>
implements Disposable.Parent {
    private static final Logger LOG = Logger.getInstance(DatabaseSessionView.class);
    private static final String PROMPT = "sql> ";
    private static final String INDENT = StringUtil.repeat((String)" ", (int)"sql> ".length());
    private final EventDispatcher<Listener> myEventDispatcher;

    public DatabaseSessionView(@NotNull LanguageConsoleView languageConsole, @NotNull VisibleDatabaseSession session2, @NotNull DataBus.Consuming messageBus) {
        if (languageConsole == null) {
            DatabaseSessionView.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DatabaseSessionView.$$$reportNull$$$0(1);
        }
        if (messageBus == null) {
            DatabaseSessionView.$$$reportNull$$$0(2);
        }
        super(languageConsole.getProject(), messageBus, languageConsole, DatabaseSessionToolWindowHelper.INSTANCE, session2);
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        languageConsole.setPrompt(PROMPT);
    }

    public boolean isToolWindowContentPresent() {
        return this.getContent().getManager() != null;
    }

    public void addListener(@NotNull Listener listener, @NotNull Disposable parent2) {
        if (listener == null) {
            DatabaseSessionView.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            DatabaseSessionView.$$$reportNull$$$0(4);
        }
        this.myEventDispatcher.addListener((EventListener)listener, parent2);
    }

    public void beforeTreeDispose() {
        ContentManager contentManager;
        Project project = this.getProject();
        ToolWindow window = this.getToolWindowHelper().getToolWindow(project);
        ContentManager contentManager2 = contentManager = window == null ? null : window.getContentManager();
        if (contentManager == null) {
            return;
        }
        Content[] contents = contentManager.getContents();
        if (contents.length == 1 && contents[0] == this.getContent()) {
            DatabaseSessionToolWindowHelper.stopTrackToolWindowState(project);
        }
    }

    @Override
    @NotNull
    protected SessionLogger createAuditor() {
        DatabaseSessionLogger databaseSessionLogger = new DatabaseSessionLogger(this);
        if (databaseSessionLogger == null) {
            DatabaseSessionView.$$$reportNull$$$0(5);
        }
        return databaseSessionLogger;
    }

    @Override
    public void addRequestToHistory(@NotNull DataRequest.Context context) {
        boolean isRequestedQuery;
        String query;
        if (context == null) {
            DatabaseSessionView.$$$reportNull$$$0(6);
        }
        boolean isNotEmpty = !StringUtil.isEmpty((String)(query = context.getQuery()));
        boolean isConsoleRequest = isNotEmpty && context.request instanceof ConsoleDataRequest;
        boolean bl = isRequestedQuery = isConsoleRequest && StringUtil.equalsIgnoreWhitespaces((CharSequence)query, (CharSequence)((ConsoleDataRequest)context.request).query);
        if (isRequestedQuery) {
            String text2 = ((LocalDataSource)((VisibleDatabaseSession)this.getSession()).getTarget()).getDbms().isTransactSql() ? query : query + ";";
            ConsoleHistoryController.addToHistory((LanguageConsoleView)this.getConsoleView(), (String)text2);
        }
        super.addRequestToHistory(context);
    }

    @Override
    protected void buildConsoleUi(boolean focused) {
        this.getUi().getDefaults().initTabDefaults(0, this.getToolWindowHelper().getToolWindowId(), null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getConsoleView().getComponent(), (Object)"Center");
        String title = DatabaseMessages.message((String)"jdbc.console.tab.title.console", (Object[])new Object[0]);
        JComponent toFocus = this.getConsoleView().getHistoryViewer().getContentComponent();
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, title, AllIcons.Debugger.Console, toFocus);
        DefaultActionGroup outputActions = new DefaultActionGroup();
        DbUIUtil.addLeftToolbarConsoleActions(outputActions, (ConsoleView)this.getConsoleView());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getConsoleView().getComponent());
        this.setupActions();
        this.getConsoleView().setConsoleEditorEnabled(false);
        if (focused) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(this.getConsoleView().getVirtualFile(), true);
        }
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
        ((Listener)this.myEventDispatcher.getMulticaster()).initialized();
    }

    void setupActions() {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (this.clientsStream().anyMatch(c2 -> c2 instanceof DatabaseScriptingSessionClient)) {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction specificActionGroup = actionManager.getAction("Console.Dialect.SpecificGroup");
            if (specificActionGroup != null) {
                consoleActions.add(specificActionGroup);
            }
            consoleActions.addSeparator();
            consoleActions.add(actionManager.getAction("Database.Settings"));
            consoleActions.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getConsoleView()).getBrowseHistory());
            consoleActions.add(this.getUi().getOptions().getLayoutActions());
            consoleActions.addSeparator();
        }
        consoleActions.add(ActionManager.getInstance().getAction("Console.Jdbc.Terminate"));
        for (AnAction action : consoleActions.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        this.getUi().getOptions().setLeftToolbar((ActionGroup)consoleActions, "toolbar");
    }

    @Override
    protected void onLineBreak(@NotNull LanguageConsoleView console) {
        if (console == null) {
            DatabaseSessionView.$$$reportNull$$$0(7);
        }
        console.print(INDENT, ConsoleViewContentType.USER_INPUT);
    }

    @Override
    protected boolean readyToDie() {
        return this.clientsStream().noneMatch(c2 -> c2.isActive());
    }

    @Override
    protected void destroySession() {
        DatabaseSessionClient<?>[] clients = ((VisibleDatabaseSession)this.getSession()).getClients();
        if (clients.length == 0) {
            super.destroySession();
            return;
        }
        for (DatabaseSessionClient<?> client : clients) {
            try {
                Disposer.dispose(client);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    @NotNull
    private Stream<DatabaseSessionClient<?>> clientsStream() {
        Stream<DatabaseSessionClient<?>> stream = Arrays.stream(((VisibleDatabaseSession)this.getSession()).getClients());
        if (stream == null) {
            DatabaseSessionView.$$$reportNull$$$0(8);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseSessionView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseSessionView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "clientsStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRequestToHistory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onLineBreak";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener
    extends EventListener {
        public void initialized();
    }
}

