/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseObjectsPreparer {
    @NotNull
    public abstract Result prepare(@NotNull Collection<DbElement> var1);

    @NotNull
    public DatabaseObjectsPreparer onlyIf(@NotNull Condition<Collection<DbElement>> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(0);
        }
        ConditionP conditionP = new ConditionP(condition, this);
        if (conditionP == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(1);
        }
        return conditionP;
    }

    @NotNull
    public DatabaseObjectsPreparer onlyIfSingleElement(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(2);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.onlyIf((Condition<Collection<DbElement>>)((Condition)c2 -> {
            if (condition == null) {
                DatabaseObjectsPreparer.$$$reportNull$$$0(21);
            }
            return ContainerUtil.count((Iterable)c2, (Condition)condition) == 1;
        }));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(3);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer onlyIfMoreThanOnce(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(4);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.onlyIf((Condition<Collection<DbElement>>)((Condition)c2 -> {
            if (condition == null) {
                DatabaseObjectsPreparer.$$$reportNull$$$0(20);
            }
            return ContainerUtil.count((Iterable)c2, (Condition)condition) > 1;
        }));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(5);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer then(@NotNull DatabaseObjectsPreparer preparer) {
        if (preparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(6);
        }
        TunnelP tunnelP = new TunnelP(this, preparer);
        if (tunnelP == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(7);
        }
        return tunnelP;
    }

    @NotNull
    public DatabaseObjectsPreparer mapAppend(@NotNull Function<DbElement, DbElement> mapper) {
        if (mapper == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(8);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new FunP(c2 -> {
            if (mapper == null) {
                DatabaseObjectsPreparer.$$$reportNull$$$0(19);
            }
            return JBIterable.from((Iterable)c2).filterMap(mapper).append((Iterable)c2).unique().toList();
        }));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(9);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer filter(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(10);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.filter((Condition<DbElement>)DasUtil.byKind((ObjectKind)kind));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(11);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer endIf() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this;
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(12);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer filter(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(13);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new FunP(c2 -> {
            if (condition == null) {
                DatabaseObjectsPreparer.$$$reportNull$$$0(18);
            }
            return ContainerUtil.filter((Collection)c2, (Condition)condition);
        }));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(14);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer requireNotEmpty() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    1.$$$reportNull$$$0(0);
                }
                ResultImpl resultImpl = new ResultImpl(elements, false, !elements.isEmpty());
                if (resultImpl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return resultImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepare";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepare";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(15);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer finish() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new Last());
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(16);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public static DatabaseObjectsPreparer idle() {
        DatabaseObjectsPreparer databaseObjectsPreparer = new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    2.$$$reportNull$$$0(0);
                }
                ResultImpl resultImpl = new ResultImpl(elements, false, true);
                if (resultImpl == null) {
                    2.$$$reportNull$$$0(1);
                }
                return resultImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepare";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepare";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(17);
        }
        return databaseObjectsPreparer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preparer";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyIf";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyIfSingleElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyIfMoreThanOnce";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "then";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapAppend";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "endIf";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotEmpty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "finish";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "idle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onlyIf";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onlyIfSingleElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onlyIfMoreThanOnce";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "then";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapAppend";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filter$3";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mapAppend$2";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onlyIfMoreThanOnce$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onlyIfSingleElement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Last
    extends DatabaseObjectsPreparer {
        private Last() {
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                Last.$$$reportNull$$$0(0);
            }
            ResultImpl resultImpl = new ResultImpl(elements, true, true);
            if (resultImpl == null) {
                Last.$$$reportNull$$$0(1);
            }
            return resultImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$Last";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$Last";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TunnelP
    extends DatabaseObjectsPreparer {
        private final DatabaseObjectsPreparer myBase;
        private final DatabaseObjectsPreparer myNext;

        private TunnelP(@NotNull DatabaseObjectsPreparer base, @NotNull DatabaseObjectsPreparer next) {
            if (base == null) {
                TunnelP.$$$reportNull$$$0(0);
            }
            if (next == null) {
                TunnelP.$$$reportNull$$$0(1);
            }
            this.myBase = base;
            this.myNext = next;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            Result result2;
            if (elements == null) {
                TunnelP.$$$reportNull$$$0(2);
            }
            Result result3 = (result2 = this.myBase.prepare(elements)).isFinal() || !result2.isValid() ? result2 : this.myNext.prepare(result2.get());
            if (result3 == null) {
                TunnelP.$$$reportNull$$$0(3);
            }
            return result3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "next";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FunP
    extends DatabaseObjectsPreparer {
        private final Function<Collection<DbElement>, Collection<DbElement>> myFun;

        private FunP(@NotNull Function<Collection<DbElement>, Collection<DbElement>> fun) {
            if (fun == null) {
                FunP.$$$reportNull$$$0(0);
            }
            this.myFun = fun;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                FunP.$$$reportNull$$$0(1);
            }
            ResultImpl resultImpl = new ResultImpl((Collection)this.myFun.fun(elements), false, true);
            if (resultImpl == null) {
                FunP.$$$reportNull$$$0(2);
            }
            return resultImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fun";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$FunP";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$FunP";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConditionP
    extends DatabaseObjectsPreparer {
        private static final Result INVALID_RESULT = new ResultImpl(ContainerUtil.emptyList(), false, false);
        private static final DatabaseObjectsPreparer INVALID = new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    1.$$$reportNull$$$0(0);
                }
                Result result2 = INVALID_RESULT;
                if (result2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepare";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepare";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        private final Condition<Collection<DbElement>> myCondition;
        private final DatabaseObjectsPreparer myBase;
        private DatabaseObjectsPreparer myOnTrue;

        private ConditionP(@NotNull Condition<Collection<DbElement>> condition, @NotNull DatabaseObjectsPreparer base) {
            if (condition == null) {
                ConditionP.$$$reportNull$$$0(0);
            }
            if (base == null) {
                ConditionP.$$$reportNull$$$0(1);
            }
            this(condition, base, INVALID);
        }

        private ConditionP(@NotNull Condition<Collection<DbElement>> condition, @NotNull DatabaseObjectsPreparer base, @NotNull DatabaseObjectsPreparer onTrue) {
            if (condition == null) {
                ConditionP.$$$reportNull$$$0(2);
            }
            if (base == null) {
                ConditionP.$$$reportNull$$$0(3);
            }
            if (onTrue == null) {
                ConditionP.$$$reportNull$$$0(4);
            }
            this.myCondition = condition;
            this.myBase = base;
            this.myOnTrue = onTrue;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            Result base;
            if (elements == null) {
                ConditionP.$$$reportNull$$$0(5);
            }
            Collection<DbElement> nextElements = (base = this.myBase.prepare(elements)).isValid() ? base.get() : elements;
            Result result2 = base.isFinal() || !base.isValid() || !this.myCondition.value(nextElements) ? base : this.myOnTrue.prepare(nextElements);
            if (result2 == null) {
                ConditionP.$$$reportNull$$$0(6);
            }
            return result2;
        }

        @Override
        @NotNull
        public DatabaseObjectsPreparer then(@NotNull DatabaseObjectsPreparer preparer) {
            if (preparer == null) {
                ConditionP.$$$reportNull$$$0(7);
            }
            this.myOnTrue = this.myOnTrue == INVALID ? preparer : new TunnelP(this.myOnTrue, preparer);
            ConditionP conditionP = this;
            if (conditionP == null) {
                ConditionP.$$$reportNull$$$0(8);
            }
            return conditionP;
        }

        @Override
        @NotNull
        public DatabaseObjectsPreparer endIf() {
            DatabaseObjectsPreparer databaseObjectsPreparer = this.myBase.then(new ConditionP(this.myCondition, ConditionP.idle(), this.myOnTrue));
            if (databaseObjectsPreparer == null) {
                ConditionP.$$$reportNull$$$0(9);
            }
            return databaseObjectsPreparer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onTrue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preparer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "then";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endIf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "then";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ResultImpl
    implements Result {
        private final Collection<DbElement> myElements;
        private final boolean myFinal;
        private final boolean myValid;

        public ResultImpl(@NotNull Collection<DbElement> elements, boolean aFinal, boolean valid) {
            if (elements == null) {
                ResultImpl.$$$reportNull$$$0(0);
            }
            this.myElements = elements;
            this.myFinal = aFinal;
            this.myValid = valid;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }

        @Override
        public Collection<DbElement> get() {
            return this.myElements;
        }

        @Override
        public boolean isFinal() {
            return this.myFinal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$ResultImpl", "<init>"));
        }
    }

    static interface Result {
        public boolean isFinal();

        public boolean isValid();

        public Collection<DbElement> get();
    }
}

