/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.primary;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.Namespace;
import com.jetbrains.php.lang.parser.parsing.classes.StaticClassConstant;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.expressions.StaticScalar;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.Array;

public class Scalar {
    private static final TokenSet ENCAPS_LIST = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.HEREDOC_CONTENTS, PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.ESCAPE_SEQUENCE, PhpTokenTypes.EXEC_COMMAND});

    public static IElementType parse(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.VARIABLE_NAME)) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            marker.done(PhpStubElementTypes.VARIABLE);
            return PhpStubElementTypes.VARIABLE;
        }
        IElementType result = StaticClassConstant.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        if (builder.compare(PhpTokenTypes.IDENTIFIER) || builder.compare(PhpTokenTypes.NAMESPACE_RESOLUTION) || builder.compare(PhpTokenTypes.kwNAMESPACE)) {
            PsiBuilder.Marker marker = builder.mark();
            Namespace.parseReference(builder);
            builder.advanceLexer();
            marker.done(PhpElementTypes.CONSTANT_REF);
            Array.tryParsingArrayDeref(builder, marker);
            return PhpElementTypes.CONSTANT_REF;
        }
        if (builder.compare(PhpTokenTypes.HEREDOC_START)) {
            PsiBuilder.Marker marker = builder.mark();
            String identifier = builder.getTokenText();
            builder.advanceLexer();
            if (identifier == null || !identifier.endsWith("\n")) {
                builder.error(PhpParserErrors.expected("line separator"));
            }
            Scalar.parseEncapsList(builder);
            builder.match(PhpTokenTypes.HEREDOC_END);
            marker.done(PhpElementTypes.HEREDOC);
            return PhpElementTypes.HEREDOC;
        }
        if (builder.compare(PhpTokenTypes.chLDOUBLE_QUOTE)) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            Scalar.parseEncapsList(builder);
            builder.match(PhpTokenTypes.chRDOUBLE_QUOTE);
            marker.done(PhpElementTypes.STRING);
            Array.tryParsingArrayDeref(builder, marker);
            return PhpElementTypes.STRING;
        }
        result = StaticScalar.parseCommonScalar(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static void parseEncapsList(PhpPsiBuilder builder) {
        while (builder.compareAndEat(ENCAPS_LIST) || Scalar.parseEncapsVar(builder) != PhpElementTypes.EMPTY_INPUT) {
        }
    }

    private static IElementType parseEncapsVar(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
            marker.done(PhpStubElementTypes.VARIABLE);
            if (builder.compareAndEat(PhpTokenTypes.chLBRACKET)) {
                marker = marker.precede();
                PsiBuilder.Marker var = marker.precede();
                IElementType result = Scalar.parseEncapsVarOffset(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected("array index"));
                }
                builder.match(PhpTokenTypes.chRBRACKET);
                marker.done(PhpElementTypes.ARRAY_ACCESS_EXPRESSION);
                var.done(PhpStubElementTypes.VARIABLE);
                return PhpElementTypes.ARRAY_ACCESS_EXPRESSION;
            }
            if (builder.compareAndEat(PhpTokenTypes.ARROW)) {
                marker = marker.precede();
                PsiBuilder.Marker var = marker.precede();
                builder.match(PhpTokenTypes.IDENTIFIER);
                marker.done(PhpElementTypes.FIELD_REFERENCE);
                var.done(PhpStubElementTypes.VARIABLE);
                return PhpElementTypes.FIELD_REFERENCE;
            }
            return PhpStubElementTypes.VARIABLE;
        }
        if (builder.compareAndEat(PhpTokenTypes.chLBRACE) || builder.compareAndEat(PhpTokenTypes.DOLLAR_LBRACE)) {
            PsiBuilder.Marker v = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.VARIABLE) && builder.compareAndEat(PhpTokenTypes.chRBRACE)) {
                v.drop();
            } else {
                v.rollbackTo();
                Expression.parse(builder);
                builder.match(PhpTokenTypes.chRBRACE);
            }
            marker.done(PhpStubElementTypes.VARIABLE);
            return PhpStubElementTypes.VARIABLE;
        }
        marker.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseEncapsVarOffset(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!(builder.compareAndEat(PhpTokenTypes.IDENTIFIER) || builder.compareAndEat(PhpTokenTypes.tsINTEGERS) || builder.compareAndEat(StaticScalar.STRING_START))) {
            PsiBuilder.Marker var = builder.mark();
            if (!builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
                marker.drop();
                var.drop();
                return PhpElementTypes.EMPTY_INPUT;
            }
            var.done(PhpStubElementTypes.VARIABLE);
        }
        marker.done(PhpElementTypes.ARRAY_INDEX);
        return PhpElementTypes.ARRAY_INDEX;
    }
}

