/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.primary;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class Array {
    private static final ParserPart PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker array = builder.mark();
            PsiBuilder.Marker item = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
                PsiBuilder.Marker var = builder.mark();
                IElementType result = Variable.parse(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected("variable"));
                    var.drop();
                } else {
                    var.done(result);
                }
                item.done(PhpElementTypes.ARRAY_VALUE);
                array.drop();
                return PhpElementTypes.ARRAY_VALUE;
            }
            IElementType result = Expression.parse(builder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                boolean hash_array_element = false;
                if (builder.compare(PhpTokenTypes.opHASH_ARRAY)) {
                    hash_array_element = true;
                    item.done(PhpElementTypes.ARRAY_KEY);
                    builder.advanceLexer();
                    item = builder.mark();
                    if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
                        PsiBuilder.Marker var = builder.mark();
                        IElementType variableParseResult = Variable.parse(builder);
                        if (variableParseResult == PhpElementTypes.EMPTY_INPUT) {
                            builder.error(PhpParserErrors.expected("variable"));
                            var.drop();
                        } else {
                            var.done(variableParseResult);
                        }
                    } else {
                        result = Expression.parse(builder);
                        if (result == PhpElementTypes.EMPTY_INPUT) {
                            builder.error("Expected: expression");
                        }
                    }
                }
                item.done(PhpElementTypes.ARRAY_VALUE);
                if (hash_array_element) {
                    array.done(PhpElementTypes.HASH_ARRAY_ELEMENT);
                } else {
                    array.drop();
                }
                return PhpElementTypes.ARRAY_VALUE;
            }
            item.drop();
            array.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.compare(PhpTokenTypes.kwARRAY) || builder.compare(PhpTokenTypes.chLBRACKET)) {
            boolean longSyntax = builder.compareAndEat(PhpTokenTypes.kwARRAY);
            if (longSyntax) {
                builder.match(PhpTokenTypes.chLPAREN);
            } else {
                builder.match(PhpTokenTypes.chLBRACKET);
            }
            ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, PART.parse(builder), PART, true, true);
            if (longSyntax) {
                builder.match(PhpTokenTypes.chRPAREN);
            } else {
                builder.match(PhpTokenTypes.chRBRACKET);
            }
            marker.done(PhpElementTypes.ARRAY_CREATION_EXPRESSION);
            boolean access = false;
            Array.tryParsingArrayDeref(builder, marker);
            return access ? PhpElementTypes.ARRAY_ACCESS_EXPRESSION : PhpElementTypes.ARRAY_CREATION_EXPRESSION;
        }
        marker.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static void tryParsingArrayDeref(PhpPsiBuilder builder, PsiBuilder.Marker scalar) {
        while (builder.compareAndEat(PhpTokenTypes.chLBRACKET)) {
            scalar = scalar.precede();
            PsiBuilder.Marker index = builder.mark();
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected("array index"));
            }
            index.done(PhpElementTypes.ARRAY_INDEX);
            builder.match(PhpTokenTypes.chRBRACKET);
            scalar.done(PhpElementTypes.ARRAY_ACCESS_EXPRESSION);
        }
    }
}

