/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.expressions.TernaryExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.NewExpression;

public class AssignmentExpression {
    private static final ParserPart ASSIGNMENT_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            if (builder.compareAndEat(PhpTokenTypes.kwLIST)) {
                builder.match(PhpTokenTypes.chLPAREN);
                AssignmentExpression.parseAssignmentList(builder);
                builder.match(PhpTokenTypes.chRPAREN);
                return PhpStubElementTypes.VARIABLE;
            }
            PsiBuilder.Marker marker = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.opBIT_AND)) {
                Variable.parse(builder);
            } else {
                Expression.parse(builder);
            }
            if (builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY)) {
                marker.drop();
            } else {
                marker.rollbackTo();
            }
            builder.compareAndEat(PhpTokenTypes.opBIT_AND);
            marker = builder.mark();
            IElementType result = Variable.parse(builder);
            if (PhpElementTypes.ASSIGNABLE.contains(result)) {
                marker.done(result);
            } else {
                marker.drop();
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    return PhpElementTypes.EMPTY_EXPRESSION;
                }
                builder.error("Expression is not assignable");
            }
            return result;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = AssignmentExpression.parseWithoutPriority(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        PsiBuilder.Marker marker = builder.mark();
        result = TernaryExpression.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT && builder.compare(PhpTokenTypes.tsASGN_OPS)) {
            IElementType type;
            IElementType iElementType = type = result == PhpElementTypes.ARRAY_CREATION_EXPRESSION ? PhpElementTypes.MULTIASSIGNMENT_EXPRESSION : PhpElementTypes.ASSIGNMENT_EXPRESSION;
            if (result != PhpElementTypes.ARRAY_CREATION_EXPRESSION && !PhpElementTypes.ASSIGNABLE.contains(result)) {
                builder.error("Expression is not assignable: " + result);
            }
            builder.advanceLexer();
            PsiBuilder.Marker expression = builder.mark();
            result = AssignmentExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                expression.drop();
                builder.error("Expected: expression");
            } else if (type != PhpElementTypes.MULTIASSIGNMENT_EXPRESSION) {
                expression.drop();
            } else {
                expression.done(PhpElementTypes.EXPRESSION);
            }
            marker.done(type);
            return type;
        }
        marker.drop();
        return result;
    }

    public static IElementType parseWithoutPriority(PhpPsiBuilder builder) {
        IElementType type;
        PsiBuilder.Marker marker = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwLIST)) {
            builder.match(PhpTokenTypes.chLPAREN);
            AssignmentExpression.parseAssignmentList(builder);
            builder.match(PhpTokenTypes.chRPAREN);
            builder.match(PhpTokenTypes.opASGN);
            PsiBuilder.Marker value = builder.mark();
            IElementType result = TernaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                value.drop();
                builder.error("Expected: expression");
            } else {
                value.done(PhpElementTypes.EXPRESSION);
            }
            marker.done(PhpElementTypes.MULTIASSIGNMENT_EXPRESSION);
            return PhpElementTypes.MULTIASSIGNMENT_EXPRESSION;
        }
        if (!builder.compare(Variable.START_TOKENS)) {
            marker.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
        IElementType result = Variable.parseAssignable(builder);
        if (result == PhpElementTypes.EMPTY_INPUT || !builder.compare(PhpTokenTypes.tsASGN_OPS)) {
            marker.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        marker.done(result);
        marker = marker.precede();
        while ((type = builder.getTokenType()) == PhpTokenTypes.opASGN || PhpTokenTypes.tsASGN_OPS.contains(type) && !builder.eof()) {
            builder.advanceLexer();
            if (builder.compare(PhpTokenTypes.opBIT_AND)) {
                builder.advanceLexer();
                if (builder.compare(PhpTokenTypes.kwNEW)) {
                    PsiBuilder.Marker newExpr = builder.mark();
                    result = NewExpression.parse(builder);
                    newExpr.done(result);
                    result = PhpElementTypes.ASSIGNMENT_EXPRESSION;
                    marker.done(result);
                    marker = marker.precede();
                    continue;
                }
                PsiBuilder.Marker variable = builder.mark();
                IElementType var = Variable.parse(builder);
                if (var == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected("variable"));
                    variable.drop();
                } else {
                    variable.done(var);
                }
                result = PhpElementTypes.ASSIGNMENT_EXPRESSION;
                marker.done(result);
                marker = marker.precede();
                continue;
            }
            if (type == PhpTokenTypes.opASGN) {
                result = TernaryExpression.parse(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error("Expected: expression");
                }
                result = PhpElementTypes.ASSIGNMENT_EXPRESSION;
                marker.done(result);
                marker = marker.precede();
                continue;
            }
            result = TernaryExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error("Expected: expression");
            }
            result = PhpElementTypes.SELF_ASSIGNMENT_EXPRESSION;
            marker.done(result);
            marker = marker.precede();
        }
        marker.drop();
        return result;
    }

    public static void parseAssignmentList(PhpPsiBuilder builder) {
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, ASSIGNMENT_PART.parse(builder), ASSIGNMENT_PART, false);
    }
}

