/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.jetbrains.php.builtInWebServer.PhpCgiService;
import com.jetbrains.php.lang.PhpFileType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerFileHandlerKt;
import org.jetbrains.io.fastCgi.FastCgiRequest;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/php/builtInWebServer/PhpWebServerFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "pageFileExtensions", "", "", "getPageFileExtensions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.php.jsDebugger"})
final class PhpWebServerFileHandler
extends WebServerFileHandler {
    @NotNull
    private final String[] pageFileExtensions = new String[]{"php", "php5", "php4", "phtml", "hphp"};

    @NotNull
    public String[] getPageFileExtensions() {
        return this.pageFileExtensions;
    }

    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
        if (Intrinsics.areEqual((Object)pathInfo.getFileType(), (Object)((Object)PhpFileType.INSTANCE)) ^ true) {
            return false;
        }
        PhpCgiService cgiService = PhpCgiService.Companion.getInstance$intellij_php_jsDebugger(project);
        int n = cgiService.allocateRequestId(channel, extraHeaders);
        ByteBufAllocator byteBufAllocator = channel.alloc();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"channel.alloc()");
        FastCgiRequest fastCgiRequest = new FastCgiRequest(n, byteBufAllocator);
        fastCgiRequest.writeHeaders(request, channel);
        fastCgiRequest.writeFileHeaders(pathInfo, (CharSequence)WebServerFileHandlerKt.getRequestPath((CharSequence)canonicalPath, (String)projectNameIfNotCustomHost));
        ByteBuf byteBuf = request.content();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"request.content()");
        cgiService.send(fastCgiRequest, byteBuf);
        return true;
    }
}

