/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGlobalQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptClassResolver
extends JSClassResolver {
    private static final CachedValueProvider<Map<String, Collection<JSQualifiedNamedElement>>> MAP_PROVIDER = () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    private static final Key<CachedValue<Map<String, Collection<JSQualifiedNamedElement>>>> CACHE_QUALIFIED_KEY = Key.create((String)"ts.class.resolve");
    private static final Key<CachedValue<Map<String, Collection<JSQualifiedNamedElement>>>> CACHE_GLOBAL_KEY = Key.create((String)"ts.global.resolve");
    private static TypeScriptClassResolver INSTANCE = null;

    protected TypeScriptClassResolver() {
    }

    public static TypeScriptClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeScriptClassResolver();
        }
        return INSTANCE;
    }

    @Override
    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(1);
        }
        return this.findClassByQName(link, JavaScriptIndex.getInstance(context.getProject()), JSResolveUtil.getResolveScope(context), DialectOptionHolder.TS);
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQNameFilteredByConfig(@NotNull String qName, @NotNull PsiElement place) {
        PsiFile parentFile;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(2);
        }
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(3);
        }
        if ((parentFile = place.getContainingFile()) != null) {
            Map<String, Collection<JSQualifiedNamedElement>> cachedValues = TypeScriptClassResolver.getMapForKey(CACHE_QUALIFIED_KEY, parentFile);
            Collection<JSQualifiedNamedElement> elements = cachedValues.get(qName);
            if (elements == null) {
                elements = this.findElementsByQName(qName, TypeScriptConfigService.Provider.getConfigResolveScope(place), place.getProject());
                cachedValues.putIfAbsent(qName, elements);
            }
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Collection<JSQualifiedNamedElement> collection = this.findElementsByQName(qName, TypeScriptConfigService.Provider.getConfigResolveScope(place), place.getProject());
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static Map<String, Collection<JSQualifiedNamedElement>> getMapForKey(@NotNull Key<CachedValue<Map<String, Collection<JSQualifiedNamedElement>>>> key, @NotNull PsiFile parentFile) {
        if (key == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(6);
        }
        if (parentFile == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(7);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)parentFile.getProject()).getCachedValue((UserDataHolder)parentFile, key, MAP_PROVIDER, false);
        if (map == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(8);
        }
        return map;
    }

    @Override
    public boolean processElementByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Project project, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(10);
        }
        if (project == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(12);
        }
        if (!(scope instanceof GlobalSearchScopeWithIdFilter)) {
            scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)scope, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        }
        return super.processElementByQName(qName, scope, project, processor);
    }

    public Collection<JSPsiElementBase> findChildren(@NotNull String qName, @NotNull PsiElement place) {
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(13);
        }
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(14);
        }
        GlobalSearchScope baseScope = JSResolveUtil.getResolveScope(place);
        final Project project = place.getProject();
        DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(baseScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                return !(psiFile instanceof JSFile) || !((JSFile)psiFile).isCommonJSModule();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver$1", "contains"));
            }
        };
        return this.findNamespaceMembers(qName, (GlobalSearchScope)scope);
    }

    @Override
    protected PsiElement doFindClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, boolean allowFileLocalSymbols, @NotNull DialectOptionHolder dialect) {
        if (link == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Nullable
    public JSClass findAnyClassByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        List<JSClass> classes;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(18);
        }
        return (classes = this.findClassesByQName(qName, scope)).isEmpty() ? null : (JSClass)classes.iterator().next();
    }

    @NotNull
    public List<JSClass> findObjectClasses(JSClass scopeElement) {
        List<JSClass> list = this.findClassesByQName("Object", JSResolveUtil.getResolveScope((PsiElement)scopeElement));
        if (list == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findGlobalElementsByQName(@NotNull String qName, @NotNull PsiElement context) {
        PsiFile containingFile;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(20);
        }
        if (context == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(21);
        }
        if ((containingFile = context.getContainingFile()) == null) {
            Set<JSQualifiedNamedElement> set = Collections.emptySet();
            if (set == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(22);
            }
            return set;
        }
        Map<String, Collection<JSQualifiedNamedElement>> cachedValues = TypeScriptClassResolver.getMapForKey(CACHE_GLOBAL_KEY, containingFile);
        Collection<JSQualifiedNamedElement> elements = cachedValues.get(qName);
        if (elements != null) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(23);
            }
            return collection;
        }
        GlobalSearchScope scope = TypeScriptClassResolver.getGlobalTypeScriptScopeForJsOrTs(context);
        Collection<JSQualifiedNamedElement> result2 = this.findGlobalElementsByQName(qName, scope);
        if (result2.isEmpty() && DialectDetector.isTypeScript(context)) {
            result2 = this.findGlobalElementsByQName(qName, JSResolveUtil.getResolveScope(context));
        }
        cachedValues.putIfAbsent(qName, result2);
        Collection<JSQualifiedNamedElement> collection = result2;
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findGlobalElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(26);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processGlobalElementsByQName(qName, scope, (Processor<? super JSQualifiedNamedElement>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @NotNull
    public Collection<JSElement> findAllGlobalElements(@NotNull Project project, @NotNull PsiElement place) {
        if (project == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(28);
        }
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(29);
        }
        GlobalSearchScope scope = TypeScriptClassResolver.getGlobalTypeScriptScopeForJsOrTs(place);
        IdFilter filter = TypeScriptClassResolver.getFilterFromScope(scope);
        Collection collection = StubIndex.getElements(JSNamespaceMembersIndex.KEY, (Object)"", (Project)project, (GlobalSearchScope)scope, (IdFilter)filter, JSElement.class);
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(30);
        }
        return collection;
    }

    public void processGlobalElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(33);
        }
        Project project = scope.getProject();
        assert (project != null);
        IdFilter filter = TypeScriptClassResolver.getFilterFromScope(scope);
        StubIndex.getInstance().processElements(JSGlobalQualifiedElementIndex.KEY, (Object)qName.hashCode(), project, scope, filter, JSQualifiedNamedElement.class, processor);
    }

    @NotNull
    public static GlobalSearchScope getGlobalTypeScriptScopeForJsOrTs(@NotNull PsiElement place) {
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(34);
        }
        if (!DialectDetector.isTypeScript(place)) {
            GlobalSearchScope globalSearchScope = TypeScriptClassResolver.intersectWithJSLibraryScope(JSResolveUtil.getResolveScope(place));
            if (globalSearchScope == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(35);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = TypeScriptConfigService.Provider.getConfigResolveScope(place);
        if (globalSearchScope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(36);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope intersectWithJSLibraryScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(37);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
        for (JSPredefinedLibraryProvider provider2 : (JSPredefinedLibraryProvider[])JSPredefinedLibraryProvider.EP_NAME.getExtensions()) {
            files.addAll(provider2.getFilesForGlobalsProcessing());
        }
        GlobalSearchScopeWithIdFilter globalSearchScopeWithIdFilter = new GlobalSearchScopeWithIdFilter(scope, files);
        if (globalSearchScopeWithIdFilter == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(38);
        }
        return globalSearchScopeWithIdFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 3: 
            case 14: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptClassResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 10: 
            case 18: 
            case 26: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptClassResolver";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQNameFilteredByConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapForKey";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjectClasses";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findGlobalElementsByQName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGlobalElements";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalTypeScriptScopeForJsOrTs";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWithJSLibraryScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQNameFilteredByConfig";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMapForKey";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processElementByQName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findChildren";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAnyClassByQName";
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findGlobalElementsByQName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findAllGlobalElements";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalElementsByQName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalTypeScriptScopeForJsOrTs";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithJSLibraryScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

