/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerSettings {
    private final Project myProject;
    private final NodeJsInterpreterRef myInterpreterRef;
    private final NodePackage myBowerPackage;
    private final String myBowerJsonPath;

    private BowerSettings(@NotNull Builder builder) {
        if (builder == null) {
            BowerSettings.$$$reportNull$$$0(0);
        }
        this.myProject = builder.myProject;
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myBowerPackage = builder.myBowerPackage;
        this.myBowerJsonPath = FileUtil.toSystemIndependentName((String)builder.myBowerJsonPath);
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myInterpreterRef.resolve(this.myProject);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            BowerSettings.$$$reportNull$$$0(1);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodePackage getBowerPackage() {
        NodePackage nodePackage = this.myBowerPackage;
        if (nodePackage == null) {
            BowerSettings.$$$reportNull$$$0(2);
        }
        return nodePackage;
    }

    @NotNull
    public String getBowerJsonPath() {
        String string = this.myBowerJsonPath;
        if (string == null) {
            BowerSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Builder createBuilder() {
        Builder builder = new Builder(this.myProject);
        builder.setInterpreterRef(this.myInterpreterRef);
        builder.setBowerPackage(this.myBowerPackage);
        builder.setBowerJsonPath(this.myBowerJsonPath);
        Builder builder2 = builder;
        if (builder2 == null) {
            BowerSettings.$$$reportNull$$$0(4);
        }
        return builder2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BowerSettings settings = (BowerSettings)o;
        return this.myInterpreterRef.getReferenceName().equals(settings.getInterpreterRef().getReferenceName()) && this.myBowerPackage.equals(settings.myBowerPackage) && this.myBowerJsonPath.equals(settings.myBowerJsonPath);
    }

    public int hashCode() {
        int result2 = this.myInterpreterRef.getReferenceName().hashCode();
        result2 = 31 * result2 + this.myBowerPackage.hashCode();
        result2 = 31 * result2 + this.myBowerJsonPath.hashCode();
        return result2;
    }

    public String toString() {
        return "nodeInterpreter='" + this.myInterpreterRef.getReferenceName() + '\'' + ", bowerPackage='" + this.myBowerPackage + '\'' + ", bower.json='" + this.myBowerJsonPath + '\'';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBowerPackage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBowerJsonPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private final Project myProject;
        private NodeJsInterpreterRef myInterpreterRef;
        private NodePackage myBowerPackage;
        private String myBowerJsonPath;

        public Builder(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myBowerPackage = new NodePackage("");
            this.myBowerJsonPath = "";
            this.myProject = project;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setBowerPackage(@NotNull NodePackage bowerPackage) {
            if (bowerPackage == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myBowerPackage = bowerPackage;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setBowerJsonPath(@NotNull String bowerJsonPath) {
            if (bowerJsonPath == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myBowerJsonPath = bowerJsonPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public BowerSettings build() {
            BowerSettings bowerSettings = new BowerSettings(this);
            if (bowerSettings == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return bowerSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/bower/BowerSettings$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bowerPackage";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bowerJsonPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/bower/BowerSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBowerPackage";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBowerJsonPath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setBowerPackage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setBowerJsonPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

