/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.netty;

import com.intellij.docker.agent.netty.JsonObjectDecoderCopy;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class JsonObjectDecoderFixed
extends JsonObjectDecoderCopy {
    private int lastReaderIndex;

    public JsonObjectDecoderFixed() {
    }

    public JsonObjectDecoderFixed(int maxObjectLength) {
        super(maxObjectLength);
    }

    public JsonObjectDecoderFixed(boolean streamArrayElements) {
        super(streamArrayElements);
    }

    public JsonObjectDecoderFixed(int maxObjectLength, boolean streamArrayElements) {
        super(maxObjectLength, streamArrayElements);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int idx;
        if (this.state == -1) {
            in.skipBytes(in.readableBytes());
            return;
        }
        int wrtIdx = in.writerIndex();
        if (wrtIdx > this.maxObjectLength) {
            in.skipBytes(in.readableBytes());
            this.reset();
            throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + wrtIdx + " bytes discarded");
        }
        for (idx = this.idx - (this.lastReaderIndex - in.readerIndex()); idx < wrtIdx; ++idx) {
            byte c = in.getByte(idx);
            if (this.state == 1) {
                this.decodeByte(c, in, idx);
                if (this.openBraces != 0) continue;
                ByteBuf json = this.extractObject(ctx, in, in.readerIndex(), idx + 1 - in.readerIndex());
                if (json != null) {
                    out.add(json);
                }
                in.readerIndex(idx + 1);
                this.reset();
                continue;
            }
            if (this.state == 2) {
                int idxNoSpaces;
                this.decodeByte(c, in, idx);
                if (this.insideString || (this.openBraces != 1 || c != 44) && (this.openBraces != 0 || c != 93)) continue;
                int i = in.readerIndex();
                while (Character.isWhitespace(in.getByte(i))) {
                    in.skipBytes(1);
                    ++i;
                }
                for (idxNoSpaces = idx - 1; idxNoSpaces >= in.readerIndex() && Character.isWhitespace(in.getByte(idxNoSpaces)); --idxNoSpaces) {
                }
                ByteBuf json = this.extractObject(ctx, in, in.readerIndex(), idxNoSpaces + 1 - in.readerIndex());
                if (json != null) {
                    out.add(json);
                }
                in.readerIndex(idx + 1);
                if (c != 93) continue;
                this.reset();
                continue;
            }
            if (c == 123 || c == 91) {
                this.initDecoding(c);
                if (this.state != 2) continue;
                in.skipBytes(1);
                continue;
            }
            if (Character.isWhitespace(c)) {
                in.skipBytes(1);
                continue;
            }
            this.state = -1;
            throw new CorruptedFrameException("invalid JSON received at byte position " + idx + ": " + ByteBufUtil.hexDump((ByteBuf)in));
        }
        this.idx = idx;
        this.lastReaderIndex = in.readerIndex();
    }
}

