/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class SiteMap
extends DefaultTreeModel {
    private Model model = null;

    public static SiteMap createTree(Model model) {
        SiteNode siteNode = new SiteNode("Sites");
        return new SiteMap(siteNode, model);
    }

    public SiteMap(SiteNode siteNode, Model model) {
        super(siteNode);
        this.model = model;
    }

    public synchronized HttpMessage pollPath(HttpMessage httpMessage) {
        Object object;
        SiteNode siteNode = null;
        URI uRI = httpMessage.getRequestHeader().getURI();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 80;
        SiteNode siteNode2 = (SiteNode)this.getRoot();
        StringTokenizer stringTokenizer = null;
        String string4 = "";
        try {
            string = uRI.getScheme();
            string2 = string + "://" + uRI.getHost();
            n = uRI.getPort();
            if (n != -1) {
                string2 = string2 + ":" + n;
            }
            if ((siteNode2 = this.findChild(siteNode2, string2)) == null) {
                return null;
            }
            string3 = uRI.getPath();
            if (string3 == null) {
                string3 = "";
            }
            stringTokenizer = new StringTokenizer(string3, "/");
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (string4 == null || string4.equals("")) continue;
                if (stringTokenizer.countTokens() == 0) {
                    object = this.getLeafName(string4, httpMessage);
                    siteNode = this.findChild(siteNode2, (String)object);
                    continue;
                }
                if ((siteNode2 = this.findChild(siteNode2, string4)) != null) continue;
                return null;
            }
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        if (siteNode == null) {
            return null;
        }
        object = null;
        try {
            object = siteNode.getHistoryReference().getHttpMessage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public synchronized void addPath(HistoryReference historyReference) {
        HttpMessage httpMessage = null;
        try {
            httpMessage = historyReference.getHttpMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.addPath(historyReference, httpMessage);
    }

    public synchronized void addPath(HistoryReference historyReference, HttpMessage httpMessage) {
        URI uRI = httpMessage.getRequestHeader().getURI();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 80;
        SiteNode siteNode = (SiteNode)this.getRoot();
        StringTokenizer stringTokenizer = null;
        String string4 = "";
        try {
            string = uRI.getScheme();
            string2 = string + "://" + uRI.getHost();
            n = uRI.getPort();
            if (n != -1) {
                string2 = string2 + ":" + n;
            }
            siteNode = this.findAndAddChild(siteNode, string2, historyReference, httpMessage);
            string3 = uRI.getPath();
            if (string3 == null) {
                string3 = "";
            }
            stringTokenizer = new StringTokenizer(string3, "/");
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (string4 == null || string4.equals("")) continue;
                if (stringTokenizer.countTokens() == 0) {
                    this.findAndAddLeaf(siteNode, string4, historyReference, httpMessage);
                    continue;
                }
                siteNode = this.findAndAddChild(siteNode, string4, historyReference, httpMessage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private SiteNode findAndAddChild(SiteNode siteNode, String string, HistoryReference historyReference, HttpMessage httpMessage) throws URIException, HttpMalformedHeaderException, NullPointerException, SQLException {
        SiteNode siteNode2 = this.findChild(siteNode, string);
        if (siteNode2 == null) {
            SiteNode siteNode3 = new SiteNode(string);
            int n = siteNode.getChildCount();
            for (int i = 0; i < siteNode.getChildCount(); ++i) {
                if (string.compareTo(siteNode.getChildAt(i).toString()) >= 0) continue;
                n = i;
                break;
            }
            this.insertNodeInto(siteNode3, siteNode, n);
            siteNode2 = siteNode3;
            siteNode2.setHistoryReference(this.createReference(siteNode2, historyReference, httpMessage));
        }
        return siteNode2;
    }

    private SiteNode findChild(SiteNode siteNode, String string) {
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            SiteNode siteNode2 = (SiteNode)siteNode.getChildAt(i);
            if (!siteNode2.toString().equals(string)) continue;
            return siteNode2;
        }
        return null;
    }

    private SiteNode findAndAddLeaf(SiteNode siteNode, String string, HistoryReference historyReference, HttpMessage httpMessage) {
        String string2 = this.getLeafName(string, httpMessage);
        SiteNode siteNode2 = this.findChild(siteNode, string2);
        if (siteNode2 == null) {
            siteNode2 = new SiteNode(string2);
            siteNode2.setHistoryReference(historyReference);
            int n = siteNode.getChildCount();
            for (int i = 0; i < siteNode.getChildCount(); ++i) {
                if (string2.compareTo(siteNode.getChildAt(i).toString()) >= 0) continue;
                n = i;
                break;
            }
            this.insertNodeInto(siteNode2, siteNode, n);
        } else if (httpMessage.getResponseHeader().getStatusCode() == 200) {
            siteNode2.setHistoryReference(historyReference);
            historyReference.setSiteNode(siteNode2);
        } else {
            siteNode2.getPastHistoryReference().add(historyReference);
            historyReference.setSiteNode(siteNode2);
        }
        return siteNode2;
    }

    private String getLeafName(String string, HttpMessage httpMessage) {
        String string2 = httpMessage.getRequestHeader().getMethod() + ":" + string;
        String string3 = "";
        try {
            string3 = httpMessage.getRequestHeader().getURI().getQuery();
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        if (string3 == null) {
            string3 = "";
        }
        string2 = string2 + this.getQueryParamString(httpMessage.getParamNameSet(string3));
        string3 = "";
        if (httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            string3 = httpMessage.getRequestBody().toString();
            string2 = string2 + this.getQueryParamString(httpMessage.getParamNameSet(string3));
        }
        return string2;
    }

    private String getQueryParamString(SortedSet sortedSet) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string != null) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(string);
            }
            ++n;
        }
        String string = "";
        if (stringBuffer.length() > 0) {
            string = "(" + stringBuffer.toString() + ")";
        }
        return string;
    }

    private HistoryReference createReference(SiteNode siteNode, HistoryReference historyReference, HttpMessage httpMessage) throws HttpMalformedHeaderException, SQLException, URIException, NullPointerException {
        TreeNode[] treeNodeArray = siteNode.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < treeNodeArray.length; ++i) {
            stringBuffer.append(treeNodeArray[i].toString());
            if (i >= treeNodeArray.length - 1) continue;
            stringBuffer.append('/');
        }
        HttpMessage httpMessage2 = httpMessage.cloneRequest();
        URI uRI = new URI(stringBuffer.toString(), true);
        httpMessage2.getRequestHeader().setURI(uRI);
        httpMessage2.getRequestHeader().setMethod("GET");
        httpMessage2.getRequestBody().setBody("");
        httpMessage2.getRequestHeader().setContentLength(0);
        HistoryReference historyReference2 = new HistoryReference(this.model.getSession(), 0, httpMessage2);
        return historyReference2;
    }
}

