/*
 * Decompiled with CFR 0.152.
 */
package lts;

import lts.MyHashEntry;
import lts.StackCheck;
import lts.StateCodec;

public class MyHash
implements StackCheck {
    private MyHashEntry[] table;
    private int count = 0;

    public MyHash(int n) {
        this.table = new MyHashEntry[n];
    }

    public void put(byte[] byArray) {
        MyHashEntry myHashEntry = new MyHashEntry(byArray);
        int n = StateCodec.hash(byArray) % this.table.length;
        myHashEntry.next = this.table[n];
        this.table[n] = myHashEntry;
        ++this.count;
    }

    public void put(byte[] byArray, int n) {
        int n2 = StateCodec.hash(byArray) % this.table.length;
        MyHashEntry myHashEntry = this.table[n2];
        while (myHashEntry != null) {
            if (StateCodec.equals(myHashEntry.key, byArray)) {
                myHashEntry.value = n;
                return;
            }
            myHashEntry = myHashEntry.next;
        }
        myHashEntry = new MyHashEntry(byArray, n);
        myHashEntry.next = this.table[n2];
        this.table[n2] = myHashEntry;
        ++this.count;
    }

    public void remove(byte[] byArray) {
        MyHashEntry myHashEntry;
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashEntry myHashEntry2 = myHashEntry = this.table[n];
        while (myHashEntry != null) {
            if (StateCodec.equals(myHashEntry.key, byArray)) {
                if (myHashEntry2 == this.table[n]) {
                    this.table[n] = myHashEntry.next;
                } else {
                    myHashEntry2 = myHashEntry.next;
                }
                return;
            }
            myHashEntry2 = myHashEntry;
            myHashEntry = myHashEntry.next;
        }
    }

    public boolean onStack(byte[] byArray) {
        return this.containsKey(byArray);
    }

    public boolean containsKey(byte[] byArray) {
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashEntry myHashEntry = this.table[n];
        while (myHashEntry != null) {
            if (StateCodec.equals(myHashEntry.key, byArray)) {
                return true;
            }
            myHashEntry = myHashEntry.next;
        }
        return false;
    }

    public int get(byte[] byArray) {
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashEntry myHashEntry = this.table[n];
        while (myHashEntry != null) {
            if (StateCodec.equals(myHashEntry.key, byArray)) {
                return myHashEntry.value;
            }
            myHashEntry = myHashEntry.next;
        }
        return -99999;
    }

    public int size() {
        return this.count;
    }
}

