/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.util.InvalidParameterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokevirtualFactory
extends InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        int index = (code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF;
        ConstantMethodref cmr = classFile.getConstantPool().getConstantMethodref(index);
        if (cmr == null) {
            throw new InvalidParameterException("Invalid ConstantMethodref index");
        }
        int nbrOfParameters = cmr.getNbrOfParameters();
        ArrayList<Instruction> args = new ArrayList<Instruction>(nbrOfParameters);
        int i = nbrOfParameters;
        while (i > 0) {
            args.add(stack.pop());
            --i;
        }
        Collections.reverse(args);
        Instruction objectref = stack.pop();
        Invokevirtual instruction = new Invokevirtual(opcode, offset, lineNumber, index, objectref, args);
        if (cmr.returnAResult()) {
            stack.push(instruction);
        } else {
            list.add(instruction);
        }
        listForAnalyze.add(instruction);
        return ByteCodeConstants.NO_OF_OPERANDS[opcode];
    }
}

