/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMapping;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMappingMapCopier;
import software.amazon.awssdk.services.cognitoidentity.model.RolesMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityPoolRolesResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, GetIdentityPoolRolesResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(GetIdentityPoolRolesResponse.getter(GetIdentityPoolRolesResponse::identityPoolId)).setter(GetIdentityPoolRolesResponse.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<Map<String, String>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Roles").getter(GetIdentityPoolRolesResponse.getter(GetIdentityPoolRolesResponse::roles)).setter(GetIdentityPoolRolesResponse.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, RoleMapping>> ROLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RoleMappings").getter(GetIdentityPoolRolesResponse.getter(GetIdentityPoolRolesResponse::roleMappings)).setter(GetIdentityPoolRolesResponse.setter(Builder::roleMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleMappings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoleMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, ROLES_FIELD, ROLE_MAPPINGS_FIELD));
    private final String identityPoolId;
    private final Map<String, String> roles;
    private final Map<String, RoleMapping> roleMappings;

    private GetIdentityPoolRolesResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.roles = builder.roles;
        this.roleMappings = builder.roleMappings;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> roles() {
        return this.roles;
    }

    public final boolean hasRoleMappings() {
        return this.roleMappings != null && !(this.roleMappings instanceof SdkAutoConstructMap);
    }

    public final Map<String, RoleMapping> roleMappings() {
        return this.roleMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleMappings() ? this.roleMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoolRolesResponse)) {
            return false;
        }
        GetIdentityPoolRolesResponse other = (GetIdentityPoolRolesResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles()) && this.hasRoleMappings() == other.hasRoleMappings() && Objects.equals(this.roleMappings(), other.roleMappings());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityPoolRolesResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("Roles", this.hasRoles() ? this.roles() : null).add("RoleMappings", this.hasRoleMappings() ? this.roleMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "Roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
            case "RoleMappings": {
                return Optional.ofNullable(clazz.cast(this.roleMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityPoolRolesResponse, T> g) {
        return obj -> g.apply((GetIdentityPoolRolesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Map<String, String> roles = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, RoleMapping> roleMappings = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoolRolesResponse model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.roles(model.roles);
            this.roleMappings(model.roleMappings);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getRoles() {
            if (this.roles instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.roles;
        }

        @Override
        public final Builder roles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
            return this;
        }

        public final void setRoles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
        }

        public final Map<String, RoleMapping.Builder> getRoleMappings() {
            if (this.roleMappings instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.roleMappings != null ? CollectionUtils.mapValues(this.roleMappings, RoleMapping::toBuilder) : null;
        }

        @Override
        public final Builder roleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
            return this;
        }

        public final void setRoleMappings(Map<String, RoleMapping.BuilderImpl> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copyFromBuilder(roleMappings);
        }

        @Override
        public GetIdentityPoolRolesResponse build() {
            return new GetIdentityPoolRolesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityPoolRolesResponse> {
        public Builder identityPoolId(String var1);

        public Builder roles(Map<String, String> var1);

        public Builder roleMappings(Map<String, RoleMapping> var1);
    }
}

