/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.utils;

import java.util.Collection;
import java.util.function.Supplier;

public class ValidationUtils {
    public static <T> T nonNull(T object) {
        return ValidationUtils.nonNull(object, "object");
    }

    public static <T> T nonNull(T object, String nameOfObject) {
        if (object == null) {
            throw new IllegalArgumentException(nameOfObject + " cannot be null.");
        }
        return object;
    }

    public static <T> T nonNull(T object, Supplier<String> message) {
        if (object == null) {
            throw new IllegalArgumentException(message.get());
        }
        return object;
    }

    public static <T extends Collection<?>> T nonEmpty(T collection, String nameOfObject) {
        ValidationUtils.nonNull(collection, nameOfObject);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(nameOfObject + " cannot be empty");
        }
        return collection;
    }

    public static boolean isNonEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static String nonEmpty(String string, String nameOfObject) {
        ValidationUtils.nonNull(string, nameOfObject);
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The string is empty: " + nameOfObject);
        }
        return string;
    }

    public static String nonEmpty(String string) {
        return ValidationUtils.nonEmpty(string, "string");
    }

    public static <I, T extends Collection<I>> T nonEmpty(T collection) {
        return ValidationUtils.nonEmpty(collection, "collection");
    }

    public static void validateArg(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void validateArg(boolean condition, Supplier<String> msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg.get());
        }
    }
}

