/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSAMHeaderRecord
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Map<String, String> mAttributes = new LinkedHashMap<String, String>();

    public String getAttribute(String key) {
        return this.mAttributes.get(key);
    }

    @Deprecated
    public void setAttribute(String key, Object value) {
        this.setAttribute(key, value == null ? null : value.toString());
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.mAttributes.remove(key);
        } else {
            this.mAttributes.put(key, value);
        }
    }

    public Set<Map.Entry<String, String>> getAttributes() {
        return this.mAttributes.entrySet();
    }

    public String getId() {
        throw new UnsupportedOperationException("Method not implemented for: " + this.getClass());
    }

    protected boolean attributesEqual(AbstractSAMHeaderRecord that) {
        return this.mAttributes.equals(that.mAttributes);
    }

    protected int attributesHashCode() {
        return this.mAttributes != null ? this.mAttributes.hashCode() : 0;
    }

    abstract Set<String> getStandardTags();

    public String toString() {
        return this.getClass().getSimpleName() + this.mAttributes.toString();
    }

    public abstract String getSAMString();
}

