/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.DragEndEvent;
import com.google.gwt.event.dom.client.DragEndHandler;
import com.google.gwt.event.dom.client.DragEnterEvent;
import com.google.gwt.event.dom.client.DragEnterHandler;
import com.google.gwt.event.dom.client.DragEvent;
import com.google.gwt.event.dom.client.DragHandler;
import com.google.gwt.event.dom.client.DragLeaveEvent;
import com.google.gwt.event.dom.client.DragLeaveHandler;
import com.google.gwt.event.dom.client.DragOverEvent;
import com.google.gwt.event.dom.client.DragOverHandler;
import com.google.gwt.event.dom.client.DragStartEvent;
import com.google.gwt.event.dom.client.DragStartHandler;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.event.dom.client.DropHandler;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.GestureChangeEvent;
import com.google.gwt.event.dom.client.GestureChangeHandler;
import com.google.gwt.event.dom.client.GestureEndEvent;
import com.google.gwt.event.dom.client.GestureEndHandler;
import com.google.gwt.event.dom.client.GestureStartEvent;
import com.google.gwt.event.dom.client.GestureStartHandler;
import com.google.gwt.event.dom.client.HasAllDragAndDropHandlers;
import com.google.gwt.event.dom.client.HasAllGestureHandlers;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.HasAllTouchHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasDoubleClickHandlers;
import com.google.gwt.event.dom.client.HasErrorHandlers;
import com.google.gwt.event.dom.client.HasLoadHandlers;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.dom.client.TouchCancelEvent;
import com.google.gwt.event.dom.client.TouchCancelHandler;
import com.google.gwt.event.dom.client.TouchEndEvent;
import com.google.gwt.event.dom.client.TouchEndHandler;
import com.google.gwt.event.dom.client.TouchMoveEvent;
import com.google.gwt.event.dom.client.TouchMoveHandler;
import com.google.gwt.event.dom.client.TouchStartEvent;
import com.google.gwt.event.dom.client.TouchStartHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.impl.ImageResourcePrototype;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.LoadListener;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesLoadEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.ClippedImageImpl;
import java.util.HashMap;

public class Image
extends Widget
implements SourcesLoadEvents,
HasLoadHandlers,
HasErrorHandlers,
SourcesClickEvents,
HasClickHandlers,
HasDoubleClickHandlers,
HasAllDragAndDropHandlers,
HasAllGestureHandlers,
HasAllMouseHandlers,
HasAllTouchHandlers,
SourcesMouseEvents {
    private static final String UNHANDLED_EVENT_ATTR = "__gwtLastUnhandledEvent";
    private static HashMap<String, Element> prefetchImages = new HashMap();
    private State state;

    public static void prefetch(String url) {
        ImageElement img = Document.get().createImageElement();
        img.setSrc(url);
        prefetchImages.put(url, img);
    }

    public static void prefetch(SafeUri url) {
        Image.prefetch(url.asString());
    }

    public static Image wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        Image image = new Image(element);
        image.onAttach();
        RootPanel.detachOnWindowClose(image);
        return image;
    }

    public Image() {
        this.changeState(new UnclippedState(this));
        this.setStyleName("gwt-Image");
    }

    public Image(ImageResource resource) {
        if (resource instanceof ImageResourcePrototype.Bundle) {
            this.changeState(new ClippedState(this, resource.getSafeUri(), resource.getLeft(), resource.getTop(), resource.getWidth(), resource.getHeight()));
        } else {
            this.changeState(new UnclippedState(this, resource.getSafeUri(), resource.getWidth(), resource.getHeight()));
        }
        this.setStyleName("gwt-Image");
    }

    public Image(String url) {
        this(UriUtils.unsafeCastFromUntrustedString(url));
    }

    public Image(SafeUri url) {
        this.changeState(new UnclippedState(this, url));
        this.setStyleName("gwt-Image");
    }

    public Image(String url, int left, int top, int width, int height) {
        this(UriUtils.unsafeCastFromUntrustedString(url), left, top, width, height);
    }

    public Image(SafeUri url, int left, int top, int width, int height) {
        this.changeState(new ClippedState(this, url, left, top, width, height));
        this.setStyleName("gwt-Image");
    }

    protected Image(Element element) {
        ImageElement.as(element);
        this.setElement(element);
        this.changeState(new UnclippedState(element));
    }

    @Override
    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addHandler(handler, ClickEvent.getType());
    }

    @Override
    @Deprecated
    public void addClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
        return this.addHandler(handler, DoubleClickEvent.getType());
    }

    @Override
    public HandlerRegistration addDragEndHandler(DragEndHandler handler) {
        return this.addBitlessDomHandler(handler, DragEndEvent.getType());
    }

    @Override
    public HandlerRegistration addDragEnterHandler(DragEnterHandler handler) {
        return this.addBitlessDomHandler(handler, DragEnterEvent.getType());
    }

    @Override
    public HandlerRegistration addDragHandler(DragHandler handler) {
        return this.addBitlessDomHandler(handler, DragEvent.getType());
    }

    @Override
    public HandlerRegistration addDragLeaveHandler(DragLeaveHandler handler) {
        return this.addBitlessDomHandler(handler, DragLeaveEvent.getType());
    }

    @Override
    public HandlerRegistration addDragOverHandler(DragOverHandler handler) {
        return this.addBitlessDomHandler(handler, DragOverEvent.getType());
    }

    @Override
    public HandlerRegistration addDragStartHandler(DragStartHandler handler) {
        return this.addBitlessDomHandler(handler, DragStartEvent.getType());
    }

    @Override
    public HandlerRegistration addDropHandler(DropHandler handler) {
        return this.addBitlessDomHandler(handler, DropEvent.getType());
    }

    @Override
    public HandlerRegistration addErrorHandler(ErrorHandler handler) {
        return this.addHandler(handler, ErrorEvent.getType());
    }

    @Override
    public HandlerRegistration addGestureChangeHandler(GestureChangeHandler handler) {
        return this.addDomHandler(handler, GestureChangeEvent.getType());
    }

    @Override
    public HandlerRegistration addGestureEndHandler(GestureEndHandler handler) {
        return this.addDomHandler(handler, GestureEndEvent.getType());
    }

    @Override
    public HandlerRegistration addGestureStartHandler(GestureStartHandler handler) {
        return this.addDomHandler(handler, GestureStartEvent.getType());
    }

    @Override
    public HandlerRegistration addLoadHandler(LoadHandler handler) {
        return this.addHandler(handler, LoadEvent.getType());
    }

    @Override
    @Deprecated
    public void addLoadListener(LoadListener listener) {
        ListenerWrapper.WrappedLoadListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler(handler, MouseDownEvent.getType());
    }

    @Override
    @Deprecated
    public void addMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler(handler, MouseMoveEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler(handler, MouseOutEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler(handler, MouseOverEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler(handler, MouseUpEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler(handler, MouseWheelEvent.getType());
    }

    @Deprecated
    public void addMouseWheelListener(MouseWheelListener listener) {
        ListenerWrapper.WrappedMouseWheelListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addTouchCancelHandler(TouchCancelHandler handler) {
        return this.addDomHandler(handler, TouchCancelEvent.getType());
    }

    @Override
    public HandlerRegistration addTouchEndHandler(TouchEndHandler handler) {
        return this.addDomHandler(handler, TouchEndEvent.getType());
    }

    @Override
    public HandlerRegistration addTouchMoveHandler(TouchMoveHandler handler) {
        return this.addDomHandler(handler, TouchMoveEvent.getType());
    }

    @Override
    public HandlerRegistration addTouchStartHandler(TouchStartHandler handler) {
        return this.addDomHandler(handler, TouchStartEvent.getType());
    }

    public String getAltText() {
        return this.state.getImageElement(this).getAlt();
    }

    public int getHeight() {
        return this.state.getHeight(this);
    }

    public int getOriginLeft() {
        return this.state.getOriginLeft();
    }

    public int getOriginTop() {
        return this.state.getOriginTop();
    }

    public String getUrl() {
        return this.state.getUrl(this).asString();
    }

    public int getWidth() {
        return this.state.getWidth(this);
    }

    @Override
    public void onBrowserEvent(Event event) {
        if (event.getTypeInt() == 32768) {
            this.clearUnhandledEvent();
            this.state.onLoadEvent(this);
        }
        super.onBrowserEvent(event);
    }

    @Override
    @Deprecated
    public void removeClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.remove(this, listener);
    }

    @Override
    @Deprecated
    public void removeLoadListener(LoadListener listener) {
        ListenerWrapper.WrappedLoadListener.remove(this, listener);
    }

    @Override
    @Deprecated
    public void removeMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.remove(this, listener);
    }

    @Deprecated
    public void removeMouseWheelListener(MouseWheelListener listener) {
        ListenerWrapper.WrappedMouseWheelListener.remove(this, listener);
    }

    public void setAltText(String altText) {
        this.state.getImageElement(this).setAlt(altText);
    }

    public void setResource(ImageResource resource) {
        if (resource instanceof ImageResourcePrototype.Bundle) {
            this.state.setUrlAndVisibleRect(this, resource.getSafeUri(), resource.getLeft(), resource.getTop(), resource.getWidth(), resource.getHeight());
        } else {
            this.state.setUrl(this, resource.getSafeUri(), resource.getWidth(), resource.getHeight());
        }
    }

    public void setUrl(SafeUri url) {
        this.state.setUrl(this, url);
    }

    public void setUrl(String url) {
        this.setUrl(UriUtils.unsafeCastFromUntrustedString(url));
    }

    public void setUrlAndVisibleRect(SafeUri url, int left, int top, int width, int height) {
        this.state.setUrlAndVisibleRect(this, url, left, top, width, height);
    }

    public void setUrlAndVisibleRect(String url, int left, int top, int width, int height) {
        this.setUrlAndVisibleRect(UriUtils.unsafeCastFromUntrustedString(url), left, top, width, height);
    }

    public void setVisibleRect(int left, int top, int width, int height) {
        this.state.setVisibleRect(this, left, top, width, height);
    }

    @Override
    protected void onLoad() {
        super.onLoad();
        this.state.onLoad(this);
    }

    private void changeState(State newState) {
        this.state = newState;
    }

    private void clearUnhandledEvent() {
        if (this.state != null) {
            this.state.getImageElement(this).setPropertyString(UNHANDLED_EVENT_ATTR, "");
        }
    }

    private static class UnclippedState
    extends State {
        UnclippedState(Element element) {
            Event.sinkEvents(element, 133398655);
        }

        UnclippedState(Image image) {
            image.replaceElement(Document.get().createImageElement());
            Event.sinkEvents(image.getElement(), 32768);
            image.sinkEvents(133398655);
        }

        UnclippedState(Image image, SafeUri url) {
            this(image);
            this.setUrl(image, url);
        }

        UnclippedState(Image image, SafeUri url, int width, int height) {
            this(image, url);
            this.getImageElement(image).setWidth(width);
            this.getImageElement(image).setHeight(height);
        }

        @Override
        public int getHeight(Image image) {
            return this.getImageElement(image).getHeight();
        }

        @Override
        public ImageElement getImageElement(Image image) {
            return (ImageElement)image.getElement().cast();
        }

        @Override
        public int getOriginLeft() {
            return 0;
        }

        @Override
        public int getOriginTop() {
            return 0;
        }

        @Override
        public SafeUri getUrl(Image image) {
            return UriUtils.unsafeCastFromUntrustedString(this.getImageElement(image).getSrc());
        }

        @Override
        public int getWidth(Image image) {
            return this.getImageElement(image).getWidth();
        }

        @Override
        public void setUrl(Image image, SafeUri url) {
            image.clearUnhandledEvent();
            this.getImageElement(image).setSrc(url.asString());
        }

        @Override
        public void setUrl(Image image, SafeUri url, int width, int height) {
            this.setUrl(image, url);
            this.getImageElement(image).setWidth(width);
            this.getImageElement(image).setHeight(height);
        }

        @Override
        public void setUrlAndVisibleRect(Image image, SafeUri url, int left, int top, int width, int height) {
            image.changeState(new ClippedState(image, url, left, top, width, height));
        }

        @Override
        public void setVisibleRect(Image image, int left, int top, int width, int height) {
            image.changeState(new ClippedState(image, this.getUrl(image), left, top, width, height));
        }

        @Override
        protected String getStateName() {
            return "unclipped";
        }
    }

    private static abstract class State {
        private Scheduler.ScheduledCommand syntheticEventCommand = null;

        private State() {
        }

        public abstract int getHeight(Image var1);

        public abstract ImageElement getImageElement(Image var1);

        public abstract int getOriginLeft();

        public abstract int getOriginTop();

        public abstract SafeUri getUrl(Image var1);

        public abstract int getWidth(Image var1);

        public void onLoad(Image image) {
            String unhandledEvent = this.getImageElement(image).getPropertyString(Image.UNHANDLED_EVENT_ATTR);
            if ("load".equals(unhandledEvent)) {
                this.fireSyntheticLoadEvent(image);
            }
        }

        public void onLoadEvent(Image image) {
        }

        public abstract void setUrl(Image var1, SafeUri var2);

        public abstract void setUrl(Image var1, SafeUri var2, int var3, int var4);

        public abstract void setUrlAndVisibleRect(Image var1, SafeUri var2, int var3, int var4, int var5, int var6);

        public abstract void setVisibleRect(Image var1, int var2, int var3, int var4, int var5);

        protected void fireSyntheticLoadEvent(final Image image) {
            this.syntheticEventCommand = new Scheduler.ScheduledCommand(){

                @Override
                public void execute() {
                    if (image.state != State.this || this != State.this.syntheticEventCommand) {
                        return;
                    }
                    State.this.syntheticEventCommand = null;
                    if (!image.isAttached()) {
                        State.this.getImageElement(image).setPropertyString(Image.UNHANDLED_EVENT_ATTR, "load");
                        return;
                    }
                    NativeEvent evt = Document.get().createLoadEvent();
                    State.this.getImageElement(image).dispatchEvent(evt);
                }
            };
            Scheduler.get().scheduleDeferred(this.syntheticEventCommand);
        }

        protected abstract String getStateName();
    }

    private static class ClippedState
    extends State {
        private static final ClippedImageImpl impl = (ClippedImageImpl)GWT.create(ClippedImageImpl.class);
        private int height = 0;
        private int left = 0;
        private boolean pendingNativeLoadEvent = true;
        private int top = 0;
        private SafeUri url = null;
        private int width = 0;

        ClippedState(Image image, SafeUri url, int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.url = url;
            image.replaceElement(impl.createStructure(url, left, top, width, height));
            image.sinkEvents(133333119);
        }

        @Override
        public int getHeight(Image image) {
            return this.height;
        }

        @Override
        public ImageElement getImageElement(Image image) {
            return (ImageElement)impl.getImgElement(image).cast();
        }

        @Override
        public int getOriginLeft() {
            return this.left;
        }

        @Override
        public int getOriginTop() {
            return this.top;
        }

        @Override
        public SafeUri getUrl(Image image) {
            return this.url;
        }

        @Override
        public int getWidth(Image image) {
            return this.width;
        }

        @Override
        public void onLoadEvent(Image image) {
            this.pendingNativeLoadEvent = false;
            super.onLoadEvent(image);
        }

        @Override
        public void setUrl(Image image, SafeUri url) {
            image.changeState(new UnclippedState(image, url));
        }

        @Override
        public void setUrl(Image image, SafeUri url, int width, int height) {
            image.changeState(new UnclippedState(image, url, width, height));
        }

        @Override
        public void setUrlAndVisibleRect(Image image, SafeUri url, int left, int top, int width, int height) {
            if (!((Object)this.url).equals(url) || this.left != left || this.top != top || this.width != width || this.height != height) {
                this.url = url;
                this.left = left;
                this.top = top;
                this.width = width;
                this.height = height;
                impl.adjust(image.getElement(), url, left, top, width, height);
                if (!this.pendingNativeLoadEvent) {
                    this.fireSyntheticLoadEvent(image);
                }
            }
        }

        @Override
        public void setVisibleRect(Image image, int left, int top, int width, int height) {
            this.setUrlAndVisibleRect(image, this.url, left, top, width, height);
        }

        @Override
        protected String getStateName() {
            return "clipped";
        }
    }
}

