/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ECBlockGroupStats {
    private final long lowRedundancyBlockGroups;
    private final long corruptBlockGroups;
    private final long missingBlockGroups;
    private final long bytesInFutureBlockGroups;
    private final long pendingDeletionBlocks;
    private final Long highestPriorityLowRedundancyBlocks;

    public ECBlockGroupStats(long lowRedundancyBlockGroups, long corruptBlockGroups, long missingBlockGroups, long bytesInFutureBlockGroups, long pendingDeletionBlocks) {
        this(lowRedundancyBlockGroups, corruptBlockGroups, missingBlockGroups, bytesInFutureBlockGroups, pendingDeletionBlocks, null);
    }

    public ECBlockGroupStats(long lowRedundancyBlockGroups, long corruptBlockGroups, long missingBlockGroups, long bytesInFutureBlockGroups, long pendingDeletionBlocks, Long highestPriorityLowRedundancyBlocks) {
        this.lowRedundancyBlockGroups = lowRedundancyBlockGroups;
        this.corruptBlockGroups = corruptBlockGroups;
        this.missingBlockGroups = missingBlockGroups;
        this.bytesInFutureBlockGroups = bytesInFutureBlockGroups;
        this.pendingDeletionBlocks = pendingDeletionBlocks;
        this.highestPriorityLowRedundancyBlocks = highestPriorityLowRedundancyBlocks;
    }

    public long getBytesInFutureBlockGroups() {
        return this.bytesInFutureBlockGroups;
    }

    public long getCorruptBlockGroups() {
        return this.corruptBlockGroups;
    }

    public long getLowRedundancyBlockGroups() {
        return this.lowRedundancyBlockGroups;
    }

    public long getMissingBlockGroups() {
        return this.missingBlockGroups;
    }

    public long getPendingDeletionBlocks() {
        return this.pendingDeletionBlocks;
    }

    public boolean hasHighestPriorityLowRedundancyBlocks() {
        return this.getHighestPriorityLowRedundancyBlocks() != null;
    }

    public Long getHighestPriorityLowRedundancyBlocks() {
        return this.highestPriorityLowRedundancyBlocks;
    }

    public String toString() {
        StringBuilder statsBuilder = new StringBuilder();
        statsBuilder.append("ECBlockGroupStats=[").append("LowRedundancyBlockGroups=").append(this.getLowRedundancyBlockGroups()).append(", CorruptBlockGroups=").append(this.getCorruptBlockGroups()).append(", MissingBlockGroups=").append(this.getMissingBlockGroups()).append(", BytesInFutureBlockGroups=").append(this.getBytesInFutureBlockGroups()).append(", PendingDeletionBlocks=").append(this.getPendingDeletionBlocks());
        if (this.hasHighestPriorityLowRedundancyBlocks()) {
            statsBuilder.append(", HighestPriorityLowRedundancyBlocks=").append(this.getHighestPriorityLowRedundancyBlocks());
        }
        statsBuilder.append("]");
        return statsBuilder.toString();
    }
}

