/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.Arrays;
import org.apache.cassandra.concurrent.ExecutorLocal;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;

public class ExecutorLocals {
    private static final ExecutorLocal<TraceState> tracing = Tracing.instance;
    private static final ExecutorLocal<ClientWarn.State> clientWarn = ClientWarn.instance;
    public final TraceState traceState;
    public final ClientWarn.State clientWarnState;

    private ExecutorLocals(TraceState traceState, ClientWarn.State clientWarnState) {
        this.traceState = traceState;
        this.clientWarnState = clientWarnState;
    }

    public static ExecutorLocals create() {
        TraceState traceState = tracing.get();
        ClientWarn.State clientWarnState = clientWarn.get();
        if (traceState == null && clientWarnState == null) {
            return null;
        }
        return new ExecutorLocals(traceState, clientWarnState);
    }

    public static ExecutorLocals create(TraceState traceState) {
        ClientWarn.State clientWarnState = clientWarn.get();
        return new ExecutorLocals(traceState, clientWarnState);
    }

    public static void set(ExecutorLocals locals) {
        TraceState traceState = locals == null ? null : locals.traceState;
        ClientWarn.State clientWarnState = locals == null ? null : locals.clientWarnState;
        tracing.set(traceState);
        clientWarn.set(clientWarnState);
    }

    static {
        assert (Arrays.equals(ExecutorLocal.all, new ExecutorLocal[]{tracing, clientWarn})) : "ExecutorLocals has not been updated to reflect new ExecutorLocal.all";
    }
}

