/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.sgf;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
//import javax.swing.*;
import GoGrinder.Messages;
import GoGrinder.Main;


/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class SGFUtils {
    static String parserMsg = "";
    static final String NL = Main.NEW_LINE;
    private static int charToNum(char c) {
        if(c >= 'a' && c <= 'z')
            return c - 'a';
        return c - 'A';
    }
    
    // we pass here, when processing moves; LaBels, Marks, AddW/AddB etc. are handled in stringToPointssss() 
    public static Point stringToPoint(String s) throws SGFParseException { // if we remember String s, it is clearer in the error msg
        if(s.length() == 0){ // this error needn't stop processing the file - but we would need to leave this
          parserMsg = "No value ( [] ) for coordinates: >" + s + "<."; // labels, setup stones: we can omit this value, if
                                                          //   there are more values or delete the property (one value only)
          SGFLog.errorType = 3;                           //   ... but we cannot manage that at this place
          throw new SGFParseException(parserMsg, SGFParser.currCodePartA);
        }
        else if(s.length() != 2){
          parserMsg = "Coordinates consist of two lowercase letters; what we got: >" + s + "< " + NL + " ";
                    // + "Open the file with CGoban to get a better .";
          //String msg2 = ""; //NL + Messages.getString("invalid_coords") + " \"" 
                            //            + s + "\" " + Messages.getString("in_sgf_file"); 
          throw new SGFParseException(parserMsg, SGFParser.currCodePartA);
        }
        return new Point(charToNum(s.charAt(0)), charToNum(s.charAt(1)));
    }
    
    public static ArrayList stringToPoints(String s) throws SGFParseException {
// d.b.g( SGFParser.thisFileName + NL + "stringToPointsss(back=ArrL): " + s);
    	ArrayList list = new ArrayList();
    	if(s.length() == 2) {
    		list.add(stringToPoint(s));
    		return list;
    	}
    	s = s.trim();
    	
    	if(s.length() != 5 || s.charAt(2) != ':'){
         parserMsg = Messages.getString("invalid_coords") + " \"" + s + "\" " + Messages.getString("in_sgf_file");
         throw new SGFParseException(parserMsg, SGFParser.currCodePartA);
      }
    	Point p1 = stringToPoint(s.substring(0, 2));
    	Point p2 = stringToPoint(s.substring(3, 5));

    	int minx = Math.min(p1.x, p2.x);
    	int miny = Math.min(p1.y, p2.y);
    	int maxx = Math.max(p1.x, p2.x);
    	int maxy = Math.max(p1.y, p2.y);
    	
    	for(int x = minx; x <= maxx; x++) {
    		for(int y = miny; y <= maxy; y++) {
    			list.add(new Point(x,y));
    		}
    	}
    	
    	return list;
    }
    
    public static void checkPoint(Point p, int size) throws SGFParseException {
        if(p.x < 0 || p.x >= size || p.y < 0 || p.y >= size){ // boardsize too big, expecting coordinates max for size x size
            parserMsg = Messages.getString("invalid_coords_in_sgf") //$NON-NLS-1$ // would be nice to have the original value here
                      + " > " + numToString(p.x) + numToString(p.y) + " < (a-" + numToString(size-1) + " are allowed) - size is: " 
                      + new Integer(size).toString();                  // ... as "b5" becomes "bU" and this cannot be found
// d.b.g("checkPoint(... \n" + parserMsg, SGFParser.currCodePartA);
 throw new SGFParseException(parserMsg, SGFParser.currCodePartA); // need sgf code here (currCodePartA seems to be empty here)
        } //###########################################################################################
    }   
    
    private static String numToString(int n) {
    	return Character.toString((char)('a' + n));
    }
    
    public static String pointToString(Point p) {
    	return numToString(p.x) + numToString(p.y);
    }
    
    public static void flipPoint(int size, Point p, boolean flip, int rot) {
        if(flip)
            p.x = size - p.x - 1;
        
        for(int i = 0; i < rot; i++) {
        	rotatePoint(size, p);
        }
    }
    
    public static void rotatePoint(int size, Point p) {
    	int oldY = p.y;
    	p.y = p.x;
    	p.x = size - oldY - 1;
    }
    
    public static void printMarks(ArrayList marks, StringBuffer out, boolean format) {
    	if(marks == null || marks.size() == 0)
    		return;
    	
    	if(format)
    		out.append("  "); //$NON-NLS-1$
    	
    	Collections.sort(marks);
    	String lastMark = ""; //$NON-NLS-1$
    	
    	for (Iterator iter = marks.iterator(); iter.hasNext();) {
			NodeMark m = (NodeMark) iter.next();
			
			String tag = m.getTag();
			if(!lastMark.equals(tag)) {
				if(format && lastMark.length() > 0)
					out.append(NL + "  "); //$NON-NLS-1$
				out.append(tag);
				lastMark = tag;
			}
			
			m.printBody(out);
		}
    	
    	if(format)
    		out.append(NL); //$NON-NLS-1$
    }
}
