/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.IAliasPropertiesPanelController;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginDatabaseObjectType;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.plugin.ISessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.plugin.PluginLoadInfo;
import net.sourceforge.squirrel_sql.client.plugin.PluginLoadOrderComparator;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginStatus;
import net.sourceforge.squirrel_sql.client.plugin.SessionPluginInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.ClassLoaderListener;
import net.sourceforge.squirrel_sql.fw.util.MyURLClassLoader;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class PluginManager
implements IPluginManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PluginManager.class);
    private static final ILogger s_log = LoggerController.createLogger(PluginManager.class);
    private IApplication _app;
    private MyURLClassLoader _pluginsClassLoader;
    private final List<PluginInfo> _plugins = new ArrayList<PluginInfo>();
    private final Map<String, IPlugin> _loadedPlugins = new HashMap<String, IPlugin>();
    private final List<SessionPluginInfo> _sessionPlugins = new ArrayList<SessionPluginInfo>();
    private final Map<IIdentifier, List<SessionPluginInfo>> _activeSessions = new HashMap<IIdentifier, List<SessionPluginInfo>>();
    private final Map<String, PluginLoadInfo> _pluginLoadInfoColl = new HashMap<String, PluginLoadInfo>();
    private HashMap<IIdentifier, List<PluginSessionCallback>> _pluginSessionCallbacksBySessionID = new HashMap();
    private ClassLoaderListener classLoaderListener = null;

    public PluginManager(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
    }

    @Override
    public synchronized void sessionCreated(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        for (SessionPluginInfo spi : this._sessionPlugins) {
            try {
                spi.getSessionPlugin().sessionCreated(session);
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("PluginManager.error.sessioncreated", spi.getPlugin().getDescriptiveName());
                s_log.error(msg, th);
                this._app.showErrorDialog(msg, th);
            }
        }
    }

    @Override
    public synchronized void sessionStarted(final ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        final ArrayList<SessionPluginInfo> plugins = new ArrayList<SessionPluginInfo>();
        this._activeSessions.put(session.getIdentifier(), plugins);
        ArrayList<SessionPluginInfo> startInFG = new ArrayList<SessionPluginInfo>();
        final ArrayList<SessionPluginInfo> startInBG = new ArrayList<SessionPluginInfo>();
        for (SessionPluginInfo spi : this._sessionPlugins) {
            if (spi.getSessionPlugin().allowsSessionStartedInBackground()) {
                startInBG.add(spi);
                continue;
            }
            startInFG.add(spi);
        }
        session.setPluginsfinishedLoading(true);
        for (SessionPluginInfo spi : startInFG) {
            this.sendSessionStarted(session, spi, plugins);
        }
        session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                for (SessionPluginInfo spi : startInBG) {
                    PluginManager.this.sendSessionStarted(session, spi, plugins);
                }
                session.setPluginsfinishedLoading(true);
            }
        });
    }

    private void sendSessionStarted(ISession session, SessionPluginInfo spi, List<SessionPluginInfo> plugins) {
        try {
            PluginSessionCallback pluginSessionCallback = spi.getSessionPlugin().sessionStarted(session);
            if (null != pluginSessionCallback) {
                List<PluginSessionCallback> list = this._pluginSessionCallbacksBySessionID.get(session.getIdentifier());
                if (null == list) {
                    list = new ArrayList<PluginSessionCallback>();
                    this._pluginSessionCallbacksBySessionID.put(session.getIdentifier(), list);
                }
                list.add(pluginSessionCallback);
                plugins.add(spi);
            }
        }
        catch (Throwable th) {
            final String msg = s_stringMgr.getString("PluginManager.error.sessionstarted", spi.getPlugin().getDescriptiveName());
            s_log.error(msg, th);
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    PluginManager.this._app.showErrorDialog(msg, th);
                }
            });
        }
    }

    @Override
    public synchronized void sessionEnding(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        List<SessionPluginInfo> plugins = this._activeSessions.remove(session.getIdentifier());
        if (plugins != null) {
            for (SessionPluginInfo spi : plugins) {
                try {
                    spi.getSessionPlugin().sessionEnding(session);
                }
                catch (Throwable th) {
                    String msg = s_stringMgr.getString("PluginManager.error.sessionended", spi.getPlugin().getDescriptiveName());
                    s_log.error(msg, th);
                    this._app.showErrorDialog(msg, th);
                }
            }
            this._pluginSessionCallbacksBySessionID.remove(session.getIdentifier());
        }
    }

    @Override
    public synchronized void unloadPlugin(String pluginInternalName) {
        Object plugin;
        Iterator<Object> it = this._loadedPlugins.values().iterator();
        while (it.hasNext()) {
            plugin = it.next();
            if (!plugin.getInternalName().equals(pluginInternalName)) continue;
            plugin.unload();
            it.remove();
        }
        it = this._sessionPlugins.iterator();
        while (it.hasNext()) {
            plugin = (SessionPluginInfo)it.next();
            if (!((PluginInfo)plugin).getInternalName().equals(pluginInternalName)) continue;
            it.remove();
        }
    }

    @Override
    public synchronized void unloadPlugins() {
        for (IPlugin plugin : this._loadedPlugins.values()) {
            try {
                plugin.unload();
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("PluginManager.error.unloading", plugin.getInternalName());
                s_log.error(msg, th);
                this._app.showErrorDialog(msg, th);
            }
        }
    }

    @Override
    public synchronized PluginInfo[] getPluginInformation() {
        return this._plugins.toArray(new PluginInfo[this._plugins.size()]);
    }

    @Override
    public synchronized SessionPluginInfo[] getPluginInformation(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        List<SessionPluginInfo> list = this._activeSessions.get(session.getIdentifier());
        if (list != null) {
            return list.toArray(new SessionPluginInfo[list.size()]);
        }
        return new SessionPluginInfo[0];
    }

    @Override
    public synchronized IPluginDatabaseObjectType[] getDatabaseObjectTypes(ISession session) {
        ArrayList<IPluginDatabaseObjectType> objTypesList = new ArrayList<IPluginDatabaseObjectType>();
        List<SessionPluginInfo> plugins = this._activeSessions.get(session.getIdentifier());
        if (plugins != null) {
            for (SessionPluginInfo spi : plugins) {
                IPluginDatabaseObjectType[] objTypes = spi.getSessionPlugin().getObjectTypes(session);
                if (objTypes == null) continue;
                for (int i = 0; i < objTypes.length; ++i) {
                    objTypesList.add(objTypes[i]);
                }
            }
        }
        return objTypesList.toArray(new IPluginDatabaseObjectType[objTypesList.size()]);
    }

    @Override
    public URL[] getPluginURLs() {
        return this._pluginsClassLoader.getURLs();
    }

    @Override
    public PluginStatus[] getPluginStatuses() {
        return this._app.getSquirrelPreferences().getPluginStatuses();
    }

    @Override
    public synchronized void setPluginStatuses(PluginStatus[] values) {
        this._app.getSquirrelPreferences().setPluginStatuses(values);
    }

    @Override
    public Iterator<SessionPluginInfo> getSessionPluginIterator() {
        return this._sessionPlugins.iterator();
    }

    @Override
    public void loadPlugins() {
        int i;
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        File dir = new ApplicationFiles().getPluginsDirectory();
        boolean isMac = System.getProperty("os.name").toLowerCase().startsWith("mac");
        if (dir.isDirectory()) {
            HashMap<String, PluginStatus> pluginStatuses = new HashMap<String, PluginStatus>();
            PluginStatus[] ar = this.getPluginStatuses();
            for (i = 0; i < ar.length; ++i) {
                pluginStatuses.put(ar[i].getInternalName(), ar[i]);
            }
            File[] files = dir.listFiles();
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                this.checkPlugin(files[i], pluginStatuses, pluginUrls, isMac);
            }
        }
        Collections.sort(pluginUrls, new PluginLoadOrderComparator());
        URL[] urls = pluginUrls.toArray(new URL[pluginUrls.size()]);
        if (s_log.isDebugEnabled()) {
            for (int i2 = 0; i2 < urls.length; ++i2) {
                s_log.debug("Plugin class loader URL[" + i2 + "] = " + urls[i2]);
            }
        }
        this._pluginsClassLoader = new MyURLClassLoader(urls);
        this._pluginsClassLoader.addClassLoaderListener(this.classLoaderListener);
        Class[] classes = this._pluginsClassLoader.getAssignableClasses(IPlugin.class, s_log);
        for (i = 0; i < classes.length; ++i) {
            try {
                this.loadPlugin(classes[i]);
                continue;
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("PluginManager.error.loadpluginclass", classes[i].getName());
                th.printStackTrace();
                s_log.error(msg, th);
                this._app.showErrorDialog(msg, th);
            }
        }
        Collections.sort(this._plugins, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo arg0, PluginInfo arg1) {
                if (arg0 == null || arg1 == null) {
                    throw new NullPointerException("arg1 and arg2 must not be null");
                }
                return arg0.getInternalName().compareTo(arg1.getInternalName());
            }
        });
    }

    private void checkPlugin(File pluginFile, Map<String, PluginStatus> pluginStatuses, List<URL> pluginUrls, boolean isMac) {
        String fileName = pluginFile.getAbsolutePath();
        if (!fileName.toLowerCase().endsWith("src.jar") && (fileName.toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".jar"))) {
            try {
                if (fileName.toLowerCase().endsWith("jedit.jar")) {
                    String msg = s_stringMgr.getString("PluginManager.error.jedit");
                    this._app.showErrorDialog(msg);
                    return;
                }
                String fullFilePath = pluginFile.getAbsolutePath();
                String internalName = Utilities.removeFileNameSuffix(pluginFile.getName());
                PluginStatus ps = pluginStatuses.get(internalName);
                if (!isMac && internalName.startsWith("macosx")) {
                    s_log.info("Detected MacOS X plugin on non-Mac platform - skipping");
                    return;
                }
                if (ps != null && !ps.isLoadAtStartup()) {
                    PluginInfo pi = new PluginInfo();
                    pi.setPlugin(new MyPlaceHolderPlugin(internalName));
                    this._plugins.add(pi);
                } else {
                    pluginUrls.add(pluginFile.toURI().toURL());
                    String pluginDirName = Utilities.removeFileNameSuffix(fullFilePath);
                    File libDir = new File(pluginDirName, "lib");
                    this.addPluginLibraries(libDir, pluginUrls);
                }
            }
            catch (IOException ex) {
                String msg = s_stringMgr.getString("PluginManager.error.loadplugin", fileName);
                s_log.error(msg, ex);
                this._app.showErrorDialog(msg, ex);
            }
        }
    }

    private void addPluginLibraries(File libDir, List<URL> pluginUrls) {
        if (libDir.exists() && libDir.isDirectory()) {
            File[] libDirFiles = libDir.listFiles();
            for (int j = 0; j < libDirFiles.length; ++j) {
                String fn;
                if (!libDirFiles[j].isFile() || !(fn = libDirFiles[j].getAbsolutePath()).toLowerCase().endsWith(".zip") && !fn.toLowerCase().endsWith(".jar")) continue;
                try {
                    pluginUrls.add(libDirFiles[j].toURI().toURL());
                    continue;
                }
                catch (IOException ex) {
                    String msg = s_stringMgr.getString("PluginManager.error.loadlib", fn);
                    s_log.error(msg, ex);
                    this._app.showErrorDialog(msg, ex);
                }
            }
        }
    }

    @Override
    public void initializePlugins() {
        this._app.getWindowManager().addSessionWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetOpened(WidgetEvent e) {
                PluginManager.this.onWidgetOpened(e);
            }
        });
        for (IPlugin plugin : this._loadedPlugins.values()) {
            try {
                PluginLoadInfo pli = this.getPluginLoadInfo(plugin);
                pli.startInitializing();
                plugin.initialize();
                pli.endInitializing();
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("PluginManager.error.initplugin", plugin.getInternalName());
                s_log.error(msg, th);
                this._app.showErrorDialog(msg, th);
            }
        }
    }

    @Override
    public void setClassLoaderListener(ClassLoaderListener listener) {
        this.classLoaderListener = listener;
    }

    private void onWidgetOpened(WidgetEvent e) {
        ISession session;
        List<PluginSessionCallback> list;
        IWidget widget = e.getWidget();
        if (widget instanceof ISessionWidget && null != (list = this._pluginSessionCallbacksBySessionID.get((session = ((ISessionWidget)widget).getSession()).getIdentifier()))) {
            for (int i = 0; i < list.size(); ++i) {
                PluginSessionCallback psc = list.get(i);
                if (widget instanceof SQLInternalFrame) {
                    psc.sqlInternalFrameOpened((SQLInternalFrame)widget, session);
                    continue;
                }
                if (!(widget instanceof ObjectTreeInternalFrame)) continue;
                psc.objectTreeInternalFrameOpened((ObjectTreeInternalFrame)widget, session);
            }
        }
    }

    @Override
    public Iterator<PluginLoadInfo> getPluginLoadInfoIterator() {
        return this._pluginLoadInfoColl.values().iterator();
    }

    private void loadPlugin(Class<?> pluginClass) {
        PluginInfo pi = new PluginInfo(pluginClass.getName());
        try {
            PluginLoadInfo pli = new PluginLoadInfo();
            IPlugin plugin = (IPlugin)pluginClass.newInstance();
            pli.pluginCreated(plugin);
            this._pluginLoadInfoColl.put(plugin.getInternalName(), pli);
            pi.setPlugin(plugin);
            this._plugins.add(pi);
            if (this.validatePlugin(plugin)) {
                pli.startLoading();
                plugin.load(this._app);
                pi.setLoaded(true);
                this._loadedPlugins.put(plugin.getInternalName(), plugin);
                if (ISessionPlugin.class.isAssignableFrom(pluginClass)) {
                    this._sessionPlugins.add(new SessionPluginInfo(pi));
                }
            }
            pli.endLoading();
        }
        catch (Throwable th) {
            String msg = s_stringMgr.getString("PluginManager.error.loadpluginclass", pluginClass.getName());
            th.printStackTrace();
            s_log.error(msg, th);
            this._app.showErrorDialog(msg, th);
        }
    }

    private boolean validatePlugin(IPlugin plugin) {
        String pluginInternalName = plugin.getInternalName();
        if (pluginInternalName == null || pluginInternalName.trim().length() == 0) {
            s_log.error("Plugin " + plugin.getClass().getName() + "doesn't return a valid getInternalName()");
            return false;
        }
        if (this._loadedPlugins.get(pluginInternalName) != null) {
            s_log.error("A Plugin with the internal name " + pluginInternalName + " has already been loaded");
            return false;
        }
        try {
            ApplicationArguments.getInstance().addPluginApplicationArguments(plugin.getPluginApplicationArguments());
        }
        catch (IllegalArgumentException ex) {
            s_log.error("Plugin " + plugin.getClass().getName() + ": Calling ApplicationArguments.getInstance().addPluginApplicationArguments() failed", ex);
            return false;
        }
        return true;
    }

    private PluginLoadInfo getPluginLoadInfo(IPlugin plugin) {
        return this._pluginLoadInfoColl.get(plugin.getInternalName());
    }

    @Override
    public Object bindExternalPluginService(String internalNameOfPlugin, Class<?> toBindTo) {
        IPlugin plugin = this._loadedPlugins.get(internalNameOfPlugin);
        if (null == plugin) {
            return null;
        }
        final Object obj = plugin.getExternalService();
        if (null == obj) {
            throw new RuntimeException("The plugin " + internalNameOfPlugin + " doesn't provide any external service.");
        }
        InvocationHandler ih = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method m = obj.getClass().getMethod(method.getName(), method.getParameterTypes());
                return m.invoke(obj, args);
            }
        };
        return Proxy.newProxyInstance(this._pluginsClassLoader, new Class[]{toBindTo}, ih);
    }

    @Override
    public IAliasPropertiesPanelController[] getAliasPropertiesPanelControllers(SQLAlias alias) {
        ArrayList<IAliasPropertiesPanelController> ret = new ArrayList<IAliasPropertiesPanelController>();
        for (IPlugin plugin : this._loadedPlugins.values()) {
            IAliasPropertiesPanelController[] ctrls = plugin.getAliasPropertiesPanelControllers(alias);
            if (null == ctrls) continue;
            ret.addAll(Arrays.asList(ctrls));
        }
        return ret.toArray(new IAliasPropertiesPanelController[ret.size()]);
    }

    @Override
    public void aliasCopied(SQLAlias source, SQLAlias target) {
        for (IPlugin plugin : this._loadedPlugins.values()) {
            plugin.aliasCopied(source, target);
        }
    }

    @Override
    public void aliasRemoved(SQLAlias alias) {
        for (IPlugin plugin : this._loadedPlugins.values()) {
            plugin.aliasRemoved(alias);
        }
    }

    @Override
    public void loadPluginsFromList(List<String> pluginListIterator) {
        for (String className : pluginListIterator) {
            try {
                this.loadPlugin(Class.forName(className));
            }
            catch (Exception e) {
                s_log.error("Unable to load plugin class (" + className + ") from the classpath.  " + "This plugin was specified by one of the following program arguments : " + ApplicationArguments.IOptions.PLUGIN_LIST[0] + " or " + ApplicationArguments.IOptions.PLUGIN_LIST[1] + ". Either remove this argument, or ensure " + "that the plugin is on the CLASSPATH");
            }
        }
    }

    private static class MyPlaceHolderPlugin
    extends DefaultPlugin {
        private String _internalName = null;

        public MyPlaceHolderPlugin(String internalName) {
            this._internalName = internalName;
        }

        @Override
        public String getAuthor() {
            return "";
        }

        @Override
        public String getDescriptiveName() {
            return "";
        }

        @Override
        public String getInternalName() {
            return this._internalName;
        }

        @Override
        public String getVersion() {
            return "";
        }
    }
}

